/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : schroede.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitSchroederReverb
|
| Description : DSPKitSchroederReverb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_SCHROEDER_H_
#define _DSPKIT_SCHROEDER_H_

#include "processo.h"
#include "comb.h"
#include "allpassn.h"

class DSPKitSchroederReverb : public DSPKitProcessor
{
  public:

    DSPKitSchroederReverb ();
    long setInput (DSPKitProcessor *ip);
    long setInput (DSPKitProcessor *ip,double size,double spread);
    void setReverbTime (double rt);
    double getReverbTime () const;

  protected:

    double               reverbTime;
    DSPKitMux            mux;
    DSPKitComb           comb1;
    DSPKitComb           comb2;
    DSPKitComb           comb3;
    DSPKitComb           comb4;
    DSPKitSum            sum;
    DSPKitAmp            amp;
    DSPKitAllPassNetwork allpass1;
    DSPKitAllPassNetwork allpass2;
};

inline DSPKitSchroederReverb::DSPKitSchroederReverb ()
{
  reverbTime = 1.0;
}

inline double DSPKitSchroederReverb::getReverbTime () const
{
  return reverbTime;
}

#endif

/***************************************************************************/
