/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : stdrever.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitStdReverb
|
| Description : DSPKitStdReverb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_STDREVERB_H_
#define _DSPKIT_STDREVERB_H_

#include "processo.h"
#include "mux.h"
#include "comblowp.h"
#include "sum.h"
#include "amp.h"
#include "allpassn.h"

class DSPKitStdReverb : public DSPKitProcessor
{
  public:

    long setInput (DSPKitProcessor *ip);
    long setInput (DSPKitProcessor *ip,double size,double spread);
    void setG (double newG);
    void setReverbTime (double rt);

  protected:

    double               loopTime;
    double               reverbTime;
    DSPKitMux            mux;
    DSPKitCombLowPass    comb1;
    DSPKitCombLowPass    comb2;
    DSPKitCombLowPass    comb3;
    DSPKitCombLowPass    comb4;
    DSPKitCombLowPass    comb5;
    DSPKitCombLowPass    comb6;
    DSPKitSum            sum;
    DSPKitAmp            amp;
    DSPKitAllPassNetwork allpass;
};

#endif

/***************************************************************************/
