/*
   Main routines.    

   Gaby Description Builder
   Copyright (C) 1998  Ron Bessems
   Contact me via email at R.E.M.W.Bessems@stud.tue.nl

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "../config.h"

#ifdef USE_GNOME
  #include <gnome.h>
#else
  #include <gtk/gtk.h>	
#endif


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>

#ifdef HAVE_STRING_H
  #include <string.h>
#endif

#ifdef HAVE_UNISTD_h
  #include <unistd.h>
#endif

#ifdef ENABLE_NLS
 #ifdef HAVE_LOCALE_H
  #include <locale.h>
 #endif
 #ifdef HAVE_GETTEXT
  #include <libintl.h>
 #else
  #include <intl/libintl.h>
 #endif
  #define _(String) gettext (String)
#endif

#ifndef ENABLE_NLS
  #define _(String) (String)
#endif

#define BVERSION "0.8"

#include "type.h"

#include "shared.h"
#include "tablewin.h"
#include "previewwin.h"
#include "shared.h"
#include "desc.h"
#include "fileops.h"
#include "subtable.h"
#include "actions.h"
#include "locations.h"
#include "miscwin.h"
#include "dataops.h"
#include "actions.h"
#include "buttonwin.h"
#include "fieldprop.h"
#include "fieldwin.h"
#include "subfieldprop.h"
#include "subfieldwin.h"
#include "subtable.h"
#include "subtableprop.h"
#include "locationwin.h"
#include "sessionman.h"

GList *viewable_as;
GList *multimedia_type;
GList *format;
GtkWidget *Window;

void add_update     (GtkWidget * widget, gpointer data,
		       void (*update_func) (GtkWidget * widget, gpointer data));
void remove_update  (GtkWidget * widget);
void update_widget  (GtkWidget * widget);
void update_all     ();
void update_all_e   (GtkWidget *e);

#define NOTEBOOKVIEW
