/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs.c,v 1.76 2000/02/29 03:26:43 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#ifndef GTK_HAVE_FEATURES_1_1_0
#include "gtkfontsel.h"
#endif
#include "main.h"
#include "menu.h"
#include "file.h"
#include "dialog.h"
#include "win.h"
#include "msgbar.h"
#include "msgbox.h"
#include "toolbar.h"
#ifdef WANT_PROJECT
#include "prjbar.h"
#endif
#include "misc.h"
#include "randomtips.h"
#include "srcctrl.h"
#include "prefs.h"

#include "gnpintl.h"


/*** global variables ***/
app_prefs_t prefs;


/*** local definitions ***/
#define COL_VAL_GDK	65535.0		/* GdkColor is 16-bit color */
#define PREFS_NAME_LEN	32		/* max len for pref name in rc file */
#define PREFS_DIR	".gnp"		/* should be in $HOME */
#define APPRC		"apprc"		/* stores app-specific prefs */
#define APPGTKRC	"appgtkrc"	/* stores app-specific GTK prefs */
#define GTKRC		"gtkrc"		/* stores gtk-related prefs */
#define MAX_FONT_LEN	MAXPATH
#define DEFAULT_FONT	"-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1"

typedef enum {
	PrefGeneric,	/* generic */
	PrefBool,	/* its boolean, but the variable must be a "long" */
	PrefString,	/* (char *) */
	PrefInt,	/* int or uint */
	PrefFloat,	/* float */
	PrefByte,	/* byte */
	PrefShort	/* short */
} ptype_t;

/*
 * f: callback used when updating prefs (typically, win_foreach()).
 * c: callback data function passed to f().
 */
typedef struct {
	char *	name;	/* pref name */
	ptype_t	type;	/* pref type */
	void * 	addr;	/* address of data value */
	long	min;	/* min size/len/value */
	long	max;	/* max size/length/value */
	gulong	val;	/* multi-purpose value.  currently used for */
			/* max string len and boolean bit flags */
	void	(*f)(void (*g)(void *));
	void 	(*c)(void *);
} prefs_t;

/* used by color selection */
typedef enum { Foreground, Background, HighlightFg, HighlightBg } which_text_t;
typedef struct {
	GtkWidget *	cs;
	which_text_t	which;
} prefs_color_sel_t;


/*** local variables ***/
static bool_t		pre102 = FALSE;	/* using gnp+ before v1.0.2 */
static GtkPositionType	prefs_tabpos;	/* prefs tab position */

static char *	appgtkrc = NULL;	/* app specific gtk rc */
static void	appgtk_rc_update(gpointer data);	/* need fwd ref */


#ifdef USE_SOURCE_CTRL
typedef struct scc_cmds_s {
	char *pref;	/* prefs name (e.g., "scc_ccase") */
	char *cmd;	/* the command itself */
} scc_cmds_t;

/*
 * Commonly used commands for various source code control systems.
 */
typedef struct scc_info_s {
	char *scc_desc_name;	/* desc name (e.g., "Clear Case") */
	scc_cmds_t scc_cmds[SCC_NUM_CMDS];
} scc_info_t;

#define SCC_CCASE_CI_L		"scc_ccase_ci_l"
#define SCC_CCASE_CI_U		"scc_ccase_ci_u"
#define SCC_CCASE_CI_I		"scc_ccase_ci_i"
#define SCC_CCASE_CO_U		"scc_ccase_co_u"
#define SCC_CCASE_CO_L		"scc_ccase_co_l"
#define SCC_CCASE_UNDO		"scc_ccase_undo"
#define SCC_CCASE_REV		"scc_ccase_rev"
#define SCC_PFORCE_CI_L		"scc_pforce_ci_l"
#define SCC_PFORCE_CI_U		"scc_pforce_ci_u"
#define SCC_PFORCE_CI_I		"scc_pforce_ci_i"
#define SCC_PFORCE_CO_U		"scc_pforce_co_u"
#define SCC_PFORCE_CO_L		"scc_pforce_co_l"
#define SCC_PFORCE_UNDO		"scc_pforce_undo"
#define SCC_PFORCE_REV		"scc_pforce_rev"
#define SCC_PVCS_CI_L		"scc_pvcs_ci_l"
#define SCC_PVCS_CI_U		"scc_pvcs_ci_u"
#define SCC_PVCS_CI_I		"scc_pvcs_ci_i"
#define SCC_PVCS_CO_U		"scc_pvcs_co_u"
#define SCC_PVCS_CO_L		"scc_pvcs_co_l"
#define SCC_PVCS_UNDO		"scc_pvcs_undo"
#define SCC_PVCS_REV		"scc_pvcs_rev"
#define SCC_RCS_CI_L		"scc_rcs_ci_l"
#define SCC_RCS_CI_U		"scc_rcs_ci_u"
#define SCC_RCS_CI_I		"scc_rcs_ci_i"
#define SCC_RCS_CO_U		"scc_rcs_co_u"
#define SCC_RCS_CO_L		"scc_rcs_co_l"
#define SCC_RCS_UNDO		"scc_rcs_undo"
#define SCC_RCS_REV		"scc_rcs_rev"
#define SCC_SCCS_CI_L		"scc_sccs_ci_l"
#define SCC_SCCS_CI_U		"scc_sccs_ci_u"
#define SCC_SCCS_CI_I		"scc_sccs_ci_i"
#define SCC_SCCS_CO_U		"scc_sccs_co_u"
#define SCC_SCCS_CO_L		"scc_sccs_co_l"
#define SCC_SCCS_UNDO		"scc_sccs_undo"
#define SCC_SCCS_REV		"scc_sccs_rev"
#define SCC_TLIB_CI_L		"scc_tlib_ci_l"
#define SCC_TLIB_CI_U		"scc_tlib_ci_u"
#define SCC_TLIB_CI_I		"scc_tlib_ci_i"
#define SCC_TLIB_CO_U		"scc_tlib_co_u"
#define SCC_TLIB_CO_L		"scc_tlib_co_l"
#define SCC_TLIB_UNDO		"scc_tlib_undo"
#define SCC_TLIB_REV		"scc_tlib_rev"
#define SCC_USER_CI_L		"scc_user_ci_l"
#define SCC_USER_CI_U		"scc_user_ci_u"
#define SCC_USER_CI_I		"scc_user_ci_i"
#define SCC_USER_CO_U		"scc_user_co_u"
#define SCC_USER_CO_L		"scc_user_co_l"
#define SCC_USER_UNDO		"scc_user_undo"
#define SCC_USER_REV		"scc_user_rev"

static scc_info_t scc_tbl[SCC_NUM_TYPES] = {
	{	/* SCC_RCS */
		"RCS",
		{
			{ SCC_RCS_CI_L, "ci -q -l -m$s $F" },
			{ SCC_RCS_CI_U, "ci -q -m$s $F" },
			{ SCC_RCS_CI_I, "ci -q -l -t- -m$s $F" },
			{ SCC_RCS_CO_U, "co -q $F" },
			{ SCC_RCS_CO_L, "co -q -l $F" },
			{ SCC_RCS_UNDO, "rcs -q -u $F" },
			{ SCC_RCS_REV,  "rlog $F" }
		}
	},
	{	/* SCC_SCCS */
		"SCCS",
		{
			{ SCC_SCCS_CI_L, "sccs deledit -y$s $F" },
			{ SCC_SCCS_CI_U, "sccs delget -y$s $F" },
			{ SCC_SCCS_CI_I, "sccs create -y$s $F" },
			{ SCC_SCCS_CO_U, "sccs get $F" },
			{ SCC_SCCS_CO_L, "sccs edit $F" },
			{ SCC_SCCS_UNDO, "sccs unedit $F" },
			{ SCC_SCCS_REV,  "sccs prs $F" }
		}
	},
	{	/* SCC_CCASE */
		N_("Clear Case"),
		{
			{ SCC_CCASE_CI_L, "cleartool checkin -c $s $F" },
			{ SCC_CCASE_CI_U, "cleartool checkin -c $s $F" },
			{ SCC_CCASE_CI_I, "cleartool mkelem -c $F" },
			{ SCC_CCASE_CO_U, "cleartool checkout -nc $F" },
			{ SCC_CCASE_CO_L, "cleartool checkout -nc $F" },
			{ SCC_CCASE_UNDO, "cleartool uncheckout -rm $F" },
			{ SCC_CCASE_REV,
			  "cleartool lshistory -fmt \"%Sd %u %Nc\\n\" $F" }
		}
	},
	{	/* SCC_PFORCE */
		N_("Perforce"),
		{
			{ SCC_PFORCE_CI_L, "p4 submit $F" },
			{ SCC_PFORCE_CI_U, "p4 submit $F" },
			{ SCC_PFORCE_CI_I, "p4 add $F" },
			{ SCC_PFORCE_CO_U, "p4 edit $F" },
			{ SCC_PFORCE_CO_L, "p4 edit $F" },
			{ SCC_PFORCE_UNDO, "p4 revert $F" },
			{ SCC_PFORCE_REV,  "p4 filelog $F" }
		}
	},
	{	/* SCC_PVCS */
		"PVCS",
		{
			{ SCC_PVCS_CI_L, "put -n -l$F" },
			{ SCC_PVCS_CI_U, "put -n $F" },
			{ SCC_PVCS_CI_I, "put -n $F" },
			{ SCC_PVCS_CO_U, "put -y $F" },
			{ SCC_PVCS_CO_L, "put -y -l$F" },
			{ SCC_PVCS_UNDO, "vcs -u $F" },
			{ SCC_PVCS_REV,  "vlog -b $F" }
		}
	},
	{	/* SCC_TLIB */
		"TLIB",
		{
			{ SCC_TLIB_CI_L, "tlib U $F" },
			{ SCC_TLIB_CI_U, "tlib K $F" },
			{ SCC_TLIB_CI_I, "tlib K $F" },
			{ SCC_TLIB_CO_U, "tlib B $F" },
			{ SCC_TLIB_CO_L, "tlib E $F" },
			{ SCC_TLIB_UNDO, NULL },
			{ SCC_TLIB_REV,  "tlib L $F" }
		}
	},
	{	/* SCC_USER */
		N_("User Defined"),
		{
			{ SCC_USER_CI_L, NULL },
			{ SCC_USER_CI_U, NULL },
			{ SCC_USER_CI_I, NULL },
			{ SCC_USER_CO_U, NULL },
			{ SCC_USER_CO_L, NULL },
			{ SCC_USER_UNDO, NULL },
			{ SCC_USER_REV,  NULL }
		}
	}
}; /* scc_tbl */
#endif	/* USE_SOURCE_CTRL */


/*
 * to add a new configurable preference option:
 *
 * 1. declare a global variable up in the "global variables" section.  make
 * sure that it's one of the following types: int, bool, float, byte, short, or
 * "char *".
 *
 * 2. add a corresponding entry below into the variable 'app_prefs'.  your best
 * bet is to just cut and paste an existing entry and see how it works.  keep
 * the entries in alphabetical order.
 *
 * 3. create and add the necessary widgets into the Preferences window popup
 * dialog.  the most commonly used ones are a button and a text entry.  be sure
 * to add these widgets into the wgtopt_list.  see one of the existing routines
 * as an example (e.g., prefs_frame_toolbar_create()).
 *
 *
 * i know this setup may not be easiest way for another developer to use.  for
 * example, ideally one would like to do something such as the following:
 *
 *	prefs_set_data("doc_tab_position", "top");
 *	prefs_get_data("print_command", buf);
 *
 * however, the big downside to this is that when getting data, you need
 * routines to translate the values *ANYWAY*.  in other words, every time you
 * successfully get data, you still have to determing *what* that data is and
 * *how* it affects preferences.  for instance, if data is supposed to
 * represent an integer, you'd have to then convert it to an integer and
 * determine what to do.
 *
 * so although the prefs_set_data() and prefs_get_data() looks nice on the
 * outside, you still have to write a whole bunch of code to figure out what do
 * with it once you've gotten it.  the tabular method that i'm using
 * effectively puts the "what", "how", and "where" into the table itself.  so
 * all you have to do is specify it ONCE, and the routines that manipulate the
 * table will take care of it so you don't have to.
 *
 * the prefs_set_data() and prefs_get_data() technique may work well if it were
 * provided as a library (e.g., Gnome does this), but since this part of the
 * code is not intended to be a library, (i think) the tabular method is
 * better.
 */
static prefs_t		app_prefs[] = {
#if defined(USE_TOOLBARS) && defined(USE_HTMLTAGS)
	{ "advanced_html_tb",
		PrefBool,
		&prefs.options1,
		0, 1, ADVANCED_HTML_TB,
		win_foreach, tb_redraw
	},
#endif
#ifdef USE_AUTO_INDENT
	{ "auto_indent",
		PrefBool,
		&prefs.options1,
		0, 1, AUTO_INDENT,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_AUTOSAVE
	{ "autosave_timeout",
		PrefInt,
		&prefs.autosave,
		0, 1440, 0,
		win_foreach,
		win_autosave_reset,
	},
#endif	/* USE_AUTOSAVE */
#ifdef USE_BACKUP
	{ "backupdir",
		PrefString,
		&prefs.backupdir,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ "backupsuffix",
		PrefString,
		&prefs.backupsuffix,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ "do_backup",
		PrefBool,
		&prefs.options1,
		0, 1, DO_BACKUP,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_BACKUP */
#ifdef WANT_BACKGROUND
	{ "do_fork",
		PrefBool,
		&prefs.options1,
		0, 1, DO_FORK,
		NULL_CALLBACK, NULL,
	},
#endif
	{ "doc_tab_position",
		PrefInt,
		&prefs.tabpos,
		0, 3, 0,
		win_foreach,
		win_redraw_doc_tab,
	},
	/*
	 * the next four settings (doc_tabs_{bottom,left,right,top}) are for
	 * doc tabs.  however, they should NOT appear in the prefs dialog
	 * because the doc tab positioning is handled by the previous prefs
	 * setting (doc_tab_position).  these are bit fields/options, and are
	 * needed to determine what state the menu toggle/radio buttons are
	 * currently in and what new settings they will take on.
	 */
	{ "doc_tabs_bottom",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_BOTTOM,
		NULL_CALLBACK, NULL,
	},
	{ "doc_tabs_left",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_LEFT,
		NULL_CALLBACK, NULL,
	},
	{ "doc_tabs_right",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_RIGHT,
		NULL_CALLBACK, NULL,
	},
	{ "doc_tabs_top",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_TOP,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_TOOLBARS
# ifdef USE_HTMLTAGS
	/*
	 * Start of the options for the HTML Font toolbar
	 */
	{ HTML_FONT_TB_STR_BIG,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_BIG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_BOLD,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_BOLD,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_EMPH,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_EMPH,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_FONTM1,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_FONTM1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_FONTP1,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_FONTP1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H1,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H2,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H3,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H3,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H4,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H4,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H5,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H5,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H6,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H6,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_ITAL,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_ITAL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_PRE,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_PRE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_SMLL,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_SMLL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_STRG,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_STRG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_STRK,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_STRK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_SUB,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_SUB,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_SUP,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_SUP,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_TTY,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_TTY,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_ULNE,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_ULNE,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML Forms toolbar
	 */
	{ HTML_FORM_STR_BUTTON,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_BUTTON,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_CHECK,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_CHECK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_IMAGE,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_IMAGE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_NEW,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_NEW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_OPT,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_OPT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_PASS,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_PASS,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_RADIO,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_RADIO,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_RESET,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_RESET,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_SEL,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_SEL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_SUBMIT,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_SUBMIT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_TAREA,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_TAREA,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_TFIELD,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_TFIELD,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML Frame toolbar
	 */
	{ HTML_FRAME_STR_BASE,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_BASE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_NEW,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_NEW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_NEW2,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_NEW2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_NO,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_NO,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_SET,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_SET,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_SET2,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_SET2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_WIZ,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_WIZ,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML List toolbar
	 */
	{ HTML_LIST_TB_STR_DEF,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_DEF,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_DLIST,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_DLIST,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_DTERM,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_DTERM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_LITM,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_LITM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_MENU,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_MENU,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_ORDR,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_ORDR,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_UORD,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_UORD,
		NULL_CALLBACK, NULL,
	},

	{ "html_tag_lower",
		PrefBool,
		&prefs.options1,
		0, 1, HTML_TAG_LOWER,
		NULL_CALLBACK, NULL,
	},
	{ "html_tag_upper",
		PrefBool,
		&prefs.options1,
		0, 1, HTML_TAG_UPPER,
		NULL_CALLBACK, NULL,
	},

	/*
	 * Start of the options for the HTML Main toolbar
	 */
	{ HTML_TB_STR_BIG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_BIG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_BOLD,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_BOLD,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_CENT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_CENT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_CMNT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_CMNT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_DEF,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_DEF,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_DLIST,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_DLIST,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_DTERM,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_DTERM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_EMPH,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_EMPH,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_FONTM1,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_FONTM1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_FONTP1,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_FONTP1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H1,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H2,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H3,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H3,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H4,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H4,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H5,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H5,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H6,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H6,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_IMG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_IMG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_ITAL,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_ITAL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LBRK,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LBRK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LEFT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LEFT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LINK,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LINK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LITM,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LITM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_MENU,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_MENU,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_ORDR,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_ORDR,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_PARA,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_PARA,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_PRE,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_PRE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_RGHT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_RGHT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SEP,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SEP,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SMLL,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SMLL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_STRG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_STRG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_STRK,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_STRK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SUB,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SUB,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SUP,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SUP,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_TARG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_TARG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_TTL,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_TTL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_TTY,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_TTY,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_ULNE,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_ULNE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_UORD,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_UORD,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML Table toolbar
	 */
	{ HTML_TBL_TB_STR_DATA,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_DATA,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_DATA2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_DATA2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_HDR,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_HDR,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_HDR2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_HDR2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_NEW,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_NEW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_NEW2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_NEW2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_ROW,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_ROW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_ROW2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_ROW2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_WIZ,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_WIZ,
		NULL_CALLBACK, NULL,
	},
# endif	/* USE_HTMLTAGS */
	/*
	 * Start of the options for the MAIN toolbar for the app
	 */
	{ MAIN_TB_STR_CLOSE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_CLOSE,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_COPY,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_COPY,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_CUT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_CUT,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_EXIT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_EXIT,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_FIND,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_FIND,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_FNEXT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_FIND_NEXT,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_NEW,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_NEW,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_OPEN,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_OPEN,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_PASTE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_PASTE,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_PREFS,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_PREFS,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_PRINT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_PRINT,
		NULL_CALLBACK, NULL,
	},
#ifdef GTK_HAVE_FEATURES_1_1_0
	{ MAIN_TB_STR_REDO,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_REDO,
		NULL_CALLBACK, NULL,
	},
#endif
	{ MAIN_TB_STR_REPLACE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_REPLACE,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_SAVE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_SAVE,
		NULL_CALLBACK, NULL,
	},
#ifdef GTK_HAVE_FEATURES_1_1_0
	{ MAIN_TB_STR_UNDO,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_UNDO,
		NULL_CALLBACK, NULL,
	},
#endif
	{ MAIN_TB_STR_WINNEW,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_WINNEW,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_WINCLOSE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_WINCLOSE,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_TOOLBARS */
#if defined(USE_GTKXMHTML) || defined(USE_GTKHTML)
	{ "html_view_win_height",
		PrefInt,
		&prefs.html_view_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "html_view_win_width",
		PrefInt,
		&prefs.html_view_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_RECENT
	{ "max_num_recent",
		PrefByte,
		&prefs.maxrecent,
		0, 255, 0,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_RECENT */
#ifdef WANT_MSGBOX
	{ "msgbox_max_msg",
		PrefInt,
		&prefs.msgbox_max_msg,
		0, 32768, 0,
		NULL_CALLBACK, NULL,
	},
	{ "msgbox_per_del",
		PrefInt,
		&prefs.msgbox_per_del,
		0, 100, 0,
		NULL_CALLBACK, NULL,
	},
#endif  /* #ifdef WANT_MSGBOX */
	{ "prefs_tab_position",
		PrefInt,
		&prefs_tabpos,
		0, 3, 0,
		NULL_CALLBACK, NULL,
	},
	{ "print_command",
		PrefString,
		&prefs.printcmd,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#ifdef WANT_PROJECT
	{ "prj_list_height",
		PrefInt,
		&prefs.prjlist_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "prj_list_width",
		PrefInt,
		&prefs.prjlist_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_RANDOMTIPS
	{ "random_tips_delay",
		PrefInt,
		&prefs.random_tips,
		0, 86400, 0,
		win_foreach,
		random_tips_reset,
	},
#endif	/* USE_RANDOMTIPS */
	{ "read_buf_size",
		PrefInt,
		&prefs.read_size,
		0, 65536, 0,
		NULL_CALLBACK, NULL,
	},
	{ "save_win_height",
		PrefBool,
		&prefs.options1,
		0, 1, SAVE_WIN_HEIGHT,
		NULL_CALLBACK, NULL,
	},
	{ "save_win_pos",
		PrefBool,
		&prefs.options1,
		0, 1, SAVE_WIN_POS,
		NULL_CALLBACK, NULL,
	},
	{ "save_win_width",
		PrefBool,
		&prefs.options1,
		0, 1, SAVE_WIN_WIDTH,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_SOURCE_CTRL
	/* Clear Case */
	{ SCC_CCASE_CI_L,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CI_U,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CI_I,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CO_U,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CO_L,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_UNDO,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_REV,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* Perforce */
	{ SCC_PFORCE_CI_L, 
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CI_U,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CI_I,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CO_U,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CO_L,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_UNDO,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_REV,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* PVCS */
	{ SCC_PVCS_CI_L, 
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CI_U,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CI_I,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CO_U,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CO_L,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_UNDO,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_REV,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* RCS */
	{  SCC_RCS_CI_L,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CI_U,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CI_I,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CO_U,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CO_L,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_UNDO,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_REV,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* SCCS */
	{ SCC_SCCS_CI_L,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CI_U,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CI_I,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CO_U,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CO_L,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_UNDO,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_REV,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ "scc_selected",
		PrefInt,
		&prefs.scc_selected,
		0, SCC_NUM_TYPES-1, 0,
		win_foreach,
		win_redraw_doc_tab,
	},
	/* TLIB */
	{ SCC_TLIB_CI_L,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CI_U,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CI_I,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CO_U,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CO_L,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_UNDO,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_REV,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* User Defined */
	{ SCC_USER_CI_L,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CI_U,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CI_I,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CO_U,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CO_L,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_UNDO,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_REV,
		PrefString,
		&prefs.scc[SCC_USER][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_SOURCE_CTRL */
#ifdef USE_SHELL_INSERT
	{ "shell",
		PrefString,
		&prefs.shell,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_SHELL_INSERT */
	{ "show_doc_tabs",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_TABS,
		win_foreach,
		win_redraw_doc_tab,
	},
#ifdef USE_TOOLBARS
# ifdef USE_HTMLTAGS
	{ "show_html_toolbar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_HTML_TOOLBAR,
		win_foreach, tb_redraw,
	},
# endif	/* USE_HTMLTAGS */
#endif	/* USE_TOOLBARS */
#ifdef WANT_PROJECT
	{ "show_project_bar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_PRJBAR,
		win_foreach, prjbar_redraw,
	},
#endif	/* WANT_PROJECT */
	{ "show_message_bar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_MSGBAR,
		win_foreach, msgbar_redraw,
	},
#ifdef WANT_SPLASH
	{ "show_splash",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_SPLASH,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_TOOLBARS
	{ "show_toolbar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_TOOLBAR,
		win_foreach, tb_redraw,
	},
	{ "show_tooltips",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_TOOLTIPS,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_TOOLBARS */
	{ "tab_stop",
		PrefInt,
		&prefs.tab_stop,
		1, 128, 0,
		win_doc_foreach, doc_tab_stop_set,
	},
#ifdef USE_HTMLTAGS
	{ "tagchooser_h",
		PrefInt,
		&prefs.tagchooser_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "tagchooser_w",
		PrefInt,
		&prefs.tagchooser_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
	{ "text_bg_color",
		PrefString,
		&prefs.text_bg_str,
		0, 1, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "text_fg_color",
		PrefString,
		&prefs.text_fg_str,
		0, 0, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "text_font",
		PrefString,
		&prefs.text_font_str,
		0, 0, MAX_FONT_LEN,
		win_doc_foreach, doc_redraw,
	},
	{ "text_hlbg_color",
		PrefString,
		&prefs.text_hlbg_str,
		0, 1, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "text_hlfg_color",
		PrefString,
		&prefs.text_hlfg_str,
		0, 0, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "tmp_directory",
		PrefString,
		&prefs.tmpdir,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_TOOLBARS
	{ "toolbar_piconly",
		PrefBool,
		&prefs.options1,
		0, 1, PIC_ONLY_TOOLBAR,
		win_foreach, tb_redraw,
	},
	{ "toolbar_pictext",
		PrefBool,
		&prefs.options1,
		0, 1, PIC_TEXT_TOOLBAR,
		win_foreach, tb_redraw,
	},
# ifdef GTK_HAVE_FEATURES_1_1_0
	{ "toolbar_raised",
		PrefBool,
		&prefs.options1,
		0, 1, TOOLBAR_RAISED,
		win_foreach, tb_redraw,
	},
# endif
	{ "toolbar_textonly",
		PrefBool,
		&prefs.options1,
		0, 1, TEXT_ONLY_TOOLBAR,
		win_foreach, tb_redraw,
	},
#endif	/* USE_TOOLBARS */
#ifdef WANT_MSGBOX
	{ "use_msgbox",
		PrefBool,
		&prefs.options1,
		0, 1, USE_MSGBOX,
		NULL_CALLBACK, NULL,
	},
#endif  /* #ifdef WANT_MSGBOX */
	{ "use_wordwrap",
		PrefBool,
		&prefs.options1,
		0, 1, USE_WORDWRAP,
		NULL_CALLBACK, NULL,
	},
	{ "use_fontset",
		PrefBool,
		&prefs.options1,
		0, 1, USE_FONTSET,
		NULL_CALLBACK, NULL,
	},
	{ "win_height",
		PrefInt,
		&prefs.win_height,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_WINLIST
	{ "win_list_height",
		PrefInt,
		&prefs.winlist_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "win_list_width",
		PrefInt,
		&prefs.winlist_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
	{ "win_width",
		PrefInt,
		&prefs.win_width,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
	{ "win_xpos",
		PrefInt,
		&prefs.win_xpos,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
	{ "win_ypos",
		PrefInt,
		&prefs.win_ypos,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
	{ NULL }
}; /* app_prefs[] */


/*
 * in order for the preferences to take effect and be saved *after* the user
 * clicked "Ok" (as opposed to the preferences taking effect immediately each
 * time the user selects an option in the prefs window), we build a list of
 * items.  each item contains the following:
 *
 *	1. a pointer into the correct entry into the app_prefs table.  since
 *	once the user selects "Ok", we're effectively saving the new options
 *	anyway, so let's just reuse the code used for saving the prefs.
 *
 *	2. the widget representing the options (e.g., a check box).  this is
 *	used so we know what state it's in.  or rather, what the user has
 *	selected.  the widget is implied by what the preference is.  if it's
 *	PrefBool, it must be a button widget.  all others are most likely a
 *	text entry type.
 *
 * once the user hits the "Save Preferences" button, we then scan this list,
 * and depending on the state of the widget/button/etc, we can look in the
 * app_prefs table to see what to set and to what value.
 */
typedef enum {
	GenericType,
	EntryType,
	ButtonType,
	ComboType
} wgttype_t;

typedef struct {
	prefs_t *pap;		/* pointer into app_prefs table */
	GtkWidget *wgt;		/* the widget */
	wgttype_t type;		/* type of widget */
	void *data;		/* data to use */
} wgtopt_t;
static wgtopt_t *wgtopt_list = NULL;
static guint wgtopt_list_cnt = 0;

/* other global variables within this file */
static char *		apprc     = NULL;	/* full path to apprc */
static GtkWidget *	prefs_win = NULL;	/* preferences popup window */
#ifdef GTK_HAVE_FEATURES_1_1_0
static GtkWidget *	prefs_txt = NULL;	/* preferences text window */
#endif


/*** local function prototypes ***/
static char *		prefs_tf(long opts, long mask);
static void		prefs_read(FILE *fp);
static void		prefs_bool_set(prefs_t *pap, char *data);
static void		prefs_byte_set(prefs_t *pap, char *data);
static void		prefs_float_set(prefs_t *pap, char *data);
static void		prefs_int_set(prefs_t *pap, char *data);
static void		prefs_string_set(prefs_t *pap, char *data);
static void		prefs_dialog_create(win_t *w);
static void		prefs_win_cancel(GtkWidget *wgt, gpointer cbdata);
static void		prefs_win_destroy(GtkWidget *wgt, gpointer cbdata);
static void		prefs_save_cb(GtkWidget *wgt, gpointer cbdata);
static void		prefs_wgtopt_list_init(void);
static void		prefs_wgtopt_list_add(
				GtkWidget *, wgttype_t, void *, char *);
static void		prefs_wgtopt_list_free(void);
static void		prefs_page_document_create(GtkWidget *nb);
static void		prefs_page_misc_create(GtkWidget *nb);
static void		prefs_frame_doctab_create(GtkWidget *parent_vbox);
static void		prefs_page_appearance_create(GtkWidget *nb);
static void		prefs_frame_msgbar_create(GtkWidget *parent);
static void		prefs_page_window_create(GtkWidget *nb);
#ifdef WANT_MSGBOX
static void		prefs_frame_msgbox_create(GtkWidget *parent);
#else
# define		prefs_frame_msgbox_create(parent)
#endif  /* #ifdef WANT_MSGBOX */
static void		prefs_update(void);
static void		prefs_tab_pos_change(GtkWidget *wgt, gpointer cbdata);
static void		prefs_page_fonts_colors(GtkWidget *nb);
#ifdef USE_GNOME
static void		prefs_text_color_cb(GtkWidget *wgt, guint r, guint g,
					    guint b, guint a, gpointer cbdata);
static void		prefs_font_sel_cb(GnomeFontPicker *gfp,
					  char *fontname, gpointer cbdata);
#else
static void		prefs_text_color_cb(GtkWidget *wgt, gpointer cbdata);
static void		prefs_font_sel_cb(GtkWidget *wgt, gpointer cbdata);
static void		prefs_color_sel_ok(GtkWidget *wgt, gpointer cbdata);
static void		prefs_color_sel_close(GtkWidget *, gpointer cbdata);
static void		prefs_color_sel_destroy(GtkWidget *, gpointer cbdata);
static void		prefs_font_sel_ok(GtkWidget *wgt, gpointer cbdata);
static void		prefs_font_sel_cancel(GtkWidget *wgt, gpointer cbdata);
#endif
static GtkWidget *	prefs_check_button_with_label_create(
				GtkWidget *, char *, long , char *,
				GtkWidget *table,
				int lft1, int rht1, int top1, int bot1);
static GtkWidget *	prefs_spin_button_with_label_create(
				GtkWidget *, char *, float , float , float ,
				float , float , float , char *,
				GtkWidget *table,
				int lft1, int rht1, int top1, int bot1,
				int lft2, int rht2, int top2, int bot2);
static GtkWidget *	prefs_pulldown_with_label_create(
				GtkWidget *, char *, GList *, char *, int);
static void		prefs_box_in_frame(char *frametext, int border_width,
				GtkWidget **frame, GtkWidget **vbox, bool_t);

#ifdef USE_TOOLBARS
static void		prefs_frame_toolbar_create(GtkWidget *parent_vbox);
static GtkWidget *	prefs_radio_button_with_label_create(
				GtkWidget *, GtkWidget *, char *, long, char *);
static void		prefs_page_main_tb(GtkWidget *nb);
static GtkWidget *	prefs_frame_tb(GtkWidget *nb, char *pagename,
				       int , toolbar_data_t *tbdtable);
# ifdef USE_HTMLTAGS
static void		prefs_page_html_tb(GtkWidget *nb);
# endif
#else
# define		prefs_frame_toolbar_create(parent)
# define		prefs_page_main_tb(nb)
# define		prefs_page_html_tb(nb)
#endif
#ifdef USE_SOURCE_CTRL
static void		prefs_frame_scc_selection(GtkWidget *parent);
static void		prefs_page_scc_create(GtkWidget *prefs_nb);
#else
# define		prefs_page_scc_create(prefs_nb);
#endif


/*** global function definitions ***/
/*
 * PUBLIC: prefs_cb
 *
 * callback invoked from menu to bring up preferences window.
 */
void
prefs_cb(GtkWidget *wtg, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (misc_show_and_raise(prefs_win))
		return;

	prefs_dialog_create(w);
} /* prefs_cb */


/*
 * PUBLIC: prefs_init_pre
 *
 * initializes application wide preferences.  called from main() **BEFORE**
 * calling gtk_init().
 *
 * TODO: specify/use system-wide app-defaults file
 */
void
prefs_init_pre(void)
{
	char *homedir, *buf;
	FILE *fp;
	int num, i, j;

	if ((homedir = getenv("HOME")) == NULL) {
		g_error("$HOME is not set!");
		exit(0);
	}

	prefs.appdir = g_new(char, strlen(homedir) + strlen(PREFS_DIR)+ 2);
	sprintf(prefs.appdir, "%s/%s", homedir, PREFS_DIR);
	num = mkdir(prefs.appdir, 0777);
	if (num == -1 && errno != ESUCCESS && errno != EEXIST) {
		buf = g_new(char, strlen(prefs.appdir) + 32);
		sprintf(buf, "prefs_init: could not create '%s'", prefs.appdir);
		perror(buf);
		g_free(buf);
		g_free(prefs.appdir);
		exit(0);
	}
#if NOT_QUITE
	else if (errno == ESUCCESS) {
		/* hmm, this doesn't work the way i intended to at this
		 * this point because there's no top-level dialog window
		 * associated with it.  consequently, this dialog box just
		 * pops up where-ever it wants.
		 */
		(void)do_dialog_ok(
			"gnotepad+ Initialized", " Created $HOME/.app/ ");
	}
#endif

	/* initialize to default values */
	prefs.read_size      = BUFSIZ;
	prefs.tmpdir         = g_strdup("/var/tmp");
	prefs.tabpos         = GTK_POS_TOP;
	prefs.options1       = DEFAULT_OPTIONS;
	prefs.tab_stop	     = 8;
#ifdef USE_TOOLBARS
	prefs.main_tb_opt    = DEFAULT_MAIN_TB_OPT;
#ifdef USE_HTMLTAGS
	prefs.html_tb_opt1   = DEFAULT_HTML_TB_OPT1;
	prefs.html_tb_opt2   = DEFAULT_HTML_TB_OPT2;
	prefs.html_font_tb_opt1 = DEFAULT_HTML_FONT_TB_OPT1;
	prefs.html_list_tb_opt1 = DEFAULT_HTML_LIST_TB_OPT1;
	prefs.html_tbl_tb_opt1  = DEFAULT_HTML_TBL_TB_OPT1;
	prefs.html_form_tb_opt1 = DEFAULT_HTML_FORM_TB_OPT1;
	prefs.html_frame_tb_opt1= DEFAULT_HTML_FRAME_TB_OPT1;
#endif	/* USE_HTMLTAGS */
#endif	/* USE_TOOLBARS */
#ifdef USE_RECENT
	prefs.maxrecent      = 4;
#endif	/* USE_RECENT */
#ifdef WANT_MSGBOX
	prefs.msgbox_max_msg = 200;
	prefs.msgbox_per_del = 50;
#endif  /* #ifdef WANT_MSGBOX */
	prefs.win_height     = 470;
	prefs.win_width      = -1;
	prefs.win_xpos       = -1;
	prefs.win_ypos       = -1;
#if defined(USE_GTKXMHTML) || defined(USE_GTKHTML)
	prefs.html_view_w    = 600;
	prefs.html_view_h    = 400;
#endif
#ifdef USE_WINLIST
	prefs.winlist_w      = 300;
	prefs.winlist_h      = 200;
#endif
#ifdef WANT_PROJECT
	prefs.prjlist_w      = 300;
	prefs.prjlist_h      = 200;
#endif
#ifdef USE_RANDOMTIPS
	prefs.random_tips    = 15;
#endif	/* USE_RANDOMTIPS */
	prefs_tabpos         = GTK_POS_LEFT;
	prefs.printcmd       = g_strdup("lpr %s");
#ifdef USE_BACKUP
	prefs.backupdir      = NULL;
	prefs.backupsuffix   = g_strdup("~");
#endif	/* USE_BACKUP */
#ifdef USE_AUTOSAVE
	prefs.autosave       = 5;
#endif
#ifdef USE_HTMLTAGS
	prefs.tagchooser_w   = 480;
	prefs.tagchooser_h   = 565;
#endif
	prefs.text_fg_str    = g_strdup("0 0 0");	/* always black */
	prefs.text_bg_str    = g_strdup("65535 65535 65535");	/* 16-bit */
	prefs.text_hlfg_str  = g_strdup("65535 65535 65535");	/* 16-bit */
	prefs.text_hlbg_str  = g_strdup("0 65535 0");	/* blue */
	prefs.text_font_str  = g_strdup(DEFAULT_FONT);
	prefs.text_font      = NULL;
#ifdef USE_SHELL_INSERT
	if ((buf = getenv("SHELL")) == NULL)
		prefs.shell  = g_strdup("/bin/sh");
	else
		prefs.shell  = g_strdup(buf);
#endif	/* USE_SHELL_INSERT */

#ifdef USE_SOURCE_CTRL
	for (i = 0; i < SCC_NUM_TYPES; i++) {
		GNPDBG_PREFS(("prefs_init_pre (%s): ",
			      scc_tbl[i].scc_desc_name));
		for (j = 0; j < SCC_NUM_CMDS; j++) {
			prefs.scc[i][j] = 
				(scc_tbl[i].scc_cmds[j].cmd) ?
				g_strdup(scc_tbl[i].scc_cmds[j].cmd) : NULL;
			GNPDBG_PREFS(("'%s'\n", prefs.scc[i][j]));
		}
	}
	prefs.scc_selected = SCC_RCS;
#endif	/* USE_SOURCE_CTRL */

	/* read apprc to get application specific stuff */
	num = strlen(prefs.appdir) + strlen(APPRC) + 2;
	if (apprc)
		g_free(apprc);
	apprc = g_new(char, num);
	g_snprintf(apprc, num, "%s/%s", prefs.appdir, APPRC);
	
	if ((fp = fopen(apprc, "r")) == NULL) {
		if (errno == ENOENT)	/* apprc doesn't exist, so create it */
			prefs_save();	/* using default values */
		else {
			buf = g_new(char, strlen(apprc) + 32);
			sprintf(buf, "prefs_init: could not open '%s'", apprc);
			perror(buf);
			g_free(buf);
		}
	}

	prefs_read(fp);
} /* prefs_init_pre */


/*
 * PUBLIC: prefs_init_post()
 *
 * initializes application wide preferences.  called from main() **AFTER**
 * calling gtk_init().
 */
void
prefs_init_post(void)
{
	int num;
	char *gtkrc;

	num = strlen(prefs.appdir) + strlen(GTKRC) + 2;
	gtkrc = g_new(char, num);
	g_snprintf(gtkrc, num, "%s/%s", prefs.appdir, GTKRC);
	gtk_rc_parse(gtkrc);
	g_free(gtkrc);

	prefs_text_color_update();
        if (!IS_USE_FONTSET()) {
		prefs.text_font = (prefs.text_font_str) ?
				gdk_font_load(prefs.text_font_str) : NULL;
        } else {
		prefs.text_font = (prefs.text_font_str) ?
				gdk_fontset_load(prefs.text_font_str) : NULL;
        }

	/* avoid nonsense */
	if (prefs.read_size < 1)
		prefs.read_size = BUFSIZ;

	/*
	 * now that we have the application specific stuff, create a gtk
	 * formattted rc file which contains app settings that may override
	 * anything in gtkrc, and finally, use the settings specified in this
	 * new file.
	 */
	num = strlen(prefs.appdir) + strlen(APPGTKRC) + 2;
	if (appgtkrc)
		g_free(appgtkrc);
	appgtkrc = g_new(char, num);
	g_snprintf(appgtkrc, num, "%s/%s", prefs.appdir, APPGTKRC);
	appgtk_rc_update(appgtkrc);
} /* prefs_init_post */


/*
 * PUBLIC: prefs_save
 *
 * save application-wide preferences.  basically, scan the app_prefs table and
 * write out the values corresponding to each entry.
 */
void
prefs_save(void)
{
	FILE *fp;
	char *buf;
	prefs_t *pap;

	if ((fp = fopen(apprc, "w")) == NULL) {
		buf = g_new(char, strlen(apprc) + 32);
		sprintf(buf, "prefs_save: could not open '%s'", apprc);
		perror(buf);
		g_free(buf);
		return;
	}

	(void)file_lock(apprc, fp, TRUE, FALSE, TRUE);
	fprintf(fp,
		"# %s %s initialization file.  "
		"This file is automatically generated.\n"
		"# Data in this file is in no particular order.\n"
		"# Although you could edit this by hand, "
		"it is NOT recommended!\n",
		APP_NAME, APP_VERSION);

	buf = g_new(char, PREFS_NAME_LEN + MAXPATH);
	buf[0] = '\0';
	pap = app_prefs;
	while (pap->name) {
		if (pap->addr == NULL) {
			printf("prefs_save: '%s' has NULL addr\n", pap->name);
			pap++;
			continue;
		}

		switch (pap->type) {
		case PrefBool:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %s",
				pap->name,
				prefs_tf(*(long *)(pap->addr), pap->val));
			break;
		case PrefString:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %s",
				pap->name,
				handle_null_string(*(char **)(pap->addr)));
			break;
		case PrefInt:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %d",
				pap->name, *(int *)(pap->addr));
			break;
		case PrefByte:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %d",
				pap->name, *(byte *)(pap->addr));
			break;
		case PrefFloat:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %f",
				pap->name, *(float *)(pap->addr));
			break;
		default:
			printf("prefs_save: ignoring '%s' (unknown type=%d)\n",
				pap->name, pap->type);
			break;
		} /* switch pap->type */

		if (buf[0] != '\0') {
			fprintf(fp, "%s\n", buf);
			GNPDBG_PREFS(("prefs_save: wrote = '%s'\n", buf));
			buf[0] = '\0';
		}

		pap++;
	} /* while pap->name */

	(void)file_unlock(apprc, fp);
	fclose(fp);
	g_free(buf);
} /* prefs_save */


/*
 * PUBLIC: prefs_update_text_widget_style
 *
 * this needs to be called *AFTER* the main prefs window has been drawn and
 * show.  this is because at the time when the text widget was created, nothing
 * was realized, so we cannot muck with the text widget.
 */
#ifdef GTK_HAVE_FEATURES_1_1_0
void
prefs_update_text_widget_style(GtkWidget *wgt)
{
	GtkStyle *style;

	style = gtk_style_copy(wgt->style);

	sscanf(prefs.text_fg_str, "%hd %hd %hd", &prefs.text_fg_color.red,
		&prefs.text_fg_color.blue, &prefs.text_fg_color.green);
	style->fg[GTK_STATE_NORMAL].red     = prefs.text_fg_color.red;
	style->fg[GTK_STATE_NORMAL].blue    = prefs.text_fg_color.blue;
	style->fg[GTK_STATE_NORMAL].green   = prefs.text_fg_color.green;
	style->text[GTK_STATE_NORMAL].red   = prefs.text_fg_color.red;
	style->text[GTK_STATE_NORMAL].blue  = prefs.text_fg_color.blue;
	style->text[GTK_STATE_NORMAL].green = prefs.text_fg_color.green;

	sscanf(prefs.text_bg_str, "%hd %hd %hd", &prefs.text_bg_color.red,
		&prefs.text_bg_color.blue, &prefs.text_bg_color.green);
	style->bg[GTK_STATE_NORMAL].red     = prefs.text_bg_color.red;
	style->bg[GTK_STATE_NORMAL].blue    = prefs.text_bg_color.blue;
	style->bg[GTK_STATE_NORMAL].green   = prefs.text_bg_color.green;
	style->base[GTK_STATE_NORMAL].red   = prefs.text_bg_color.red;
	style->base[GTK_STATE_NORMAL].blue  = prefs.text_bg_color.blue;
	style->base[GTK_STATE_NORMAL].green = prefs.text_bg_color.green;

	sscanf(prefs.text_hlfg_str, "%hd %hd %hd", &prefs.text_hlfg_color.red,
		&prefs.text_hlfg_color.blue, &prefs.text_hlfg_color.green);
	style->fg[GTK_STATE_SELECTED].red     = prefs.text_hlfg_color.red;
	style->fg[GTK_STATE_SELECTED].blue    = prefs.text_hlfg_color.blue;
	style->fg[GTK_STATE_SELECTED].green   = prefs.text_hlfg_color.green;
	style->text[GTK_STATE_SELECTED].red   = prefs.text_hlfg_color.red;
	style->text[GTK_STATE_SELECTED].blue  = prefs.text_hlfg_color.blue;
	style->text[GTK_STATE_SELECTED].green = prefs.text_hlfg_color.green;

	sscanf(prefs.text_hlbg_str, "%hd %hd %hd", &prefs.text_hlbg_color.red,
		&prefs.text_hlbg_color.blue, &prefs.text_hlbg_color.green);
	style->bg[GTK_STATE_SELECTED].red     = prefs.text_hlbg_color.red;
	style->bg[GTK_STATE_SELECTED].blue    = prefs.text_hlbg_color.blue;
	style->bg[GTK_STATE_SELECTED].green   = prefs.text_hlbg_color.green;
	style->base[GTK_STATE_SELECTED].red   = prefs.text_hlbg_color.red;
	style->base[GTK_STATE_SELECTED].blue  = prefs.text_hlbg_color.blue;
	style->base[GTK_STATE_SELECTED].green = prefs.text_hlbg_color.green;

	gtk_widget_push_style(style);
	if (!IS_USE_FONTSET()) {
		if ((style->font = gdk_font_load(prefs.text_font_str)) == NULL)
			style->font = gdk_font_load("7x13");
	} else {
		if ((style->font = gdk_fontset_load(prefs.text_font_str)) == NULL)
			style->font = gdk_fontset_load("7x13,*");
	}
	prefs.text_font = style->font;
	gtk_widget_set_style(wgt, style);
	gtk_widget_pop_style();
} /* prefs_update_text_widget_style */
#endif	/* GTK_HAVE_FEATURES_1_1_0 */


/*
 * PUBLIC: prefs_bool_by_name
 *
 * returns pref's bool value by it's prefname
 */
bool_t
prefs_bool_by_name(char *prefname)
{
	prefs_t *pap;
	long *val;

	for (pap = app_prefs; pap->name; pap++) {
		if (strcmp(pap->name, prefname) == 0) {
			if (pap->type != PrefBool) {
				GNPDBG_PREFS(("prefs_bool_by_name: '%s' "
					      "not a PrefBool!\n", pap->name));
				return FALSE;
			}

			val = (long *)(pap->addr);
			if (*val & pap->val) {
				return TRUE;
			}
			return FALSE;
		}
	}

	GNPDBG_PREFS(("prefs_bool_by_name: '%s' not found\n", pap->name));
	return FALSE;
} /* prefs_bool_by_name */


/*** local function definitions ***/
/*
 * PRIVATE: prefs_read
 *
 * actually read the prefs file.  each line's first token is looked up in the
 * app_prefs table.  if it's not in there, then that line is ignored.
 */
static void
prefs_read(FILE *fp)
{
	char *buf, *data, *tok;
	prefs_t *pap;
	bool_t done;

	if (fp == NULL) {
		if ((fp = fopen(apprc, "r")) == NULL) {
			buf = g_new(char, strlen(apprc) + 32);
			sprintf(buf, "prefs_save: could not open '%s'", apprc);
			perror(buf);
			g_free(buf);
			return;
		}
	}

	(void)file_lock(apprc, fp, FALSE, FALSE, TRUE);
	buf = g_new(char, PREFS_NAME_LEN + MAXPATH);
	if (fgets(buf, PREFS_NAME_LEN + MAXPATH, fp)) {
		char *p;
		/* XXX - horrible hack for versioning */
		if ((p = strstr(buf, "gnotepad+ 1.0"))) {
			p += strlen("gnotepad+ 1.0") + 1;
			if (!isdigit((int)(*(p+1))))
				*(p+1) = '\0';
			else
				*(p+2) = '\0';
			if (atoi(p) < 2)
				pre102 = TRUE;
		}
	}

	while (fgets(buf, PREFS_NAME_LEN + MAXPATH, fp)) {
		buf[strlen(buf) - 1] = '\0';	/* remove \n */
		if ((tok = strtok(buf, "=")) == NULL)
			continue;

		/* trim any trailing spaces */
		while (isspace((int)tok[strlen(tok) - 1]))
			tok[strlen(tok) - 1] = '\0';

		data = tok + strlen(tok) + 2;
		while (isspace((int)(*data)))	/* skip to actual value */
			data++;

		GNPDBG_PREFS(("prefs_read: tok  = '%s'\n", tok));
		GNPDBG_PREFS(("prefs_read: data = '%s'\n", data));

		/*
		 * TODO - eventually, if app_prefs gets big, this should be a
		 * binary search instead of a linear traversal.
		 */
		done = FALSE;
		pap = app_prefs;
		while (pap->name) {
			if (pap->addr == NULL) {
				printf("prefs_read: '%s' has NULL addr\n",
					pap->name);
				pap++;
				continue;
			}

			if (strncmp(tok, pap->name, strlen(pap->name)) == 0) {
				switch (pap->type) {
				case PrefBool:
					prefs_bool_set(pap, data);
					break;
				case PrefString:
					prefs_string_set(pap, data);
					break;
				case PrefInt:
					prefs_int_set(pap, data);
					break;
				case PrefByte:
					prefs_byte_set(pap, data);
					break;
				case PrefFloat:
					prefs_float_set(pap, data);
					break;
				default:
					printf("prefs_read: ignoring '%s' "
						"(unknown type=%d)\n",
						pap->name, pap->type);
					break;
				}
				done = TRUE;
			} /* if attr match */

			pap++;

		} /* while pap->name */
	} /* while fgets */

	(void)file_unlock(apprc, fp);
	fclose(fp);
	g_free(buf);
} /* prefs_read */


/*
 * PRIVATE: appgtk_rc_update
 *
 * creates an application specific rc file in gtk format.
 */
static void
appgtk_rc_update(gpointer data)
{
	char *appgtkrc = (char *)data;
	FILE *fp;
	char *buf;
#ifdef HAVE_SETLOCALE
	char *locale;
#endif

	if ((fp = fopen(appgtkrc, "w")) == NULL) {
		buf = g_new(char, strlen(appgtkrc) + 64);
		g_snprintf(buf, strlen(appgtkrc) + 64,
			   "appgtk_rc_update: could not open '%s'", appgtkrc);
		perror(buf);
		g_free(buf);
		return;
	}

	(void)file_lock(appgtkrc, fp, TRUE, FALSE, TRUE);

#ifdef HAVE_SETLOCALE
	locale = setlocale(LC_NUMERIC, NULL);
	GNPDBG_PREFS(("appgtk_rc_update: %s <- LOCALE\n", locale));
	(void)setlocale(LC_NUMERIC, "C");
#endif

	fprintf(fp, "style \"text\"\n{\n\tfont = \"%s\"\n",
		prefs.text_font_str);
	fprintf(fp, "\tbase[NORMAL]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_bg_color.red   / COL_VAL_GDK,
		prefs.text_bg_color.green / COL_VAL_GDK,
		prefs.text_bg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tbg[NORMAL]     = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_bg_color.red   / COL_VAL_GDK,
		prefs.text_bg_color.green / COL_VAL_GDK,
		prefs.text_bg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\ttext[NORMAL]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_fg_color.red   / COL_VAL_GDK,
		prefs.text_fg_color.green / COL_VAL_GDK,
		prefs.text_fg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tfg[NORMAL]     = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_fg_color.red   / COL_VAL_GDK,
		prefs.text_fg_color.green / COL_VAL_GDK,
		prefs.text_fg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tbase[SELECTED] = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlbg_color.red   / COL_VAL_GDK,
		prefs.text_hlbg_color.green / COL_VAL_GDK,
		prefs.text_hlbg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tbg[SELECTED]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlbg_color.red   / COL_VAL_GDK,
		prefs.text_hlbg_color.green / COL_VAL_GDK,
		prefs.text_hlbg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\ttext[SELECTED] = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlfg_color.red   / COL_VAL_GDK,
		prefs.text_hlfg_color.green / COL_VAL_GDK,
		prefs.text_hlfg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tfg[SELECTED]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlfg_color.red   / COL_VAL_GDK,
		prefs.text_hlfg_color.green / COL_VAL_GDK,
		prefs.text_hlfg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "}\nwidget_class \"*GtkText\" style \"text\"\n");

#ifdef HAVE_SETLOCALE
	locale = setlocale(LC_NUMERIC, locale);
	GNPDBG_PREFS(("appgtk_rc_update: %s -> LOCALE\n", locale));
#endif

	(void)file_unlock(appgtkrc, fp);
	fclose(fp);
	gtk_rc_parse(appgtkrc);
} /* appgtk_rc_update */


/*
 * PRIVATE: prefs_string_set
 *
 * set a preference whose setting/value is a "string"
 */
static void
prefs_string_set(prefs_t *pap, char *data)
{
	int len;
	char **string = (char **)(pap->addr);

	if (*string)
		g_free(*string);
	*string = NULL;

	if (data == NULL || data[0] == '\0' || strcmp(data, "(null)") == 0)
		return;

	len = MIN(strlen(data), pap->val);
	*string = g_new(char, len + 1);
	strncpy(*string, data, len);
	(*string)[len] = '\0';
} /* prefs_string_set */


/*
 * PRIVATE: prefs_byte_set
 *
 * set a preference whose setting/value is an integer
 */
static void
prefs_byte_set(prefs_t *pap, char *data)
{
	byte *num = (byte *)(pap->addr);

	*num = (byte)atoi(data);
	if (*num > pap->max)
		*num = (byte)(pap->max);
	if (*num < pap->min)
		*num = (byte)(pap->min);
} /* prefs_byte_set */


/*
 * PRIVATE: prefs_float_set
 *
 * set a preference whose setting/value is a float
 */
static void
prefs_float_set(prefs_t *pap, char *data)
{
	float *num = (float *)(pap->addr);

	sscanf(data, "%f", num);
	if (*num > pap->max)
		*num = (float)(pap->max);
	if (*num < pap->min)
		*num = (float)(pap->min);
} /* prefs_float_set */


/*
 * PRIVATE: prefs_int_set
 *
 * set a preference whose setting/value is an integer
 */
static void
prefs_int_set(prefs_t *pap, char *data)
{
	int *num = (int *)(pap->addr);

	*num = atoi(data);
	if (*num > pap->max)
		*num = (int)(pap->max);
	if (*num < pap->min)
		*num = (int)(pap->min);
} /* prefs_int_set */


/*
 * PRIVATE: prefs_bool_set
 *
 * set a preference whose setting/value is a boolean.  NOTE!!  the convention
 * here is that booleans use bitmasks to toggle their settings.  the variable
 * itself must be stored in a "long".
 */
static void
prefs_bool_set(prefs_t *pap, char *data)
{
	long *opts;

	opts = (long *)(pap->addr);

	if (tolower((int)data[0]) == 't' || data[0] == '1') {
		*opts |= pap->val;
	} else if (tolower((int)data[0]) == 'f' || data[0] == '0') {
		*opts &= ~pap->val;
	}
} /* prefs_bool_set */


/*
 * PRIVATE: prefs_tf
 *
 * returns the string 'true' or 'false'
 */
static char *
prefs_tf(long opts, long mask)
{
	return (opts & mask) ? "true" : "false";
} /* prefs_tf */


/*
 * PRIVATE: prefs_dialog_create
 *
 * creates the preferences window.
 *
 * 1. Appearance
 * 2. Document
 * 3. Window
 * 4. Fonts and Colors
 * 5. Main Toolbar
 * 6. Html Toolbar
 * 7. Misc
 */
static void
prefs_dialog_create(win_t *w)
{
	GtkWidget *vbox, *hbox, *prefs_nb;

	if (prefs_win)
		return;

	prefs_wgtopt_list_init();

	/* create top level */
	prefs_win = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(prefs_win), _("gnotepad+ Preferences"));
	(void)gtk_signal_connect(GTK_OBJECT(prefs_win), "destroy",
				 GTK_SIGNAL_FUNC(prefs_win_destroy), NULL);
	gtk_container_border_width(GTK_CONTAINER(prefs_win), 5);

	/* create vbox to hold everything */
	vbox = GTK_DIALOG(prefs_win)->vbox;
	gtk_container_border_width(GTK_CONTAINER(vbox), 5);

	/* create notebook */
	prefs_nb = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(prefs_nb), prefs_tabpos);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(prefs_nb), TRUE);
	gtk_notebook_popup_enable(GTK_NOTEBOOK(prefs_nb));
	gtk_box_pack_start(GTK_BOX(vbox), prefs_nb, TRUE, TRUE, 0);

	/* create various pages of the notebook */
	prefs_page_appearance_create(prefs_nb);
	prefs_page_document_create(prefs_nb);
	prefs_page_window_create(prefs_nb);
	prefs_page_fonts_colors(prefs_nb);
	prefs_page_main_tb(prefs_nb);
	prefs_page_html_tb(prefs_nb);
	prefs_page_scc_create(prefs_nb);
	prefs_page_misc_create(prefs_nb);

	/* lastly, the buttons */
#if 0
	/* if we don't use gtk_dialog_new() and just create a regular top level
	   window, we can use the following code snippit to have more control
	   over how the buttons are laid out */
	hbox = gtk_hbutton_box_new();
	gtk_container_border_width(GTK_CONTAINER(hbox), 5);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
#endif
	hbox = GTK_DIALOG(prefs_win)->action_area;
	(void)misc_button_new_w_label(_("Save"), GNOME_STOCK_PIXMAP_SAVE,
				      GTK_SIGNAL_FUNC(prefs_save_cb),
				      w, hbox, PACK_START | PACK_EXPAND |
				      PACK_FILL | CANCEL_DEFAULT, 0);
	(void)misc_button_new_w_label(_("Tab Position"), NULL,
				      GTK_SIGNAL_FUNC(prefs_tab_pos_change),
				      prefs_nb, hbox, PACK_START | PACK_EXPAND |
				      PACK_FILL | CANCEL_DEFAULT, 0);
	(void)misc_button_new_w_label(_("Cancel"), GNOME_STOCK_BUTTON_CANCEL,
				      GTK_SIGNAL_FUNC(prefs_win_cancel),
				      NULL, hbox, 
				      PACK_START | PACK_EXPAND | PACK_FILL |
				      CANCEL_DEFAULT | GRAB_DEFAULT, 0);

	gtk_widget_show_all(prefs_win);

#ifdef GTK_HAVE_FEATURES_1_1_0
	/* update the prefs window's text widget and insert sample text */
	prefs_update_text_widget_style(prefs_txt);
	gtk_text_set_editable(GTK_TEXT(prefs_txt), FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(prefs_txt), TRUE);
	gtk_widget_realize(prefs_txt);
	gtk_text_insert(GTK_TEXT(prefs_txt),
		NULL, NULL, NULL,
		"This is some sample text.  Note that color changes only take "
		"immediate effect if you are using gtk versions 1.1.x or "
		"1.2.x, but not 1.0.x.",
		-1);
#endif
} /* prefs_dialog_create */


#ifdef USE_SOURCE_CTRL
/*
 * PRIVATE: prefs_frame_scc_selection
 *
 * creates the pulldown combo box for selecting the method of source code
 * control.
 */
static void
prefs_frame_scc_selection(GtkWidget *parent)
{
	GtkWidget *frame, *vbox;
	int i;
	GList *scc_list;

	/* list is freed in prefs_wgtopt_list_free() */
	scc_list = NULL;
	for (i = 0; i < SCC_NUM_TYPES; i++)
		scc_list = g_list_append(scc_list,
					 gettext(scc_tbl[i].scc_desc_name));

	prefs_box_in_frame(_("Source Control Configuration"), 0, &frame, &vbox,
			   TRUE);

	(void)prefs_pulldown_with_label_create(
			vbox,
			_(" Source Control Program "),
			scc_list,
			"scc_selected",
			prefs.scc_selected
			);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, TRUE, TRUE, 0);
} /* prefs_frame_doctab_create */


/*
 * PRIVATE: prefs_page_scc_create
 *
 * creates the notebook page for configuration of source code control options.
 */
static void
prefs_page_scc_create(GtkWidget *prefs_nb)
{
	GtkWidget *scc_nb, *vbox, *tmp;
	GtkWidget *frame, *table;
	int i, j;

	/* create notebook to hold all the source code control systems */
	scc_nb = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(scc_nb), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(scc_nb), TRUE);
	gtk_notebook_popup_enable(GTK_NOTEBOOK(scc_nb));

	for (i = 0; i < SCC_NUM_TYPES; i++) {
		prefs_box_in_frame(gettext(scc_tbl[i].scc_desc_name),
                           10, &frame, &vbox, TRUE);
		table = gtk_table_new(SCC_NUM_CMDS, 2, FALSE);
		gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
		gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

		for (j = 0; j < SCC_NUM_CMDS; j++) {
			tmp = misc_entry_w_label_create(
					vbox,
					gettext(scc_cmd_desc[j]),
					prefs.scc[i][j],
					table, 0, 1, j, j + 1, 1, 2, j, j + 1);
			prefs_wgtopt_list_add(tmp, EntryType, NULL,
					      scc_tbl[i].scc_cmds[j].pref);
		}

		tmp = gtk_label_new(gettext(scc_tbl[i].scc_desc_name));
		gtk_notebook_append_page(GTK_NOTEBOOK(scc_nb), frame, tmp);
	}

	/* XXX - this doesn't appear to work?! */
	gtk_notebook_set_page(GTK_NOTEBOOK(scc_nb), (int)prefs.scc_selected);

	vbox = gtk_vbox_new(FALSE, 0);
	prefs_frame_scc_selection(vbox);
	gtk_box_pack_start(GTK_BOX(vbox), scc_nb, FALSE, FALSE, 0);

	tmp = gtk_label_new(_("Source Control"));
	gtk_notebook_append_page(GTK_NOTEBOOK(prefs_nb), vbox, tmp);
} /* prefs_page_scc_create */
#endif	/* USE_SOURCE_CTRL */


/*
 * PRIVATE: prefs_page_window_create
 *
 * creates the page titled "Window"
 *
 * 3. Window
 *	save window height on exit	(check button)
 *	default window height		(spin button)
 *	save window width on exit	(check button)
 *	default window width		(spin button)
 *
 *	save window position on exit	(check button)
 *	default window x-position	(spin button)
 *	default window y-position	(spin button)
 */
static void
prefs_page_window_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *table;

	prefs_box_in_frame(_("Window Settings"), 10, &frame, &vbox, TRUE);

	table = gtk_table_new(10, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	/* save window height on exit */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Save Window height on exit "),
			IS_SAVE_WIN_HEIGHT(),
			"save_win_height",
			table, 0, 2, 0, 1);

	/* save window width on exit */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Save Window width on exit "),
			IS_SAVE_WIN_WIDTH(),
			"save_win_width",
			table, 0, 2, 2, 3);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 4, 5);

	/* save window position on exit */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Save Window Position on Exit "),
			IS_SAVE_WIN_POS(),
			"save_win_pos",
			table, 0, 2, 5, 6);

	/* default window xpos */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Default x-pos (-1 for auto) "),
			(float)prefs.win_xpos, -1.0, 2048.0, 1.0, 1.0, 0,
			"win_xpos",
			table, 0, 1, 6, 7, 1, 2, 6, 7);

	/* default window ypos */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Default y-pos (-1 for auto) "),
			(float)prefs.win_ypos, -1.0, 2048.0, 1.0, 1.0, 0,
			"win_ypos",
			table, 0, 1, 7, 8, 1, 2, 7, 8);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 8, 9);

#ifdef USE_RANDOMTIPS
	/* random tips spin button */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Random tips secs (0 disables) "),
			(float)prefs.random_tips, 0.0, 86400.0, 1.0, 1.0, 0.0,
			"random_tips_delay",
			table, 0, 1, 9, 10, 1, 2, 9, 10);
#endif	/* USE_RANDOMTIPS */

	/* stuff into notebook */
	tmp = gtk_label_new(_("Window"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_window_create */


/*
 * PRIVATE: prefs_page_document_create
 *
 * creates the notebook page titled "Document"
 *
 * 2. Document
 *	autosave		(spin button)
 *	max num of recent docs	(spin button)
 *	wordwrap on/off		(check button)
 *	fonts			(popup must return string)
 *	colors			(popup must return string)
 */
static void
prefs_page_document_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *table;

	prefs_box_in_frame(_("Document Settings"), 10, &frame, &vbox, TRUE);

	table = gtk_table_new(10, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	/* tab stop */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Tab stop width "),
			(float)prefs.tab_stop, 1.0, 256.0, 1.0, 1.0, 0.0,
			"tab_stop",
			table, 0, 1, 0, 1, 1, 2, 0, 1);
#ifdef USE_AUTOSAVE
	/* autosave spin button */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Autosave minutes (0 disables) "),
			(float)prefs.autosave, 0.0, 1440.0, 1.0, 1.0, 0.0,
			"autosave_timeout",
			table, 0, 1, 1, 2, 1, 2, 1, 2);
#endif	/* USE_AUTOSAVE */
#ifdef USE_RECENT
	/* max num of recent doc */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Maximum # of recent documents "),
			(float)prefs.maxrecent, 0.0, 255.0, 1.0, 1.0, 0.0,
			"max_num_recent",
			table, 0, 1, 2, 3, 1, 2, 2, 3);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 3, 4);
#endif	/* USE_RECENT */
	/* word wrap */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Use wordwrap"),
			IS_USE_WORDWRAP(),
			"use_wordwrap",
			table, 0, 2, 4, 5);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 5, 6);

#ifdef USE_BACKUP
	/* write backup */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Write backup file"),
			IS_DO_BACKUP(),
			"do_backup",
			table, 0, 1, 6, 7);

	tmp = misc_entry_w_label_create(
			vbox, _(" Backup directory "), prefs.backupdir,
			table, 0, 1, 7, 8, 1, 2, 7, 8);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "backupdir");

	tmp = misc_entry_w_label_create(
			vbox, _(" Backup file suffix "), prefs.backupsuffix,
			table, 0, 1, 8, 9, 1, 2, 8, 9);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "backupsuffix");
#endif	/* USE_BACKUP */

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 9, 10);

	/* stuff into notebook */
	tmp = gtk_label_new(_("Document"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_document_create */


#ifdef USE_TOOLBARS
/*
 * PRIVATE: prefs_page_main_tb
 *
 * creates the notebook page for the "Main Toolbar Buttons"
 */
extern toolbar_data_t main_tbdata[];

static void
prefs_page_main_tb(GtkWidget *nb)
{
	GtkWidget *frame;

	frame = prefs_frame_tb(nb, _("Main Toolbar"), 6, main_tbdata);

	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame,
				 gtk_label_new(_("Main Toolbar")));
} /* prefs_page_main_tb */


# ifdef USE_HTMLTAGS
/*
 * PRIVATE: prefs_page_html_tb
 *
 * creates the notebook page for the "HTML Toolbar Buttons"
 */
extern toolbar_data_t html_tbdata[];

static void
prefs_page_html_tb(GtkWidget *nb)
{
	GtkWidget *f1, *f2, *vbox;

	prefs_box_in_frame(_("HTML Toolbar Settings"), 7, &f1, &vbox, TRUE);
	(void)prefs_check_button_with_label_create(
			   vbox, _("Use Advanced HTML Toolbars"),
			   (long)prefs_bool_by_name("advanced_html_tb"),
			   "advanced_html_tb", NULL, -1, -1, -1, -1);

	f2 = prefs_frame_tb(nb, _("Main HTML Toolbar Buttons"), 10, html_tbdata);
	gtk_box_pack_start(GTK_BOX(vbox), f2, FALSE, FALSE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(nb), f1,
				 gtk_label_new(_("HTML Toolbar")));
} /* prefs_page_html_tb */
# endif	/* USE_HTMLTAGS */


/*
 * PRIVATE: prefs_frame_tb
 *
 * returns a frame filled with buttons for the toolbar configuration.
 */
static GtkWidget *
prefs_frame_tb(GtkWidget *nb, char *pagename, int num_per_column,
	       toolbar_data_t *tbdtable)
{
	GtkWidget *frame, *hbox, *tbvbox, *vb = NULL;
	toolbar_data_t *tbdp;
	int count;

	prefs_box_in_frame(pagename, 7, &frame, &tbvbox, TRUE);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbvbox), hbox, FALSE, FALSE, 0);

	for (count = 0, tbdp = tbdtable; tbdp->text; tbdp++) {
		if (count % num_per_column == 0) {
			vb = gtk_vbox_new(FALSE, 0);
			gtk_box_pack_start(GTK_BOX(hbox), vb, FALSE, FALSE, 0);
		}

		if (strcmp(tbdp->text, " SPACE ") == 0)
			continue;

		(void)prefs_check_button_with_label_create(
				vb,
				gettext(tbdp->tooltip_text),
				(long)prefs_bool_by_name(tbdp->prefname),
				tbdp->prefname,
				NULL, -1, -1, -1, -1);

		count++;
	}

	return frame;
} /* prefs_frame_tb */
#endif	/* USE_TOOLBARS */


/*
 * PRIVATE: prefs_page_fonts_colors
 *
 * creates the notebook page titled "Fonts and Colors"
 *
 * Fonts and Colors
 *	Font Selection		(push button w/label)
 *	Text Foreground		(push button w/label)
 *	Text Background		(push button w/label)
 *	Highlight Foreground	(push button w/label)
 *	Highlight Background	(push button w/label)
 */
struct prefs_page_fonts_colors_nfo {
	char *labeltext;
	GtkSignalFunc cbfunc;
	char *preftext;
	gpointer pdata;
	which_text_t which;
};
typedef struct prefs_page_fonts_colors_nfo prefs_pfcn_t;


#ifdef USE_GNOME
static GtkWidget *
prefs_gnome_color_picker(prefs_pfcn_t *pb, GtkWidget *parent)
{
	GtkWidget *tmp, *l, *h;
	GdkColor *gcp = (GdkColor *)pb->pdata;

	h = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), h, FALSE, FALSE, 0);
	l =  gtk_label_new(pb->labeltext);
	gtk_box_pack_start(GTK_BOX(h), l, FALSE, FALSE, 0);

	tmp = gnome_color_picker_new();

	gtk_signal_connect(GTK_OBJECT(tmp), "color_set",
			   GTK_SIGNAL_FUNC(pb->cbfunc),
			   GINT_TO_POINTER(pb->which));

	gnome_color_picker_set_dither(GNOME_COLOR_PICKER(tmp), FALSE);
	gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(tmp), FALSE);
	gtk_box_pack_end(GTK_BOX(h), tmp, FALSE, FALSE, 0);

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(tmp),
				   gcp->red, gcp->green, gcp->blue, 0);

	return tmp;
} /* prefs_gnome_color_picker */


static GtkWidget *
prefs_gnome_font_picker(prefs_pfcn_t *pb, GtkWidget *parent)
{
	GtkWidget *tmp = gnome_font_picker_new();
	gtk_signal_connect(GTK_OBJECT(tmp), "font_set",
			   GTK_SIGNAL_FUNC(pb->cbfunc), NULL);
	gnome_font_picker_set_title(GNOME_FONT_PICKER(tmp),
				    "Font Selection...");
	gnome_font_picker_set_mode(GNOME_FONT_PICKER(tmp),
				   GNOME_FONT_PICKER_MODE_FONT_INFO);
	gnome_font_picker_set_font_name(GNOME_FONT_PICKER(tmp),
					*(char **)pb->pdata);
	/*
	 * look at the name of this next gnome function.  why the hell is it so
	 * long?  someone has a serious function-naming-growth-hormone-problem.
	 */
	gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(tmp),
						   TRUE, 14);
	/* don't show the size; something is screwed up with
	 * the gnome font picker */
	gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(tmp), FALSE);
	gtk_box_pack_start(GTK_BOX(parent), tmp, FALSE, FALSE, 10);

	return tmp;
} /* prefs_gnome_font_picker */
#endif	/* USE_GNOME */


static void
prefs_page_fonts_colors(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *vbox2, *tmp, *hbox;

	prefs_pfcn_t *pb;
	prefs_pfcn_t pfcn_buttons[] = {
		{
			N_("Font Selection"),
			GTK_SIGNAL_FUNC(prefs_font_sel_cb),
			"text_font",
			&prefs.text_font_str
		},
		{
			N_("Text Foreground"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_fg_color",
			&prefs.text_fg_color,
			Foreground
		},
		{
			N_("Text Background"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_bg_color",
			&prefs.text_bg_color,
			Background
		},
		{
			N_("Highlighted Foreground"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_hlfg_color",
			&prefs.text_hlfg_color,
			HighlightFg
		},
		{
			N_("Highlighted Background"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_hlbg_color",
			&prefs.text_hlbg_color,
			HighlightBg
		},
		{ NULL }
	};

	prefs_box_in_frame(_("Fonts and Colors"), 10, &frame, &vbox, TRUE);
	/* stuff into notebook */
	tmp = gtk_label_new(_("Fonts/Colors"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, TRUE, 10);

	for (pb = pfcn_buttons; pb->labeltext; pb++) {
#ifdef USE_GNOME
		if (strcmp(pb->labeltext, "Font Selection") == 0)
			tmp = prefs_gnome_font_picker(pb, vbox2);
		else
			tmp = prefs_gnome_color_picker(pb, vbox2);
#else
		tmp = misc_button_new_w_label(
			pb->labeltext, NULL,
			GTK_SIGNAL_FUNC(pb->cbfunc),
			GINT_TO_POINTER(pb->which),
			vbox2,
			PACK_START | PACK_EXPAND | PACK_FILL | NO_RELIEF,
			0);
#endif
		prefs_wgtopt_list_add(tmp, GenericType, NULL, pb->preftext);
	}

#ifdef GTK_HAVE_FEATURES_1_1_0
	frame = gtk_frame_new(_("Sample Output"));
	gtk_container_border_width(GTK_CONTAINER(frame), 10);

	prefs_txt = gtk_text_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(frame), prefs_txt);
	gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 10);
#else
	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 10);
	tmp = gtk_label_new(
		_(" NOTE: for gtk-1.0.x, font and color changes \n"
		" take effect the next time you run gnotepad+ "));
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 10);
#endif
	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 0);
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Use fontset"),
			IS_USE_FONTSET(),
			"use_fontset",
			NULL, 0, 1, 5, 6);
} /* prefs_page_fonts_colors */


static void
color_sel_ok_common(which_text_t which, char *buf)
{
	switch (which) {
	case Foreground:
		if (prefs.text_fg_str)
			g_free(prefs.text_fg_str);
		prefs.text_fg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_fg_color = '%s'\n",
			      prefs.text_fg_str));
		break;
	case Background:
		if (prefs.text_bg_str)
			g_free(prefs.text_bg_str);
		prefs.text_bg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_bg_color = '%s'\n",
			      prefs.text_bg_str));
		break;
	case HighlightFg:
		if (prefs.text_hlfg_str)
			g_free(prefs.text_hlfg_str);
		prefs.text_hlfg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_hlfg_color = '%s'\n",
			      prefs.text_hlfg_str));
		break;
	case HighlightBg:
		if (prefs.text_hlbg_str)
			g_free(prefs.text_hlbg_str);
		prefs.text_hlbg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_hlbg_color = '%s'\n",
			      prefs.text_hlbg_str));
		break;
	} /* switch which */

	prefs_update_text_widget_style(prefs_txt);
} /* color_sel_ok_common */


#ifdef USE_GNOME
/*
 * Note that the order of the parameters is r-b-g, but it's really r-g-b
 */
static void
prefs_text_color_cb(GtkWidget *wgt, guint r, guint b, guint g, guint a,
		    gpointer cbdata)
{
	int which = GPOINTER_TO_INT(cbdata);
	char buf[MAX_RGB_STR];

	g_snprintf(buf, MAX_RGB_STR, "%u %u %u", r, g, b);

	color_sel_ok_common(which, buf);
}

#else	/* no GNOME */

/*
 * PRIVATE: prefs_text_color_cb
 *
 * creates the color selection dialog and sets up the callbacks.  some of this
 * code was taken from testgtk.c
 *
 * rgb_str: points to either text_fg_str or text_bg_str.
 */
static void
prefs_text_color_cb(GtkWidget *wgt, gpointer cbdata)
{
	int which = GPOINTER_TO_INT(cbdata);
	gdouble color[4];
	prefs_color_sel_t *pcsp;
	static char *which_txt[] = { /* some compilers need this to be static */
		"Text Foreground Color Selection",
		"Text Background Color Selection",
		"Text Hightlight Foreground Color Selection",
		"Text Hightlight Background Color Selection"
	};

	pcsp = g_new(prefs_color_sel_t, 1);
	pcsp->cs = gtk_color_selection_dialog_new(which_txt[which]);
	pcsp->which = which;

	switch (which) {
	case Foreground:
		sscanf(prefs.text_fg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	case Background:
		sscanf(prefs.text_bg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	case HighlightFg:
		sscanf(prefs.text_hlfg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	case HighlightBg:
		sscanf(prefs.text_hlbg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	}
	color[0] /= COL_VAL_GDK;
	color[1] /= COL_VAL_GDK;
	color[2] /= COL_VAL_GDK;
	gtk_color_selection_set_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->colorsel), color);

	(void)gtk_signal_connect(GTK_OBJECT(pcsp->cs), "destroy",
		GTK_SIGNAL_FUNC(prefs_color_sel_destroy), pcsp);

	(void)gtk_signal_connect(GTK_OBJECT(
		GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->ok_button), "clicked",
		GTK_SIGNAL_FUNC(prefs_color_sel_ok), pcsp);

	(void)gtk_signal_connect(GTK_OBJECT(
		GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->cancel_button), "clicked",
		GTK_SIGNAL_FUNC(prefs_color_sel_close), pcsp);

	gtk_widget_show(pcsp->cs);
} /* prefs_text_color_cb */


/*
 * PRIVATE: prefs_color_sel_destroy
 *
 * callback for the "destroy" event for the color selection dialog
 */
static void
prefs_color_sel_destroy(GtkWidget *wgt, gpointer cbdata)
{
	prefs_color_sel_t *pcsp = (prefs_color_sel_t *)cbdata;

	if (pcsp) {
		g_free(pcsp);
		pcsp = NULL;
	}
} /* prefs_color_sel_destroy */


/*
 * PRIVATE: prefs_color_sel_close
 *
 * callback for the "Close" button from the color selection dialog
 */
static void
prefs_color_sel_close(GtkWidget *wgt, gpointer cbdata)
{
	prefs_color_sel_t *pcsp = (prefs_color_sel_t *)cbdata;

	g_assert(pcsp != NULL);
	gtk_widget_destroy(pcsp->cs);
} /* prefs_color_sel_close */

/*
 * PRIVATE: prefs_color_sel_ok
 *
 * callback for the "Ok" button in the color selection dialog.  gets the color
 * from the color selection dialog, then converts it into a character string
 * containing RGB values.
 */
static void
prefs_color_sel_ok(GtkWidget *wgt, gpointer cbdata)
{
	prefs_color_sel_t *pcsp = (prefs_color_sel_t *)cbdata;
	GtkColorSelection *colorsel;
	gdouble color[4];
	char buf[MAX_RGB_STR];

	g_assert(pcsp != NULL);
	colorsel = GTK_COLOR_SELECTION(
			GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->colorsel);

	/*
	 * NOTE!  gtk_color_selection_get_color() returns the color in the
	 * order red-blue-green, instead of red-green-blue.
	 */
	gtk_color_selection_get_color(colorsel, color);

	GNPDBG_PREFS(("prefs_color_sel_ok: colors = (red %f) (green %f) "
		      "(blue %f)\n", color[0], color[2], color[1]));
	g_snprintf(buf, MAX_RGB_STR, "%u %u %u",
		   (unsigned)(color[0] * COL_VAL_GDK),
		   (unsigned)(color[2] * COL_VAL_GDK),
		   (unsigned)(color[1] * COL_VAL_GDK));
	GNPDBG_PREFS(("prefs_color_sel_ok: buf = '%s'\n", buf));

	color_sel_ok_common(pcsp->which, buf);
	gtk_widget_destroy(pcsp->cs);
} /* prefs_color_sel_ok */


#endif	/* USE_GNOME */


/*
 * PRIVATE: prefs_text_color_update
 *
 * reads the RGB string values and converts them into what GDK expects.
 */
void
prefs_text_color_update(void)
{
	GdkColormap *gdkcmap;

	gdkcmap = gdk_colormap_get_system();

	sscanf(prefs.text_fg_str, "%hu %hu %hu", &prefs.text_fg_color.red,
						 &prefs.text_fg_color.blue,
						 &prefs.text_fg_color.green);
	GNPDBG_PREFS(("prefs_text_color_update: FG pixel %lu, "
		      "red %u, blue %u, green %u\n",
		      prefs.text_fg_color.pixel, prefs.text_fg_color.red,
		      prefs.text_fg_color.blue, prefs.text_fg_color.green));

	if (pre102) {
		g_free(prefs.text_bg_str);
		prefs.text_bg_str = g_strdup("65535 65535 65535");
	}
	sscanf(prefs.text_bg_str, "%hu %hu %hu", &prefs.text_bg_color.red,
						 &prefs.text_bg_color.blue,
						 &prefs.text_bg_color.green);
	GNPDBG_PREFS(("prefs_text_color_update: BG pixel %lu, "
		      "red %u, blue %u, green %u\n",
		      prefs.text_bg_color.pixel, prefs.text_bg_color.red,
		      prefs.text_bg_color.blue, prefs.text_bg_color.green));

	sscanf(prefs.text_hlfg_str, "%hu %hu %hu",&prefs.text_hlfg_color.red,
						  &prefs.text_hlfg_color.blue,
						  &prefs.text_hlfg_color.green);
	sscanf(prefs.text_hlbg_str, "%hu %hu %hu",&prefs.text_hlbg_color.red,
						  &prefs.text_hlbg_color.blue,
						  &prefs.text_hlbg_color.green);

	if (!gdk_color_alloc(gdkcmap, &prefs.text_fg_color))
		g_error("prefs_text_color_update: couldn't alloc fg color");
	if (!gdk_color_alloc(gdkcmap, &prefs.text_bg_color))
		g_error("prefs_text_color_update: couldn't alloc bg color");
	if (!gdk_color_alloc(gdkcmap, &prefs.text_hlfg_color))
		g_error("prefs_text_color_update: couldn't alloc hlfg color");
	if (!gdk_color_alloc(gdkcmap, &prefs.text_hlbg_color))
		g_error("prefs_text_color_update: couldn't alloc hlbg color");
} /* prefs_text_color_update */


static void
font_sel_ok_common(char *newfont)
{
	if (prefs.text_font_str)
		g_free(prefs.text_font_str);
	prefs.text_font_str = g_strdup(newfont);
	GNPDBG_PREFS(("font_sel_ok_common: text_font_str '%s'\n",
		       prefs.text_font_str));

	if (IS_USE_FONTSET()) {
		prefs.text_font = gdk_fontset_load(prefs.text_font_str);
                if (prefs.text_font == NULL) {
                        prefs.text_font = gdk_fontset_load("DEFAULT_FONT,*");
                        if (prefs.text_font == NULL)  
                		prefs.text_font = gdk_fontset_load("7x13,*");  
		}
        } else {
		prefs.text_font = gdk_font_load(prefs.text_font_str);
		if (prefs.text_font == NULL) {
			prefs.text_font = gdk_font_load(DEFAULT_FONT);
			if (prefs.text_font == NULL)
				prefs.text_font = gdk_font_load("7x13");
		}
	}
	prefs_update_text_widget_style(prefs_txt);
}


#ifdef USE_GNOME
static void
prefs_font_sel_cb(GnomeFontPicker *gfp, char *newfont, gpointer cbdata)
{
	if (!newfont)
		return;

	font_sel_ok_common(newfont);
}

#else	/* no GNOME */

/*
 * PRIVATE: prefs_font_sel_cb
 *
 * creates font selection dialog box and sets up callbacks.
 */
static void
prefs_font_sel_cb(GtkWidget *wgt, gpointer cbdata)
{
	GtkWidget *tmp;

	tmp = gtk_font_selection_dialog_new("Font Selection");
	(void)gtk_signal_connect(
		GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(tmp)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(prefs_font_sel_ok), tmp);

	(void)gtk_signal_connect(
		GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(tmp)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(prefs_font_sel_cancel), tmp);

	(void)gtk_signal_connect(GTK_OBJECT(tmp), "destroy",
				 GTK_SIGNAL_FUNC(gtk_widget_destroy), tmp);

	gtk_font_selection_dialog_set_font_name(
		GTK_FONT_SELECTION_DIALOG(tmp), prefs.text_font_str);

	gtk_widget_show(tmp);
} /* prefs_font_sel_cb */


/*
 * PRIVATE: prefs_font_sel_ok
 *
 * callback for "Ok" button on font selection dialog.  gets the font string
 * from the dialog, and calls gdk_font_load() to load it from the system.
 */
static void
prefs_font_sel_ok(GtkWidget *wgt, gpointer cbdata)
{
	GtkFontSelectionDialog *fsd = (GtkFontSelectionDialog *)cbdata;
	char *newfont;

	newfont = gtk_font_selection_dialog_get_font_name(fsd);
	if (newfont == NULL) {
		GNPDBG_PREFS(("prefs_font_sel_ok: no font chosen\n"));
		return;
	}

	font_sel_ok_common(newfont);
	g_free(newfont);
	gtk_widget_destroy(GTK_WIDGET(fsd));
} /* prefs_font_sel_ok */


/*
 * PRIVATE: prefs_font_sel_cancel
 *
 * callback for "Cancel" button on font selection dialog
 */
static void
prefs_font_sel_cancel(GtkWidget *wgt, gpointer cbdata)
{
	GtkFontSelectionDialog *fsd = (GtkFontSelectionDialog *)cbdata;

	gtk_widget_destroy(GTK_WIDGET(fsd));
} /* prefs_font_sel_cancel */

#endif	/* USE_GNOME */

/*
 * PRIVATE: prefs_frame_msgbar_create
 *
 * creates the frame to contain options for the message bar
 */
static void
prefs_frame_msgbar_create(GtkWidget *parent)
{
	GtkWidget *frame, *tmp, *vbox;

	prefs_box_in_frame(_("Message Bar"), 0, &frame, &vbox, TRUE);

	/* 'show msg bar' check box */
	tmp = prefs_check_button_with_label_create(
			vbox,
			_("Show msg bar"),
			IS_SHOW_MSGBAR(),
			"show_message_bar",
			NULL, -1, -1, -1, -1);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, TRUE, TRUE, 0);
} /* prefs_frame_msgbar_create */


/*
 * PRIVATE: prefs_frame_doctab_create
 *
 * creates the frame to contain options for the document tabs
 */
static void
prefs_frame_doctab_create(GtkWidget *parent)
{
	GtkWidget *frame, *vbox;
	GList *tabpos_list;

	/* list is freed in prefs_wgtopt_list_free() */
	tabpos_list = NULL;
	tabpos_list = g_list_prepend(tabpos_list, _("Bottom"));
	tabpos_list = g_list_prepend(tabpos_list, _("Top"));
	tabpos_list = g_list_prepend(tabpos_list, _("Right"));
	tabpos_list = g_list_prepend(tabpos_list, _("Left"));

	prefs_box_in_frame(_("Document Tabs"), 0, &frame, &vbox, TRUE);

	/* 'show doc tabs' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show doc tabs"),
			IS_SHOW_TABS(),
			"show_doc_tabs",
			NULL, -1, -1, -1, -1);

	/* tab position */
	(void)prefs_pulldown_with_label_create(
			vbox,
			_(" Tab position "),
			tabpos_list,
			"doc_tab_position",
			prefs.tabpos
			);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, TRUE, TRUE, 0);
} /* prefs_frame_doctab_create */


/*
 * PRIVATE: prefs_page_appearance_create
 *
 * creates the notebook page titled "Appearance"
 *
 * 1. Appearance
 *	toolbar on/off		(check button)
 *	toolbar style		(radio buttons)
 *	tooltips on/off		(check button)
 *	doc tabs on/off		(check button)
 *	doc tabs position	(pulldown combo entry text)
 *	msgbar on/off		(check button)
 */
static void
prefs_page_appearance_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *hbox;

	prefs_box_in_frame(_("Appearance Settings"), 10, &frame, &vbox, TRUE);

	prefs_frame_toolbar_create(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);

	prefs_frame_doctab_create(hbox);
	prefs_frame_msgbar_create(hbox);

	/* stuff into notebook */
	tmp = gtk_label_new(_("Appearance"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_appearance_create */


#ifdef USE_TOOLBARS
/*
 * PRIVATE: prefs_frame_toolbar_create
 *
 * creates the frame to contain options for the toolbar
 */
static void
prefs_frame_toolbar_create(GtkWidget *parent)
{
	GtkWidget *frame, *hbox, *vbox, *radio, *tbvbox;

	prefs_box_in_frame(_("Toolbar Settings"), 0, &frame, &tbvbox, TRUE);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbvbox), hbox, FALSE, FALSE, 0);

	/* put first two checkboxes into one vbox */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

	/* 'show toolbar' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show Toolbar"),
			IS_SHOW_TOOLBAR(),
			"show_toolbar",
			NULL, -1, -1, -1, -1);

	/* 'show tooltips' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show Tooltips"),
			IS_SHOW_TOOLTIPS(),
			"show_tooltips",
			NULL, -1, -1, -1, -1);

#ifdef GTK_HAVE_FEATURES_1_1_0
	/* 'raised buttons' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Raised Buttons"),
			IS_TOOLBAR_RAISED(),
			"toolbar_raised",
			NULL, -1, -1, -1, -1);

#endif

	/* now another vbox into the hbox */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

	/* radio buttons for toolbar style */
	radio = prefs_radio_button_with_label_create(
			vbox,
			NULL,
			_("Pictures and Text"),
			IS_TEXT_PIC_TOOLBAR(),
			"toolbar_pictext");
	(void)prefs_radio_button_with_label_create(
			vbox,
			radio,
			_("Pictures Only"),
			IS_PIC_TOOLBAR(),
			"toolbar_piconly");
	(void)prefs_radio_button_with_label_create(
			vbox,
			radio,
			_("Text Only"),
			IS_TEXT_TOOLBAR(),
			"toolbar_textonly");
	gtk_box_pack_start(GTK_BOX(tbvbox), gtk_hseparator_new(),
			   FALSE, FALSE, 0);

#ifdef USE_HTMLTAGS
	/* 'show html toolbar' check box */
	(void)prefs_check_button_with_label_create(
			tbvbox,
			_("Show Html Toolbar"),
			IS_SHOW_HTML_TOOLBAR(),
			"show_html_toolbar",
			NULL, -1, -1, -1, -1);
#endif	/* USE_HTMLTAGS */

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, FALSE, FALSE, 0);
} /* prefs_frame_toolbar_create */
#endif	/* USE_TOOLBARS */


/*
 * PRIVATE: prefs_page_misc_create
 *
 * creates the notebook page titled "Miscellaneous"
 *
 * 4. Misc
 *	tmpdir				(text entry string)
 *	printcmd			(text entry string)
 *	msgbox on/off			(check button)
 *	max # msgs			(spin button w/ text entry)
 *	msgbox truncate percentage	(spin button w/ text entry)
 */
static void
prefs_page_misc_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *table;

	prefs_box_in_frame(_("Miscellaneous"), 10, &frame, &vbox, TRUE);

	table = gtk_table_new(4, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

#ifdef WANT_BACKGROUND
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Execute in background"),
			IS_DO_FORK(),
			"do_fork",
			NULL, -1, -1, -1, -1);
#endif
#ifdef WANT_SPLASH
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show splash/init screen"),
			IS_SHOW_SPLASH(),
			"show_splash",
			NULL, -1, -1, -1, -1);
#endif

	/* print cmd */
	tmp = misc_entry_w_label_create(
			vbox, _(" Custom print command "), prefs.printcmd,
			table, 0, 1, 0, 1, 1, 2, 0, 1);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "print_command");

	/* tmp dir */
	tmp = misc_entry_w_label_create(
			vbox, _(" Temp directory "), prefs.tmpdir,
			table, 0, 1, 1, 2, 1, 2, 1, 2);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "tmp_directory");
#ifdef USE_SHELL_INSERT
	/* shell */
	tmp = misc_entry_w_label_create(
			vbox, _(" Shell "), prefs.shell,
			table, 0, 1, 2, 3, 1, 2, 2, 3);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "shell");
#endif	/* USE_SHELL_INSERT */

	/* read buf size */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Read buffer size (bytes) "),
			(float)prefs.read_size, 1.0, 65536.0, 1.0, 1.0, 0,
			"read_buf_size",
			table, 0, 1, 3, 4, 1, 2, 3, 4);

	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 0);

	prefs_frame_msgbox_create(vbox);

	/* stuff into notebook */
	tmp = gtk_label_new(_("Misc"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_misc_create */


#ifdef WANT_MSGBOX
/*
 * PRIVATE: prefs_frame_msgbox_create
 *
 * creates the frame containing the options for the msgbox
 *
 *	msgbox on/off			(check button)
 *	max # msgs			(spin button w/ text entry)
 *	msgbox truncate percentage	(spin button w/ text entry)
 */
static void
prefs_frame_msgbox_create(GtkWidget *parent)
{
	GtkWidget *frame, *vbox, *table;

	prefs_box_in_frame(_("Message Box"), 0, &frame, &vbox, TRUE);

	table = gtk_table_new(1, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	/* use msg box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Use message box"),
			IS_USE_MSGBOX(),
			"use_msgbox",
			NULL, -1, -1, -1, -1);

	/* msgbox max msgs */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Max # of messages "),
			(float)prefs.msgbox_max_msg, 0.0, 1024.0, 1.0, 1.0, 0,
			"msgbox_max_msg",
			table, 0, 1, 0, 1, 1, 2, 0, 1);

	/* msgbox del msgs */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" % msgs to delete "),
			(float)prefs.msgbox_per_del, 0.0, 100.0, 1.0, 1.0, 0,
			"msgbox_per_del",
			table, 0, 1, 1, 2, 1, 2, 1, 2);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, FALSE, FALSE, 0);
} /* prefs_frame_msgbox_create */
#endif  /* #ifdef WANT_MSGBOX */


/*
 * PRIVATE: prefs_pulldown_with_label_create
 *
 * convenience routine for creating combo widget (pulldown widget with text)
 */
static GtkWidget *
prefs_pulldown_with_label_create(
	GtkWidget *parent,
	char *labeltext,
	GList *itemlist,
	char *prefname,
	int pos)
{
	GtkWidget *hbox, *tmp;

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, FALSE, 0);
	tmp = gtk_label_new(labeltext);
	gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, FALSE, 0);

	tmp = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(tmp), itemlist);

	if (pos >= 0)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(tmp)->entry),
				   (char *)g_list_nth_data(itemlist, pos));
	gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(tmp)->entry), 0, -1);
	gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, FALSE, 0);
	prefs_wgtopt_list_add(GTK_WIDGET(GTK_EDITABLE(GTK_COMBO(tmp)->entry)),
			      ComboType, itemlist, prefname);

	return tmp;
} /* prefs_pulldown_with_label_create */


/*
 * PRIVATE: prefs_check_button_with_label_create
 *
 * convenience routine for creating a check button and label, and then packing
 * them into a parent (box).
 */
static GtkWidget *
prefs_check_button_with_label_create(
	GtkWidget *parent,
	char *labeltext,
	long expr,
	char *prefname,
	GtkWidget *table,
	int lft1, int rht1, int top1, int bot1)
{
	GtkWidget *tmp;

	tmp = gtk_check_button_new_with_label(labeltext);
	if (table) {
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft1, rht1, top1, bot1);
	} else {
		gtk_box_pack_start(GTK_BOX(parent), tmp, FALSE, FALSE, 0);
	}
	if (expr)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tmp), TRUE);
	prefs_wgtopt_list_add(tmp, ButtonType, NULL, prefname);

	return tmp;
} /* prefs_check_button_with_label_create */


/*
 * PRIVATE: prefs_spin_button_with_label_create
 *
 * convenience routine for creating a spin button and a label
 *
 * if 'table' is non-null, the label and spin button are placed into the table.
 */
static GtkWidget *
prefs_spin_button_with_label_create(
	GtkWidget *parent,
	char *labeltext,
	float adj_value,
	float adj_lower,
	float adj_upper,
	float adj_step_incr,
	float adj_page_incr,
	float adj_page_size,
	char *prefname,
	GtkWidget *table,
	int lft1, int rht1, int top1, int bot1,
	int lft2, int rht2, int top2, int bot2)
{
	GtkWidget *tmp, *entry, *hbox = NULL;
	GtkObject *adj;

	tmp = gtk_label_new(labeltext);
	adj = gtk_adjustment_new(adj_value, adj_lower, adj_upper,
				 adj_step_incr, adj_page_incr, adj_page_size);
	if (table) {
		gtk_misc_set_alignment(GTK_MISC(tmp), 0, 0.5);
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft1, rht1, top1, bot1);
	} else {
		hbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, FALSE, 0);
	}

	tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
	gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(tmp), TRUE);
	gtk_widget_set_usize(tmp, 65, 0);
	if (table) {
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft2, rht2, top2, bot2);
	} else {
		gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, TRUE, 0);
	}
	entry = GTK_WIDGET(&(GTK_SPIN_BUTTON(tmp)->entry));
	prefs_wgtopt_list_add(GTK_WIDGET(entry), EntryType, NULL, prefname);

	return tmp;
} /* prefs_spin_button_with_label_create */


#ifdef USE_TOOLBARS
/*
 * PRIVATE: prefs_radio_button_with_label_create
 *
 * convenience routine for creating a radio button and a label.
 */
static GtkWidget *
prefs_radio_button_with_label_create(
	GtkWidget *parent,
	GtkWidget *group,
	char *labeltext,
	long expr,
	char *prefname)
{
	GtkWidget *tmp;

	if (group != NULL)
		tmp = gtk_radio_button_new_with_label(gtk_radio_button_group(
				GTK_RADIO_BUTTON(group)), labeltext);
	else
		tmp = gtk_radio_button_new_with_label(NULL, labeltext);
	gtk_box_pack_start(GTK_BOX(parent), tmp, FALSE, FALSE, 0);
	if (expr)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tmp), TRUE);
	prefs_wgtopt_list_add(tmp, ButtonType, NULL, prefname);

	return tmp;

} /* prefs_radio_button_with_label_create */
#endif	/* USE_TOOLBARS */


/*
 * PRIVATE: prefs_box_in_frame
 *
 * convenience routine for creating a box (vbox or hbox) packed inside a frame.
 * NOTE!!  this routine is slightly different from the other convenience
 * routines; this one returns two widgets instead of one: the frame widget,
 * as well as the vbox widget.
 */
static void
prefs_box_in_frame(
	char *frametext,
	int border_width,
	GtkWidget **frame,
	GtkWidget **box,
	bool_t is_vbox
	)
{
	*frame = gtk_frame_new(frametext);
	if (border_width > 0)
		gtk_container_border_width(GTK_CONTAINER(*frame), border_width);
	if (is_vbox)
		*box = gtk_vbox_new(FALSE, 0);
	else
		*box = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(*frame), *box);
} /* prefs_box_in_frame */


/*
 * PRIVATE: prefs_wgtopt_list_init
 *
 * initializes the wgtopt_list by counting how many entries are in the prefs
 * table.
 */
static void
prefs_wgtopt_list_init(void)
{
	int cnt;

	for (cnt = 0; app_prefs[cnt].name; cnt++)
		;
	wgtopt_list = g_new(wgtopt_t, cnt);
} /* prefs_wgtopt_list_init */


/*
 * PRIVATE: prefs_wgtopt_list_add
 *
 * adds a widget and its corresponding information into the wgtopt_list.
 */
static void
prefs_wgtopt_list_add(GtkWidget *wgt, wgttype_t type, void *data,
	char *prefname)
{
	prefs_t *pap;

	for (pap = app_prefs; pap->name; pap++) {
		if (strncmp(prefname, pap->name, strlen(pap->name)) == 0) {
			wgtopt_list[wgtopt_list_cnt].pap = pap;
			wgtopt_list[wgtopt_list_cnt].wgt = wgt;
			wgtopt_list[wgtopt_list_cnt].type = type;
			wgtopt_list[wgtopt_list_cnt].data = data;
			wgtopt_list_cnt++;
			GNPDBG_PREFS(("prefs_wgtopt_list_add: added '%s'\n",
				      prefname));
			break;
		}
	}
} /* prefs_wgtopt_list_add */


/*
 * PRIVATE: prefs_update
 *
 * reads from wgtopt_list and updates in-memory preferences.  invoked just
 * before calling prefs_save() to save the new changes.
 */
static void
prefs_update(void)
{
	GSList *dp;
	wgtopt_t *wdata;
	char buf[8], *data;
	int num;
	guint i;

	for (i = 0; i < wgtopt_list_cnt; i++) {
		wdata = &wgtopt_list[i];

		GNPDBG_PREFS(("prefs_update: updating '%s'\n",
			       wdata->pap->name));
		switch (wdata->pap->type) {
		case PrefBool:
			if (GTK_TOGGLE_BUTTON(GTK_BUTTON(wdata->wgt))->active)
				prefs_bool_set(wdata->pap, "true");
			else
				prefs_bool_set(wdata->pap, "false");
			break;
		case PrefString:
			if (wdata->type != GenericType)
				prefs_string_set(wdata->pap,
						 gtk_entry_get_text(
						 	GTK_ENTRY(wdata->wgt)));
			break;
		case PrefInt:
			/*
			 * ugh this is awful.  if the preference variable
			 * stores an integer, we have to allow at least a
			 * couple of ways to represent it in the prefs window.
			 * the obvious way is the text entry method, where we
			 * can simply use atoi() on the text entry.  however,
			 * in the case of document tab positioning, the value
			 * is an integer, but we want to present it as text to
			 * the user (e.g., "Left", "Right", "Top", "Bottom").
			 * to do this, we need some special case code to handle
			 * it.  i will probably rethink this in the future to
			 * see if there's a better way to do this.
			 */
			data = gtk_entry_get_text(GTK_ENTRY(wdata->wgt));

			if (wdata->type == EntryType) {
				prefs_int_set(wdata->pap, data);
			} else if (wdata->type == ComboType) {
				dp = (GSList *)(wdata->data);
				num = 0;
				while (dp) {
					if (strcmp((char *)(dp->data),
						   data) == 0) {
						g_snprintf(buf, 8, "%d", num);
						prefs_int_set(wdata->pap, buf);
						break;
					}
					num++;
					dp = dp->next;
				}
			}

			break;
		case PrefByte:
			prefs_byte_set(wdata->pap,
				gtk_entry_get_text(GTK_ENTRY(wdata->wgt)));
			break;
		case PrefFloat:
			prefs_float_set(wdata->pap,
				gtk_entry_get_text(GTK_ENTRY(wdata->wgt)));
			break;
		default:
			printf("prefs_update: ignoring '%s' (unknown type=%d)"
			       "\n", wdata->pap->name, wdata->pap->type);
			break;
		} /* switch */

		if (wdata->pap->f) {
			GNPDBG_PREFS(("prefs_update: invoking callback for "
				      "'%s'\n", wdata->pap->name));
			(wdata->pap->f)(wdata->pap->c);
		}
	} /* while wolp */
} /* prefs_update */


/*
 * PRIVATE: prefs_wgtopt_list_free
 *
 * cleans up and frees the wgtopt_list
 */
static void
prefs_wgtopt_list_free(void)
{
	int i;

	for (i = 0; i < wgtopt_list_cnt; i++) {
		if (wgtopt_list[i].type == ComboType)
			g_list_free((GList *)wgtopt_list[i].data);
	}

	g_free(wgtopt_list);
	wgtopt_list = NULL;
	wgtopt_list_cnt = 0;
} /* prefs_wgtopt_list_free */


/*
 * PRIVATE: prefs_save_cb
 *
 * callback invoked when user clicks on "Ok" button
 */
static void
prefs_save_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	gtk_widget_hide(prefs_win);
	prefs_update();
	prefs_save();
	prefs_wgtopt_list_free();
	gtk_widget_destroy(prefs_win);
	appgtk_rc_update(appgtkrc);
	msgbox_printf(_("Preferences saved..."));
	msgbar_printf(w, _("Preferences saved..."));
} /* prefs_save_cb */


/*
 * PRIVATE: prefs_win_cancel
 *
 * callback for 'Cancel' button
 */
static void
prefs_win_cancel(GtkWidget *wgt, gpointer cbdata)
{
	gtk_widget_hide(prefs_win);
} /* prefs_win_cancel */


/*
 * PRIVATE: prefs_win_destroy
 *
 * destroys the prefs window and cleans up the wgtopt_list
 */
static void
prefs_win_destroy(GtkWidget *wgt, gpointer cbdata)
{
	prefs_wgtopt_list_free();
	prefs_win = NULL;
} /* prefs_win_destroy */


/*
 * PRIVATE: prefs_tab_pos_change
 *
 * for all windows, redraw the document tabs.  called from prefs_save, when the
 * preferences may have changed.
 */
static void
prefs_tab_pos_change(GtkWidget *wgt, gpointer cbdata)
{
	GtkWidget *prefs_nb = (GtkWidget *)cbdata;

	switch (prefs_tabpos) {
	case GTK_POS_LEFT:
		prefs_tabpos = GTK_POS_TOP;
		break;
	case GTK_POS_RIGHT:
		prefs_tabpos = GTK_POS_BOTTOM;
		break;
	case GTK_POS_TOP:
		prefs_tabpos = GTK_POS_RIGHT;
		break;
	case GTK_POS_BOTTOM:
		prefs_tabpos = GTK_POS_LEFT;
		break;
	}
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(prefs_nb), prefs_tabpos);
} /* prefs_tab_pos_change */


/* the end */
