/* vi:set ts=8 sts=0 sw=8:
 * $Id: search.h,v 1.8 1999/09/12 14:20:57 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __SEARCH_H__
#define __SEARCH_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "main.h"
#ifdef USE_SEARCH
#include <gtk/gtk.h>

typedef enum { NoSearch = 0, Find, Again, Replace, GotoLine } srg_action_t;

typedef struct {
	srg_action_t	action;
	GtkWidget *	toplev;		/* top level dialog widget */
	GtkWidget *	find;		/* "Find" or "Goto Line" button */
	GtkWidget *	stxt_wgt;	/* search text entry widget */
	GtkWidget *	startcur;	/* start at cur pos radio button */
	GtkWidget *	startbeg;	/* start at doc beginning radio btn */
	GtkWidget *	casesens;	/* case-sensitive toggle button */
#ifdef USE_REGEX
	GtkWidget *	regexp;		/* regular expression toggle button */
#endif
	GtkWidget *	repl;		/* "Replace" button */
	GtkWidget *	replall;	/* "Replace all" button */
	GtkWidget *	rtxt_wgt;	/* replace text entry widget */

	/* results from search/replace */
	char *          stxt;		/* search text for 'search again' */
	char *          rtxt;		/* replace text */
	bool_t		found;		/* search found the text */
} search_t;

extern void search_cb(GtkWidget *wgt, gpointer cbdata, guint cbaction);
extern void search_again_cb(GtkWidget *wgt, gpointer cbdata);
extern void search_replace_cb(GtkWidget *wgt, gpointer cbdata);
#if !defined(GTK_HAVE_FEATURES_1_1_0) || defined(USE_GNOME)
extern void search_search_cb(GtkWidget *wgt, gpointer cbdata);
extern void goto_line_cb(GtkWidget *wgt, gpointer cbdata);
#endif	/* gtk+-1.0.x */

#endif	/* USE_SEARCH */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SEARCH_H__ */
