;;; -*- coding: iso-2022-7bit  -*-
;;; uiso8859-4.el --- tables between UCS and ISO-8859-4

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from 8859-4.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'latin-iso8859-4 'unicode 'iso-8859-4-vs-unicode-assoc)

(defvar
  iso-8859-4-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,D (B . ?\x00A0) ;; NO-BREAK SPACE
     (?,D!(B . ?\x0104) ;; LATIN CAPITAL LETTER A WITH OGONEK
     (?,D"(B . ?\x0138) ;; LATIN SMALL LETTER KRA
     (?,D#(B . ?\x0156) ;; LATIN CAPITAL LETTER R WITH CEDILLA
     (?,D$(B . ?\x00A4) ;; CURRENCY SIGN
     (?,D%(B . ?\x0128) ;; LATIN CAPITAL LETTER I WITH TILDE
     (?,D&(B . ?\x013B) ;; LATIN CAPITAL LETTER L WITH CEDILLA
     (?,D'(B . ?\x00A7) ;; SECTION SIGN
     (?,D((B . ?\x00A8) ;; DIAERESIS
     (?,D)(B . ?\x0160) ;; LATIN CAPITAL LETTER S WITH CARON
     (?,D*(B . ?\x0112) ;; LATIN CAPITAL LETTER E WITH MACRON
     (?,D+(B . ?\x0122) ;; LATIN CAPITAL LETTER G WITH CEDILLA
     (?,D,(B . ?\x0166) ;; LATIN CAPITAL LETTER T WITH STROKE
     (?,D-(B . ?\x00AD) ;; SOFT HYPHEN
     (?,D.(B . ?\x017D) ;; LATIN CAPITAL LETTER Z WITH CARON
     (?,D/(B . ?\x00AF) ;; MACRON
     (?,D0(B . ?\x00B0) ;; DEGREE SIGN
     (?,D1(B . ?\x0105) ;; LATIN SMALL LETTER A WITH OGONEK
     (?,D2(B . ?\x02DB) ;; OGONEK
     (?,D3(B . ?\x0157) ;; LATIN SMALL LETTER R WITH CEDILLA
     (?,D4(B . ?\x00B4) ;; ACUTE ACCENT
     (?,D5(B . ?\x0129) ;; LATIN SMALL LETTER I WITH TILDE
     (?,D6(B . ?\x013C) ;; LATIN SMALL LETTER L WITH CEDILLA
     (?,D7(B . ?\x02C7) ;; CARON
     (?,D8(B . ?\x00B8) ;; CEDILLA
     (?,D9(B . ?\x0161) ;; LATIN SMALL LETTER S WITH CARON
     (?,D:(B . ?\x0113) ;; LATIN SMALL LETTER E WITH MACRON
     (?,D;(B . ?\x0123) ;; LATIN SMALL LETTER G WITH CEDILLA
     (?,D<(B . ?\x0167) ;; LATIN SMALL LETTER T WITH STROKE
     (?,D=(B . ?\x014A) ;; LATIN CAPITAL LETTER ENG
     (?,D>(B . ?\x017E) ;; LATIN SMALL LETTER Z WITH CARON
     (?,D?(B . ?\x014B) ;; LATIN SMALL LETTER ENG
     (?,D@(B . ?\x0100) ;; LATIN CAPITAL LETTER A WITH MACRON
     (?,DA(B . ?\x00C1) ;; LATIN CAPITAL LETTER A WITH ACUTE
     (?,DB(B . ?\x00C2) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
     (?,DC(B . ?\x00C3) ;; LATIN CAPITAL LETTER A WITH TILDE
     (?,DD(B . ?\x00C4) ;; LATIN CAPITAL LETTER A WITH DIAERESIS
     (?,DE(B . ?\x00C5) ;; LATIN CAPITAL LETTER A WITH RING ABOVE
     (?,DF(B . ?\x00C6) ;; LATIN CAPITAL LETTER AE
     (?,DG(B . ?\x012E) ;; LATIN CAPITAL LETTER I WITH OGONEK
     (?,DH(B . ?\x010C) ;; LATIN CAPITAL LETTER C WITH CARON
     (?,DI(B . ?\x00C9) ;; LATIN CAPITAL LETTER E WITH ACUTE
     (?,DJ(B . ?\x0118) ;; LATIN CAPITAL LETTER E WITH OGONEK
     (?,DK(B . ?\x00CB) ;; LATIN CAPITAL LETTER E WITH DIAERESIS
     (?,DL(B . ?\x0116) ;; LATIN CAPITAL LETTER E WITH DOT ABOVE
     (?,DM(B . ?\x00CD) ;; LATIN CAPITAL LETTER I WITH ACUTE
     (?,DN(B . ?\x00CE) ;; LATIN CAPITAL LETTER I WITH CIRCUMFLEX
     (?,DO(B . ?\x012A) ;; LATIN CAPITAL LETTER I WITH MACRON
     (?,DP(B . ?\x0110) ;; LATIN CAPITAL LETTER D WITH STROKE
     (?,DQ(B . ?\x0145) ;; LATIN CAPITAL LETTER N WITH CEDILLA
     (?,DR(B . ?\x014C) ;; LATIN CAPITAL LETTER O WITH MACRON
     (?,DS(B . ?\x0136) ;; LATIN CAPITAL LETTER K WITH CEDILLA
     (?,DT(B . ?\x00D4) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
     (?,DU(B . ?\x00D5) ;; LATIN CAPITAL LETTER O WITH TILDE
     (?,DV(B . ?\x00D6) ;; LATIN CAPITAL LETTER O WITH DIAERESIS
     (?,DW(B . ?\x00D7) ;; MULTIPLICATION SIGN
     (?,DX(B . ?\x00D8) ;; LATIN CAPITAL LETTER O WITH STROKE
     (?,DY(B . ?\x0172) ;; LATIN CAPITAL LETTER U WITH OGONEK
     (?,DZ(B . ?\x00DA) ;; LATIN CAPITAL LETTER U WITH ACUTE
     (?,D[(B . ?\x00DB) ;; LATIN CAPITAL LETTER U WITH CIRCUMFLEX
     (?,D\(B . ?\x00DC) ;; LATIN CAPITAL LETTER U WITH DIAERESIS
     (?,D](B . ?\x0168) ;; LATIN CAPITAL LETTER U WITH TILDE
     (?,D^(B . ?\x016A) ;; LATIN CAPITAL LETTER U WITH MACRON
     (?,D_(B . ?\x00DF) ;; LATIN SMALL LETTER SHARP S
     (?,D`(B . ?\x0101) ;; LATIN SMALL LETTER A WITH MACRON
     (?,Da(B . ?\x00E1) ;; LATIN SMALL LETTER A WITH ACUTE
     (?,Db(B . ?\x00E2) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX
     (?,Dc(B . ?\x00E3) ;; LATIN SMALL LETTER A WITH TILDE
     (?,Dd(B . ?\x00E4) ;; LATIN SMALL LETTER A WITH DIAERESIS
     (?,De(B . ?\x00E5) ;; LATIN SMALL LETTER A WITH RING ABOVE
     (?,Df(B . ?\x00E6) ;; LATIN SMALL LETTER AE
     (?,Dg(B . ?\x012F) ;; LATIN SMALL LETTER I WITH OGONEK
     (?,Dh(B . ?\x010D) ;; LATIN SMALL LETTER C WITH CARON
     (?,Di(B . ?\x00E9) ;; LATIN SMALL LETTER E WITH ACUTE
     (?,Dj(B . ?\x0119) ;; LATIN SMALL LETTER E WITH OGONEK
     (?,Dk(B . ?\x00EB) ;; LATIN SMALL LETTER E WITH DIAERESIS
     (?,Dl(B . ?\x0117) ;; LATIN SMALL LETTER E WITH DOT ABOVE
     (?,Dm(B . ?\x00ED) ;; LATIN SMALL LETTER I WITH ACUTE
     (?,Dn(B . ?\x00EE) ;; LATIN SMALL LETTER I WITH CIRCUMFLEX
     (?,Do(B . ?\x012B) ;; LATIN SMALL LETTER I WITH MACRON
     (?,Dp(B . ?\x0111) ;; LATIN SMALL LETTER D WITH STROKE
     (?,Dq(B . ?\x0146) ;; LATIN SMALL LETTER N WITH CEDILLA
     (?,Dr(B . ?\x014D) ;; LATIN SMALL LETTER O WITH MACRON
     (?,Ds(B . ?\x0137) ;; LATIN SMALL LETTER K WITH CEDILLA
     (?,Dt(B . ?\x00F4) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX
     (?,Du(B . ?\x00F5) ;; LATIN SMALL LETTER O WITH TILDE
     (?,Dv(B . ?\x00F6) ;; LATIN SMALL LETTER O WITH DIAERESIS
     (?,Dw(B . ?\x00F7) ;; DIVISION SIGN
     (?,Dx(B . ?\x00F8) ;; LATIN SMALL LETTER O WITH STROKE
     (?,Dy(B . ?\x0173) ;; LATIN SMALL LETTER U WITH OGONEK
     (?,Dz(B . ?\x00FA) ;; LATIN SMALL LETTER U WITH ACUTE
     (?,D{(B . ?\x00FB) ;; LATIN SMALL LETTER U WITH CIRCUMFLEX
     (?,D|(B . ?\x00FC) ;; LATIN SMALL LETTER U WITH DIAERESIS
     (?,D}(B . ?\x0169) ;; LATIN SMALL LETTER U WITH TILDE
     (?,D~(B . ?\x016B) ;; LATIN SMALL LETTER U WITH MACRON
     (?,D(B . ?\x02D9) ;; DOT ABOVE
     )))

(provide 'uiso8859-4)
 