/************************************************************************/
/*									*/
/*  Read an RTF text file into a BufferDocument				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<debugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Consume a field.							*/
/*									*/
/************************************************************************/

static int docRtfReadFldrslt(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int			res;
    int			savedInField= rrc->rrcCurrentTextAttribute.taInField;

    rrc->rrcCurrentTextAttribute.taInField= 1;

    res= docRtfReadGroup( sis, DOClevPARA,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfDocumentWords, docRtfDocumentGroups,
				docRtfTextParticule );

    rrc->rrcCurrentTextAttribute.taInField= savedInField;

    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    return res;
    }

static int docRtfFldinst(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			size	)
    {
    DocumentField *		df;

    const char *		fileName= (char *)0;
    int				fileSize;
    const char *		markName= (char *)0;
    int				markSize;

    df= rrc->rrcBi->biParaFieldList.dflFields+ rrc->rrcFieldNumber;

    if  ( docSetFieldInst( df, text, size ) )
	{ LDEB(size); return -1;	}

    if  ( ! docGetHyperlink( df, &fileName, &fileSize, &markName, &markSize ) )
	{ df->dfKind= DOCfkHYPERLINK;	}
    else{
	if  ( ! docGetPagefield( df ) )
	    { df->dfKind= DOCfkPAGEFIELD;	}
	}

    return 0;
    }

static int docRtfReadFldinst(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int		res;

    res= docRtfReadGroup( sis, DOClevPARA,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfDocumentWords, docRtfDocumentGroups,
				docRtfFldinst );

    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    return res;
    }

static RtfControlWord	docRtfFieldGroups[]=
    {
	{ "fldrslt",	RTFidFLDRSLT,	DOClevPARA, docRtfReadFldrslt, },
	{ "fldinst",	RTFidFLDINST,	DOClevPARA, docRtfReadFldinst, },

	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfFieldWords[]=
    {
	{ "flddirty",	RTFidFLDDIRTY,	DOClevPARA, docRtfIgnoreWord, },
	{ "fldedit",	RTFidFLDEDIT,	DOClevPARA, docRtfIgnoreWord, },
	{ "fldlock",	RTFidFLDLOCK,	DOClevPARA, docRtfIgnoreWord, },
	{ "fldpriv",	RTFidFLDPRIV,	DOClevPARA, docRtfIgnoreWord, },

	{ 0, 0, 0 }
    };

static int docRtfFieldParticule(	int *			pPart,
					BufferItem *		bi,
					int			particuleKind,
					int			fieldKind,
					RtfReadingContext *	rrc	)
    {
    DocumentField *	df;
    TextParticule *	tp;

    int			part= bi->biParaParticuleCount;

    df= docClaimField( &(rrc->rrcFieldNumber), &(bi->biParaFieldList) );
    if  ( ! df )
	{ XDEB(df); return -1;	}

    tp= docInsertTextParticule( bi, -1, bi->biParaStrlen, 0,
			particuleKind, rrc->rrcCurrentTextAttribute );
    if  ( ! tp )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    tp->tpObjectNumber= rrc->rrcFieldNumber;
    df->dfKind= fieldKind;

    *pPart= part; return 0;
    }

static int docRtfFinishField(	BufferItem *		bi,
				int			startParticule,
				RtfReadingContext *	rrc	)
    {
    TextParticule *	tp;

    tp= bi->biParaParticules+ startParticule;
    if  ( startParticule < bi->biParaParticuleCount- 1	&&
	  tp[1].tpTextAttribute.taInField		)
	{
	tp[0].tpTextAttribute= tp[1].tpTextAttribute;
	tp[0].tpTextAttribute.taInField= 0;
	}

    if  ( rrc->rrcBi != bi )
	{ XXDEB(rrc->rrcBi,bi); }

    tp= docInsertTextParticule( bi, -1, bi->biParaStrlen, 0,
			DOCkindFIELDEND, rrc->rrcCurrentTextAttribute );
    if  ( ! tp )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    return 0;
    }

int docRtfReadField(	SimpleInputStream *	sis,
			const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc	)
    {
    int			res;
    BufferItem *	bi= rrc->rrcBi;

    int			startParticule;

    if  ( docRtfFieldParticule( &startParticule, bi,
				    DOCkindFIELDSTART, DOCfkUNKNOWN, rrc ) )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    res= docRtfReadGroup( sis, DOClevPARA,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfFieldWords, docRtfFieldGroups,
				docRtfIgnoreText );
    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    if  ( docRtfFinishField( bi, startParticule, rrc ) )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    return res;
    }

static RtfControlWord	docRtfXE_Words[]=
    {
	{ "xef",	RTFidXEF,	DOClevPARA, docRtfIgnoreWord, },
	{ "bxe",	RTFidBXE,	DOClevPARA, docRtfIgnoreWord, },
	{ "ixe",	RTFidIXE,	DOClevPARA, docRtfIgnoreWord, },

	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfTC_Words[]=
    {
	{ "tcf",	RTFidTCF,	DOClevPARA, docRtfIgnoreWord, },
	{ "tcl",	RTFidTCL,	DOClevPARA, docRtfIgnoreWord, },

	{ 0, 0, 0 }
    };

int docRtfReadLookupEntry(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int			res;
    BufferItem *	bi= rrc->rrcBi;

    int			particuleKind;
    int			fieldKind;

    int			startParticule;

    RtfControlWord *	firstApply= (RtfControlWord *)0;
    RtfControlWord *	contolWords= (RtfControlWord *)0;
    RtfControlWord *	groupWords= (RtfControlWord *)0;

    switch( rcw->rcwId )
	{
	case RTFidXE:
	    particuleKind= DOCkindXE;
	    fieldKind= DOCfkINDEX_ENTRY;
	    contolWords= docRtfXE_Words;
	    break;
	case RTFidTC:
	case RTFidTCN:
	    particuleKind= DOCkindTC;
	    fieldKind= DOCfkCONTENTS_ENTRY;
	    contolWords= docRtfTC_Words;
	    break;
	default:
	    SDEB(rcw->rcwWord); return -1;
	}

    if  ( docRtfFieldParticule( &startParticule, bi,
					    particuleKind, fieldKind, rrc ) )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    res= docRtfReadGroup( sis, DOClevPARA,
				firstApply, 0, 0, rrc,
				contolWords, groupWords,
				docRtfFldinst );

    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    return res;
    }

/************************************************************************/
/*									*/
/*  Process bookmarks.							*/
/*									*/
/************************************************************************/

static int docRtfBookmarkName(	RtfReadingContext *	rrc,
				const unsigned char *	name,
				int			len	)
    {
    DocumentField *		df;

    df= rrc->rrcBi->biParaFieldList.dflFields+ rrc->rrcFieldNumber;

    if  ( docSetFieldInst( df, (unsigned char *)name, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

int docRtfGetBookmark(	SimpleInputStream *	sis,
			const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc	)
    {
    int			res;
    BufferDocument *	bd= rrc->rrcBd;
    BufferItem *	bi= rrc->rrcBi;
    DocumentField *	df;
    DocumentField *	dfDoc= (DocumentField *)0;
    int			fieldKind;
    int			particuleKind;

    int			documentFieldNumber= -1;
    int			startParticule;

    switch( rcw->rcwId )
	{
	case RTFidBKMKSTART:
	    particuleKind= DOCkindBKMKSTART;
	    fieldKind= DOCfkBKMKSTART;

	    dfDoc= docClaimField( &documentFieldNumber, &(bd->bdBookmarks) );
	    if  ( ! dfDoc )
		{ XDEB(dfDoc); return -1;	}
	    dfDoc->dfKind= DOCfkBKMKSTART;

	    break;
	case RTFidBKMKEND:
	    particuleKind= DOCkindBKMKEND;
	    fieldKind= DOCfkBKMKEND;
	    break;
	default:
	    SDEB(rcw->rcwWord); return -1;
	}

    if  ( docRtfFieldParticule( &startParticule, bi,
					    particuleKind, fieldKind, rrc ) )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    df= bi->biParaFieldList.dflFields+ rrc->rrcFieldNumber;
    df->dfNumberInDocument= documentFieldNumber;

    res= docRtfReadGroup( sis, DOClevPARA,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfEmptyTable, docRtfEmptyTable,
				docRtfBookmarkName );

    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    if  ( rcw->rcwId == RTFidBKMKSTART )
	{
	if  ( docCopyObjectData( &(dfDoc->dfInstructions),
						    &(df->dfInstructions) ) )
	    { LDEB(1); return -1;	}
	}

    return res;
    }
