/************************************************************************/
/*									*/
/*  Rulers, Ted specific functionality.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<Xm/ToggleB.h>

#   include	"tedApp.h"
#   include	"tedRuler.h"

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Allow a user to change paragraph attributes with the top ruler.	*/
/*									*/
/************************************************************************/
static void tedDragVerticalHair(		void *		voided,
						int		from,
						int		to )
    {
    EditDocument *		ed= (EditDocument *)voided;
    Widget			w= ed->edDocumentWidget;
    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );
    GC				gc= ed->edGc;
    int				ox= ed->edVisibleRect.drX0;

    int				high;

    high= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;

    if  ( from >= 0 )
	{ XClearArea( display, win, from- ox, 0, 1, high, True ); }

    if  ( to >= 0 )
	{ XFillRectangle( display, win, gc, to- ox, 0, 1, high ); }

    return;
    }

/************************************************************************/
/*									*/
/*  Administratively effectuate a user change to the top ruler.		*/
/*									*/
/************************************************************************/

int tedUpdateParaProperties( unsigned int *		pChangedMask,
			    const AppDrawingData *	add,
			    BufferItem *		bi,
			    unsigned int		ppUpdMask,
			    const ParagraphProperties *	newPP )
    {
    unsigned int		changedMask= 0;

    ParagraphProperties *	pp= &(bi->biParaProperties);

    if  ( ppUpdMask & PPupdFIRST_INDENT )
	{
	if  ( pp->ppFirstIndentTwips != newPP->ppFirstIndentTwips )
	    {
	    pp->ppFirstIndentTwips= newPP->ppFirstIndentTwips;
	    changedMask |= PPupdFIRST_INDENT;
	    }
	}

    if  ( ppUpdMask & PPupdLEFT_INDENT )
	{
	if  ( pp->ppLeftIndentTwips != newPP->ppLeftIndentTwips )
	    {
	    pp->ppLeftIndentTwips= newPP->ppLeftIndentTwips;
	    changedMask |= PPupdLEFT_INDENT;
	    }
	}

    if  ( ppUpdMask & PPupdRIGHT_INDENT )
	{
	if  ( pp->ppRightIndentTwips != newPP->ppRightIndentTwips )
	    {
	    pp->ppRightIndentTwips= newPP->ppRightIndentTwips;
	    changedMask |= PPupdRIGHT_INDENT;
	    }
	}

    if  ( ppUpdMask & PPupdTAB_STOPS )
	{
	if  ( pp->ppTabCount > 0 || newPP->ppTabCount > 0 )
	    {
	    if  ( pp->ppTabCount != newPP->ppTabCount )
		{ changedMask |= PPupdTAB_STOPS;	}

	    if  ( newPP->ppTabCount == 0 )
		{ pp->ppTabCount= 0;	}
	    else{
		TabStop *			ts;
		TabStop *			ots= pp->ppTabStops;
		TabStop *			nts= newPP->ppTabStops;
		int				tab;

		ts= (TabStop *)malloc( newPP->ppTabCount* sizeof(TabStop) );
		if  ( ! ts )
		    { LXDEB(newPP->ppTabCount,ts); return -1;	}

		for ( tab= 0; tab < newPP->ppTabCount; tab++ )
		    {
		    if  ( pp->ppTabCount == newPP->ppTabCount )
			{
			if  ( nts[tab].tsTwips != ots[tab].tsTwips	||
			      nts[tab].tsKind != ots[tab].tsKind	||
			      nts[tab].tsLeader != ots[tab].tsLeader	)
			    {
			    changedMask |= PPupdTAB_STOPS;
			    ts[tab]= nts[tab];
			    }
			else{ ts[tab]= ots[tab];	}
			}
		    else{ ts[tab]= nts[tab];		}
		    }

		pp->ppTabCount= newPP->ppTabCount;
		if  ( pp->ppTabStops )
		    { free( pp->ppTabStops );	}

		pp->ppTabStops= ts;
		}
	    }
	}

    if  ( ppUpdMask & PPupdALIGNMENT )
	{
	if  ( pp->ppAlignment != newPP->ppAlignment )
	    {
	    pp->ppAlignment= newPP->ppAlignment;
	    changedMask |= PPupdALIGNMENT;
	    }
	}

    if  ( ppUpdMask & PPupdSPACE_BEFORE )
	{
	if  ( pp->ppSpaceBeforeTwips != newPP->ppSpaceBeforeTwips )
	    {
	    pp->ppSpaceBeforeTwips= newPP->ppSpaceBeforeTwips;
	    changedMask |= PPupdSPACE_BEFORE;
	    }
	}

    if  ( ppUpdMask & PPupdSPACE_AFTER )
	{
	if  ( pp->ppSpaceAfterTwips != newPP->ppSpaceAfterTwips )
	    {
	    pp->ppSpaceAfterTwips= newPP->ppSpaceAfterTwips;
	    changedMask |= PPupdSPACE_AFTER;
	    }
	}

    if  ( ppUpdMask & PPupdNEWPAGE )
	{
	if  ( pp->ppStartsOnNewPage != newPP->ppStartsOnNewPage )
	    {
	    pp->ppStartsOnNewPage= newPP->ppStartsOnNewPage;
	    changedMask |= PPupdNEWPAGE;
	    }
	}

    if  ( ppUpdMask & PPupdLINE_SPACING )
	{
	if  ( pp->ppLineSpacingTwips != newPP->ppLineSpacingTwips )
	    {
	    pp->ppLineSpacingTwips= newPP->ppLineSpacingTwips;
	    changedMask |= PPupdLINE_SPACING;
	    }
	if  ( pp->ppLineSpacingIsMultiple != newPP->ppLineSpacingIsMultiple )
	    {
	    pp->ppLineSpacingIsMultiple= newPP->ppLineSpacingIsMultiple;
	    changedMask |= PPupdLINE_SPACING;
	    }
	}

    if  ( ppUpdMask & PPupdTOP_BORDER )
	{
	if  ( ! docEqualBorder( &(pp->ppTopBorder),
						&(newPP->ppTopBorder ) ) )
	    {
	    docCopyBorderProperties( &(pp->ppTopBorder),
						&(newPP->ppTopBorder) );
	    changedMask |= PPupdTOP_BORDER;
	    }
	}

    if  ( ppUpdMask & PPupdBOTTOM_BORDER )
	{
	if  ( ! docEqualBorder( &(pp->ppBottomBorder),
						&(newPP->ppBottomBorder ) ) )
	    {
	    docCopyBorderProperties( &(pp->ppBottomBorder),
						&(newPP->ppBottomBorder) );
	    changedMask |= PPupdBOTTOM_BORDER;
	    }
	}

    if  ( changedMask )
	{
	FormattingFrame		ff;

	tedParagraphFrame( &ff, add, -1, bi );

	tedParaScreenGeometry( bi, &ff, add->addMagnifiedPixelsPerTwip );
	}

    *pChangedMask= changedMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Obtain the separator positions for a table.				*/
/*									*/
/************************************************************************/
static int tedGetColumns(	BufferItem *		bi,
				const AppDrawingData *	add,
				ColumnSeparator **	pCs,
				int *			pCsCount )
    {
    static ColumnSeparator *	cs;
    ColumnSeparator *		fresh;

    BufferItem *		rowBi;
    CellProperties *		cp;

    int				i;

    rowBi= bi->biParent->biParent;

    fresh= (ColumnSeparator *)realloc( cs, ( rowBi->biRowCellCount+ 1 )*
					sizeof( ColumnSeparator ) );
    if  ( ! fresh )
	{ LXDEB(rowBi->biRowCellCount,fresh); return -1;	}
    cs= fresh;

    fresh->csX0= rowBi->biRowLeftIndentPixels-
				    rowBi->biRowHalfGapWidthPixels;
    fresh->csX1= rowBi->biRowLeftIndentPixels+
				    rowBi->biRowHalfGapWidthPixels;
    fresh->csX0 += add->addDocRect.drX0;
    fresh->csX1 += add->addDocRect.drX0;

    fresh++; cp= rowBi->biRowCells;
    for ( i= 0; i < rowBi->biRowCellCount; fresh++, cp++, i++ )
	{
	fresh->csX0= cp->cpRightBoundaryPixels-
				    rowBi->biRowHalfGapWidthPixels;
	fresh->csX1= cp->cpRightBoundaryPixels+
				    rowBi->biRowHalfGapWidthPixels;

	fresh->csX0 += add->addDocRect.drX0;
	fresh->csX1 += add->addDocRect.drX0;
	}

    *pCs= cs; *pCsCount= rowBi->biRowCellCount+ 1; return 0;
    }

static void tedUpdateTableColumns(	EditDocument *		ed,
					BufferItem *		bi,
					double			xfac,
					double			magnification,
					int			csCountNew,
					ColumnSeparator *	csNew )
    {
    AppDrawingData *	add= &(ed->edDrawingData);

    int			csCount;
    ColumnSeparator *	cs;
    int			changed= 0;

    BufferItem *	sectBi;
    BufferItem *	rowBi;

    RowProperties *	rp;
    CellProperties *	cp;

    int			col;
    int			row;
    int			row0;
    int			row1;

    int			i;

    int			y0;
    int			y;
    int			oldY1;

    if  ( tedGetColumns( bi, add, &cs, &csCount ) )
	{ LDEB(1); return;	}

    if  ( csCountNew != csCount )
	{ LLDEB(csCountNew,csCount); return;	}

    if  ( docDelimitTable( bi, &sectBi, &col, &row0, &row, &row1 ) )
	{ LDEB(1); return;	}

    rowBi= sectBi->biGroupChildren[row0];
    rp= &(rowBi->biRowProperties);

    y= y0= rowBi->biY0;
    oldY1= sectBi->biGroupChildren[row1]->biY1;

    if  ( csNew[0].csX0 != cs[0].csX0 )
	{
	rp->rpLeftIndentPixels += ( csNew[0].csX0- cs[0].csX0 );
	rp->rpLeftIndentTwips= PIXELStoTWIPS( rp->rpLeftIndentPixels, xfac );
	changed= 1;
	}

    cp= rp->rpCells;
    for ( i= 1; i < csCount; cp++, i++ )
	{
	if  ( csNew[i].csX0 != cs[i].csX0 )
	    {
	    cp->cpRightBoundaryPixels += ( csNew[i].csX0- cs[i].csX0 );
	    cp->cpRightBoundaryTwips=
			    PIXELStoTWIPS( cp->cpRightBoundaryPixels, xfac );
	    changed= 1;
	    }
	}

    if  ( changed )
	{
	int		rowHeightAlso= 0;

	tedChangeTableLayout( ed, bi, sectBi, rp, rowHeightAlso, row0, row1 );

	if  ( TED_FormatTool )
	    { tedAdaptFormatToolToDocument( TED_FormatTool, ed );	}
	}

    return;
    }

/************************************************************************/
/*									*/
/*  The user wants something with the mouse on the horizontal ruler	*/
/*									*/
/************************************************************************/

static int tedGetRulerTwips(	const AppDrawingData *	add,
				const BufferItem *	bi,
				ParagraphProperties *	pp,
				int			firstIndentPixels,
				int			leftIndentPixels,
				int			rightIndentPixels,
				int			tabCount,
				const TabStop *		tabStops )
    {
    FormattingFrame		ff;
    double			xfac= add->addMagnifiedPixelsPerTwip;

    int				otab;
    int				ntab;
    int				tab0;
    int				otab1;
    int				ntab1;

    int				pixels;
    int				twips;

    tedParagraphFrame( &ff, add, -1, bi );

    leftIndentPixels -= ff.ffX0Geometry;
    pp->ppLeftIndentTwips= PIXELStoTWIPS( leftIndentPixels, xfac );

    firstIndentPixels -= ff.ffX0Geometry;
    firstIndentPixels -= leftIndentPixels;
    pp->ppFirstIndentTwips= PIXELStoTWIPS( firstIndentPixels, xfac );

    rightIndentPixels= ff.ffX1Geometry- rightIndentPixels;
    pp->ppRightIndentTwips= PIXELStoTWIPS( rightIndentPixels, xfac );

    if  ( tabCount > pp->ppTabCount )
	{
	TabStop *	fresh;

	fresh= (TabStop *)realloc( pp->ppTabStops, tabCount* sizeof(TabStop) );
	if  ( ! fresh )
	    { LXDEB(tabCount,fresh); return -1;	}

	pp->ppTabStops= fresh;
	}

    tab0= 0;
    while( tab0 < pp->ppTabCount && tab0 < tabCount )
	{
	twips= pp->ppTabStops[tab0].tsTwips;
	pixels= ff.ffX0Geometry+ TWIPStoPIXELS( xfac, twips );

	if  ( pixels != tabStops[tab0].tsPixels )
	    { break;	}

	pp->ppTabStops[tab0]= tabStops[tab0];
	pp->ppTabStops[tab0].tsTwips= twips;

	tab0++;
	}

    otab1= pp->ppTabCount- 1;
    ntab1= tabCount- 1;
    while( otab1 >= tab0 && ntab1 >= tab0 )
	{
	twips= pp->ppTabStops[otab1].tsTwips;
	pixels= ff.ffX0Geometry+ TWIPStoPIXELS( xfac, twips );

	if  ( pixels != tabStops[ntab1].tsPixels )
	    { break;	}

	/*  No.. Later on
	pp->ppTabStops[otab1]= tabStops[ntab1];
	pp->ppTabStops[otab1].tsTwips= twips;
	*/

	otab1--; ntab1--;
	}

    if  ( pp->ppTabCount < tabCount )
	{
	ntab= tabCount- 1;
	for ( otab= pp->ppTabCount- 1; otab > otab1; ntab--, otab-- )
	    {
	    twips= pp->ppTabStops[otab].tsTwips;

	    pp->ppTabStops[ntab]= tabStops[ntab];
	    pp->ppTabStops[ntab].tsTwips= twips;
	    }
	}
    else{
	ntab= ntab1+ 1;
	for ( otab= otab1+ 1; otab < pp->ppTabCount; ntab++, otab++ )
	    {
	    twips= pp->ppTabStops[otab].tsTwips;

	    pp->ppTabStops[ntab]= tabStops[ntab];
	    pp->ppTabStops[ntab].tsTwips= twips;
	    }
	}

    otab= tab0;
    for ( ntab= tab0; ntab <= ntab1; otab++, ntab++ )
	{
	pixels= tabStops[ntab].tsPixels;
	pixels -= ff.ffX0Geometry;
	twips= pixels/ xfac;

	pp->ppTabStops[otab]= tabStops[ntab];
	pp->ppTabStops[otab].tsTwips= twips;
	}

    pp->ppTabCount= tabCount;

    return 0;
    }

static void tedHorizontalRulerButtonDown(	Widget		w,
						void *		voided,
						XEvent *	event,
						Boolean *	pRefused )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferItem *		bi= td->tdSelection.bsBegin.bpBi;
    AppDrawingData *		add= &(ed->edDrawingData);

    int				leftIndentNew;
    int				firstIndentNew;
    int				rightIndentNew;
    int				tabCountNew= bi->biParaProperties.ppTabCount;
    TabStop *			tabsNew= (TabStop *)0;

    int				csCountNew= 0;
    ColumnSeparator *		csNew= (ColumnSeparator *)0;

    double			xfac= ea->eaMagnifiedPixelsPerTwip;
    double			magnification= ea->eaMagnification;

    unsigned int		change;
    unsigned int		taUpdMask= 0;
    unsigned int		ppUpdMask= PPupdNONE;

    ParagraphProperties		pp;
    TextAttribute		ta;

    FormattingFrame		ff;

    tedParagraphFrame( &ff, add, -1, bi );

    leftIndentNew= ff.ffX0TextLines;
    firstIndentNew= ff.ffX0FirstLine;
    rightIndentNew= ff.ffX1TextLines;

    tedHorizontalRulerTrackMouse( w, ed->edTopRuler, event, &change,
			    &firstIndentNew, &leftIndentNew, &rightIndentNew,
			    &tabCountNew, &tabsNew,
			    &csCountNew, &csNew,
			    (void *)ed, tedDragVerticalHair );

    switch( change )
	{
	case PPupdNONE:
	    return;
	case PPupdLEFT_INDENT:
	case PPupdFIRST_INDENT:
	    ppUpdMask= PPupdLEFT_INDENT | PPupdFIRST_INDENT;
	    break;

	case PPupdRIGHT_INDENT:
	case PPupdTAB_STOPS:
	    ppUpdMask= change;
	    break;

	case PPupdCOLUMNS:
	    tedUpdateTableColumns( ed, bi,
				    xfac, magnification, csCountNew, csNew );
	    return;
	default:
	    LDEB(change); return;
	}

    docInitParagraphProperties( &pp );
    docInitTextAttribute( &ta );

    if  ( docCopyParagraphProperties( &pp, &(bi->biParaProperties ) ) )
	{ LDEB(1); return;	}

    if  ( tedGetRulerTwips( add, bi, &pp,
			    firstIndentNew, leftIndentNew, rightIndentNew,
			    tabCountNew, tabsNew ) )
	{ LDEB(1); return;	}

    if  ( tedChangeSelectionProperties( ed, taUpdMask, ta, ppUpdMask, &pp ) )
	{ LDEB(1);	}

    docCleanParagraphProperties( &pp );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt the horizontal ruler to the current paragraph.		*/
/*									*/
/************************************************************************/
void tedDocAdaptHorizontalRuler(	EditDocument *		ed,
					BufferItem *		bi,
					int			andExpose )
    {
    if  ( ed->edTopRuler )
	{
	AppDrawingData *		add= &(ed->edDrawingData);
	ParagraphProperties *		pp= &(bi->biParaProperties);

	int				leftIndent;
	int				firstIndent;
	int				rightIndent;

	int				documentWidth;

	FormattingFrame		ff;

	tedParagraphFrame( &ff, add, -1, bi );

	documentWidth= add->addPaperRect.drX1- add->addPaperRect.drX0;

	leftIndent= ff.ffX0TextLines;
	firstIndent= ff.ffX0FirstLine;
	rightIndent= ff.ffX1TextLines;

	tedAdaptHorizontalRuler( ed->edTopRuler, ed->edTopRulerWidget,
		    add->addDocRect.drX0, add->addDocRect.drX1,
		    firstIndent, leftIndent, rightIndent, documentWidth,
		    pp->ppTabCount, pp->ppTabStops, andExpose );

	if  ( bi->biParaInTable )
	    {
	    int			csCount;
	    ColumnSeparator *	cs;

	    if  ( tedGetColumns( bi, add, &cs, &csCount ) )
		{ LDEB(1); return;	}

	    tedSetRulerColumns( ed->edTopRulerWidget, ed->edTopRuler,
					ff.ffX0Geometry, ff.ffX1Geometry,
					cs, csCount );
	    }
	else{
	    tedSetRulerColumns( ed->edTopRulerWidget, ed->edTopRuler,
					ff.ffX0Geometry, ff.ffX1Geometry,
					(ColumnSeparator *)0, 0 );
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Redraw a top ruler.							*/
/*									*/
/************************************************************************/
static void tedTopRulerExpose(	Widget		w,
				XtPointer	voidtr,
				XtPointer	voidcbs	)
    {
    XmDrawingAreaCallbackStruct *	cbs;

    cbs= (XmDrawingAreaCallbackStruct *)voidcbs;

    tedExposeHorizontalRuler( w, voidtr, cbs->event );
    }

/************************************************************************/
/*									*/
/*  Make the ruler administration for the top ruler widget of a		*/
/*  document.								*/
/*									*/
/************************************************************************/
void tedDocSetTopRuler(	EditDocument *	ed,
			int		documentWidth,
			int		topRulerHeight,
			double		horPixPerMM,
			int		unitInt,
			Display *	display,
			int		screen )
    {
    AppDrawingData *	add= &(ed->edDrawingData);

    Pixel		topPixel;
    Pixel		bottomPixel;
    Pixel		forePixel;
    Pixel		backPixel;

    XtVaGetValues( ed->edTopRulerWidget,
			XmNforeground,		&forePixel,
			XmNbackground,		&backPixel,
			XmNtopShadowColor,	&topPixel,
			XmNbottomShadowColor,	&bottomPixel,
			NULL );

    ed->edTopRuler= tedMakeRuler( topRulerHeight,
			    horPixPerMM, add->sgMagnification,
			    forePixel, backPixel, topPixel, bottomPixel,
			    ed->edLeftRulerWidth, ed->edRightRulerWidth,
			    add->addDocRect.drX0, add->addDocRect.drX1,
			    ed->edVisibleRect.drX0, ed->edVisibleRect.drX1,
			    documentWidth, unitInt );

    XtAddEventHandler( ed->edTopRulerWidget, StructureNotifyMask, False,
			tedHorizontalRulerConfigure, (void *)ed->edTopRuler );

    XtAddCallback( ed->edTopRulerWidget, XmNexposeCallback, tedTopRulerExpose,
							    ed->edTopRuler );

    XtAddEventHandler( ed->edTopRulerWidget, ButtonPressMask, False,
				tedHorizontalRulerButtonDown, (void *)ed );

    return;
    }

/************************************************************************/
/*									*/
/*  Callbacks for the Copy/Paste ruler menu options.			*/
/*									*/
/************************************************************************/

void tedDocFormatCopyRul(	Widget		fontsOption,
				XtPointer	voided,
				XtPointer	voidpbcbs	 )
    {
    EditDocument *			ed= (EditDocument *)voided;
    TedDocument *			td= (TedDocument *)ed->edPrivateData;
    SimpleOutputStream *		sos;
    XmPushButtonCallbackStruct *	pbcs=
					(XmPushButtonCallbackStruct *)voidpbcbs;

    if  ( ! td->tdSelection.bsBegin.bpBi )
	{ XDEB(td->tdSelection.bsBegin.bpBi); return;	}

    sos= sioOutMemoryOpen( &(td->tdCopiedRuler) );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    if  ( docRtfSaveRuler( sos,
			&(td->tdSelection.bsBegin.bpBi->biParaProperties) ) )
	{ LDEB(1); sioOutClose( sos ); return;	}

    if  ( sioOutClose( sos ) )
	{ LDEB(1); return;	}

    appDocOwnSelection( ed, "RULER",
		    TedRulerTargets, TedRulerTargetCount,
		    pbcs->event->xbutton.time );
    }

void tedDocFormatPasteRul(	Widget		fontsOption,
				XtPointer	voided,
				XtPointer	voidpbcbs	 )
    {
    EditDocument *			ed= (EditDocument *)voided;
    XmPushButtonCallbackStruct *	pbcs=
					(XmPushButtonCallbackStruct *)voidpbcbs;

    appDocAskForPaste( ed, "RULER", pbcs->event->xbutton.time );
    }

/************************************************************************/
/*									*/
/*  Merge the paragraphs in the selection.				*/
/*									*/
/************************************************************************/
void tedDocFormatOnePara(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs )
    {
    EditDocument *			ed= (EditDocument *)voided;

    tedMergeParagraphsInSelection( ed );

    tedAdaptToolsToSelection( ed );

    appDocumentChanged( ed->edApplication, ed, 1 );
    }

