/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	<Xm/ToggleB.h>

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Get font properties of the current position.			*/
/*									*/
/************************************************************************/
void tedGetPositionAttributes(	TedDocument *		td,
				const BufferPosition *	bp,
				char **			pFamilyName,
				int *			pPsFamilyNumber,
				unsigned int *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    BufferDocument *	bd= td->tdDocument;
    DocumentFontList *	dfl= &(bd->bdFontList);
    BufferItem *	bi= bp->bpBi;
    int			part= bp->bpParticule;
    TextParticule *	tp= bi->biParaParticules+ part;
    DocumentFont *	df= dfl->dflFonts+ tp->tpTextAttribute.taFontNumber;

    *pFamilyName= df->dfName;
    *pPsFamilyNumber= df->dfPsFamilyNumber;

    *pTaNew= tp->tpTextAttribute;
    *pUpdMask= TAmaskALL;

    return;
    }

/************************************************************************/
/*									*/
/*  Get font properties of the current selection.			*/
/*									*/
/************************************************************************/

void tedGetSelectionAttributes(	TedDocument *		td,
				char **			pFamilyName,
				int *			pPsFamilyNumber,
				unsigned int *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentFontList *		dfl= &(bd->bdFontList);
    const BufferSelection *	bs= &(td->tdSelection);
    BufferItem *		bi= bs->bsBegin.bpBi;
    int				part= bs->bsBegin.bpParticule;
    TextParticule *		tp= bi->biParaParticules+ part;
    DocumentFont *		df= dfl->dflFonts+ tp->tpTextAttribute.taFontNumber;


    char *		familyName;
    int			psFamilyNumber;

    TextAttribute	taNew;
    unsigned int	updMask;

    familyName= df->dfName;
    psFamilyNumber= df->dfPsFamilyNumber;

    taNew= tp->tpTextAttribute;
    updMask= TAmaskALL;

    for (;;)
	{
	int	col;

	col= bi->biParent->biNumberInParent;

	if  ( bs->bsCol0 < 0					||
	      bs->bsCol1 < 0					||
	      ( col >= bs->bsCol0 && col <= bs->bsCol1 )	)
	    {
	    while( part < bi->biParaParticuleCount )
		{
		TextAttribute	taDoc;

		df= dfl->dflFonts+ tp->tpTextAttribute.taFontNumber;

		if  ( bi == bs->bsBegin.bpBi			&&
		      tp->tpStroff == bs->bsBegin.bpStroff	)
		    {
		    familyName= df->dfName;
		    psFamilyNumber= df->dfPsFamilyNumber;

		    taNew= tp->tpTextAttribute;
		    updMask= TAmaskALL;
		    }

		if  ( bi == bs->bsEnd.bpBi			&&
		      tp->tpStroff >= bs->bsEnd.bpStroff	)
		    { break;	}

		if  ( df->dfPsFamilyNumber != psFamilyNumber )
		    {
		    updMask &= ~TAmaskFONTFAMILY;
		    psFamilyNumber= -1;
		    familyName= (char *)0;
		    }

		taDoc= tp->tpTextAttribute;

		if  ( taDoc.taFontSizeHalfPoints != taNew.taFontSizeHalfPoints )
		    { updMask &= ~TAmaskFONTSIZE;	}
		if  ( taDoc.taFontIsBold != taNew.taFontIsBold )
		    { updMask &= ~TAmaskFONTBOLD;	}
		if  ( taDoc.taFontIsSlanted != taNew.taFontIsSlanted )
		    { updMask &= ~TAmaskFONTSLANTED;	}
		if  ( taDoc.taIsUnderlined != taNew.taIsUnderlined )
		    { updMask &= ~TAmaskTEXTUNDERLINED;	}
		if  ( taDoc.taInField != taNew.taInField )
		    { updMask &= ~TAmaskTEXTINFIELD;	}
		if  ( taDoc.taSuperSub != taNew.taSuperSub )
		    { updMask &= ~TAmaskSUPERSUB;	}

		tp++; part++;
		}
	    }

	if  ( bi == bs->bsEnd.bpBi )
	    { break;	}

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}

	part= 0; tp= bi->biParaParticules;
	}

    *pFamilyName= familyName;
    *pPsFamilyNumber= psFamilyNumber;

    *pUpdMask= updMask;
    *pTaNew= taNew;

    return;
    }

/************************************************************************/
/*									*/
/*  Get font properties of the current position or selection.		*/
/*									*/
/************************************************************************/

int tedGetDocumentAttributes(	TedDocument *		td,
				char **			pFamilyName,
				int *			pPsFamilyNumber,
				unsigned int *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    if  ( tedHasIBarSelection( td ) )
	{
	BufferDocument *	bd= td->tdDocument;
	TextAttribute		ta= td->tdCurrentTextAttribute;
	DocumentFontList *	dfl= &(bd->bdFontList);
	DocumentFont *		df= dfl->dflFonts+ ta.taFontNumber;

	if  ( ta.taFontNumber < 0 || ta.taFontNumber >= dfl->dflCount )
	    { LLDEB(ta.taFontNumber,dfl->dflCount); return -1; }

	*pFamilyName= df->dfName;
	*pPsFamilyNumber= df->dfPsFamilyNumber;

	*pTaNew= ta;
	*pUpdMask= TAmaskALL;

	return 0;
	}

    if  ( td->tdSelection.bsBegin.bpBi )
	{
	tedGetSelectionAttributes( td, pFamilyName, pPsFamilyNumber,
							pUpdMask, pTaNew );

	return 0;
	}

    return 1;
    }


int tedGetDocumentAttributeString(	char *		scratch,
					TedDocument *	td )
    {
    char *		familyName;
    int			psFamilyNumber;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	{ return -1;	}

    appFontAttributeString( scratch, familyName, updMask, taNew );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Change the attributes of a particule.				*/
/*									*/
/************************************************************************/
int tedChangeParticuleAttribute( AppDrawingData *	add,
				TextParticule *		tp,
				DocumentFontList *	dfl,
				unsigned int		updMask,
				TextAttribute		taNew )
    {
    int			physicalFont;
    TextAttribute	ta;

    ta= tp->tpTextAttribute;

    if  ( updMask & TAmaskFONTFAMILY )
	{ ta.taFontNumber= taNew.taFontNumber;	}
    if  ( updMask & TAmaskFONTSIZE )
	{ ta.taFontSizeHalfPoints= taNew.taFontSizeHalfPoints; }
    if  ( updMask & TAmaskFONTBOLD )
	{ ta.taFontIsBold= taNew.taFontIsBold;		}
    if  ( updMask & TAmaskFONTSLANTED )
	{ ta.taFontIsSlanted= taNew.taFontIsSlanted;	}
    if  ( updMask & TAmaskTEXTUNDERLINED )
	{ ta.taIsUnderlined= taNew.taIsUnderlined;	}
    if  ( updMask & TAmaskTEXTINFIELD )
	{ ta.taInField= taNew.taInField;		}
    if  ( updMask & TAmaskSUPERSUB )
	{ ta.taSuperSub= taNew.taSuperSub;		}

    physicalFont= appOpenDocumentFont( add, dfl, ta );

    if  ( physicalFont < 0 )
	{ LLDEB(ta.taFontIsBold,ta.taFontIsSlanted); return -1; }

    tp->tpTextAttribute= ta;
    tp->tpPhysicalFont= physicalFont;

    return 0;
    }
