/************************************************************************/
/*									*/
/*  The 'Paragraph' page of the format tool.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<Xm/Text.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/Form.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	<appUtil.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Update the controls for SpaceAbove/SpaceBelow.			*/
/*									*/
/************************************************************************/

static void tedFormatToolRefreshSpaceAround(	Widget		text,
						Widget		toggle,
						int		space )
    {
    char		scratch[50];

    if  ( space == 0 )
	{
	XmTextSetString( text, "" );
	appEnableText( text, 0 );

	XmToggleButtonSetState( toggle, 0, False );
	}
    else{
	appGeoLengthToString( scratch, space, UNITtyPOINTS );
	XmTextSetString( text, scratch );
	appEnableText( text, 1 );

	XmToggleButtonSetState( toggle, 1, False );
	}
    }

void tedFormatToolRefreshParagraphPage(	ParagraphTool *	pt )
    {
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    char		scratch[50];

    appGeoLengthToString( scratch,
	    pp->ppLeftIndentTwips+ pp->ppFirstIndentTwips, UNITtyPOINTS );
    XmTextSetString( pt->ptFirstIndentText, scratch );

    appGeoLengthToString( scratch, pp->ppLeftIndentTwips, UNITtyPOINTS );
    XmTextSetString( pt->ptLeftIndentText, scratch );

    appGeoLengthToString( scratch, pp->ppRightIndentTwips, UNITtyPOINTS );
    XmTextSetString( pt->ptRightIndentText, scratch );

    tedFormatToolRefreshSpaceAround( pt->ptSpaceAboveText,
		    pt->ptSpaceAboveToggle, pp->ppSpaceBeforeTwips );

    tedFormatToolRefreshSpaceAround( pt->ptSpaceBelowText,
		    pt->ptSpaceBelowToggle, pp->ppSpaceAfterTwips );

    tedFormatReflectBorder( pt->ptTopBorderToggle, &(pp->ppTopBorder) );
    tedFormatReflectBorder( pt->ptBottomBorderToggle, &(pp->ppBottomBorder) );

    tedFormatRefreshHeightChooser( &(pt->ptLineDistChooser),
						    pp->ppLineSpacingTwips );

    switch( pp->ppAlignment )
	{
	case DOCiaLEFT:
	    XtVaSetValues( pt->ptAlignMenu,
			    XmNmenuHistory,	pt->ptAlignLeftItem,
			    NULL );
	    break;

	case DOCiaRIGHT:
	    XtVaSetValues( pt->ptAlignMenu,
			    XmNmenuHistory,	pt->ptAlignRightItem,
			    NULL );
	    break;

	case DOCiaCENTERED:
	    XtVaSetValues( pt->ptAlignMenu,
			    XmNmenuHistory,	pt->ptAlignCenteredItem,
			    NULL );
	    break;

	case DOCiaJUSTIFIED:
	    XtVaSetValues( pt->ptAlignMenu,
			    XmNmenuHistory,	pt->ptAlignJustifiedItem,
			    NULL );
	    break;

	default:
	    LDEB(pp->ppAlignment); break;
	}

    XmToggleButtonSetState( pt->ptOnNewPageToggle,
					    pp->ppStartsOnNewPage, False );
    XmToggleButtonSetState( pt->ptOnOnePageToggle,
					    pp->ppKeepOnPage, False );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button on the paragraph tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatParaRevertPushed(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;

    docCopyParagraphProperties( &(pt->ptPropertiesChosen),
						&(pt->ptPropertiesSet) );

    tedFormatToolRefreshParagraphPage( pt );

    return;
    }


/************************************************************************/
/*									*/
/*  Check user input.							*/
/*									*/
/************************************************************************/

static void tedParaFirstIndentChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				lipfi;
    int				changed;
    int				requirePositive= 1;

    lipfi=  pp->ppLeftIndentTwips+ pp->ppFirstIndentTwips;
    if  ( ! appGetLengthFromTextWidget( w, &lipfi, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, lipfi, UNITtyPOINTS );
	XmTextSetString( pt->ptFirstIndentText, scratch );
	}

    return;
    }

static void tedParaLeftIndentChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;
    int				requirePositive= 1;

    value= pp->ppLeftIndentTwips;
    if  ( ! appGetLengthFromTextWidget( w, &value, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( pt->ptLeftIndentText, scratch );
	}

    return;
    }

static void tedParaRightIndentChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;
    int				requirePositive= 1;

    value= pp->ppRightIndentTwips;
    if  ( ! appGetLengthFromTextWidget( w, &value, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( pt->ptRightIndentText, scratch );
	}

    return;
    }

static void tedParaSpaceAboveChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;
    int				requirePositive= 1;

    value= pp->ppSpaceBeforeTwips;
    if  ( ! appGetLengthFromTextWidget( w, &value, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	}

    return;
    }

static void tedParaSpaceBelowChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;
    int				requirePositive= 1;

    value= pp->ppSpaceAfterTwips;
    if  ( ! appGetLengthFromTextWidget( w, &value, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	}

    return;
    }

static void tedParaLineDistanceChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;
    int				requirePositive= 1;

    value= pp->ppLineSpacingTwips;
    if  ( ! appGetLengthFromTextWidget( w, &value, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Previous/Next Paragraph buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedFormatPrevPara(		Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedSelectWholeParagraph( ea, -1 );

    return;
    }

static void tedFormatNextPara(		Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedSelectWholeParagraph( ea, 1 );

    return;
    }

static void tedFormatSelectPara(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedSelectWholeParagraph( ea, 0 );

    return;
    }

static void tedFormatDeletePara(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedDeleteCurrentParagraph( ea );
    }

static void tedFormatInsertPara(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedInsertParagraph( ea, 0 );

    return;
    }

static void tedFormatAppendPara(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedInsertParagraph( ea, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Change' button on the paragraph page has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatChangePara(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidpbcs	 )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;
    EditDocument *		ed= ea->eaCurrentDocument;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    TextAttribute		ta;

    int				li;
    int				lipfi;

    int				value;
    int				changed;

    unsigned int		taUpdMask= 0;
    unsigned int		ppUpdMask= PPupdALL;

    docInitTextAttribute	(&ta);

    if  ( ! ed )
	{ XDEB(ed); return;	}

    lipfi= pp->ppLeftIndentTwips+ pp->ppFirstIndentTwips;
    if  ( appGetLengthFromTextWidget( pt->ptFirstIndentText,
					&lipfi, &changed, UNITtyPOINTS, 0 ) )
	{ return;	}

    li= pp->ppLeftIndentTwips;
    if  ( appGetLengthFromTextWidget( pt->ptLeftIndentText,
					&li, &changed, UNITtyPOINTS, 1 ) )
	{ return;	}

    pp->ppLeftIndentTwips= li;
    pp->ppFirstIndentTwips= lipfi- li;

    value= pp->ppRightIndentTwips;
    if  ( appGetLengthFromTextWidget( pt->ptRightIndentText,
					&value, &changed, UNITtyPOINTS, 1 ) )
	{ return;	}
    pp->ppRightIndentTwips= value;

    value= pp->ppLineSpacingTwips;
    if  ( tedFormatToolGetHeight( &value, &(pt->ptLineDistChooser) ) )
	{ return;	}
    pp->ppLineSpacingTwips= value;

    if  ( tedChangeSelectionProperties( ed, taUpdMask, ta, ppUpdMask, pp ) )
	{ LDEB(1);	}

    return;
    }

/************************************************************************/
/*  One of the Space toggles was activated:				*/
/************************************************************************/

static void tedFormatSpaceAboveToggled(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);
    XmToggleButtonCallbackStruct *	tbcs;

    tbcs= (XmToggleButtonCallbackStruct *)voidtbcs;

    if  ( tbcs->set )
	{
	if  ( pt->ptPropertiesSet.ppSpaceBeforeTwips != 0 )
	    {
	    pp->ppSpaceBeforeTwips=
			    pt->ptPropertiesSet.ppSpaceBeforeTwips;
	    }
	else{
	    EditDocument *	ed= pt->ptApplication->eaCurrentDocument;
	    int			lineHeight;

	    if  ( ! ed || tedGetParaLineHeight( &lineHeight, ed ) )
		{ XLDEB(ed,tbcs->set);			}
	    else{ pp->ppSpaceBeforeTwips= lineHeight;	}
	    }
	}
    else{
	pp->ppSpaceBeforeTwips= 0;
	}

    tedFormatToolRefreshSpaceAround( pt->ptSpaceAboveText,
		    pt->ptSpaceAboveToggle, pp->ppSpaceBeforeTwips );

    return;
    }

static void tedFormatSpaceBelowToggled(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);
    XmToggleButtonCallbackStruct *	tbcs;

    tbcs= (XmToggleButtonCallbackStruct *)voidtbcs;

    if  ( tbcs->set )
	{
	if  ( pt->ptPropertiesSet.ppSpaceAfterTwips != 0 )
	    {
	    pp->ppSpaceAfterTwips=
			    pt->ptPropertiesSet.ppSpaceAfterTwips;
	    }
	else{
	    EditDocument *	ed= pt->ptApplication->eaCurrentDocument;
	    int			lineHeight;

	    if  ( ! ed || tedGetParaLineHeight( &lineHeight, ed ) )
		{ XLDEB(ed,tbcs->set);			}
	    else{ pp->ppSpaceAfterTwips= lineHeight;	}
	    }
	}
    else{
	pp->ppSpaceAfterTwips= 0;
	}

    tedFormatToolRefreshSpaceAround( pt->ptSpaceBelowText,
		    pt->ptSpaceBelowToggle, pp->ppSpaceAfterTwips );

    return;
    }

static void tedParaAlignmentChosen(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);

    if  ( w == pt->ptAlignLeftItem )
	{ pp->ppAlignment= DOCiaLEFT; return;	}

    if  ( w == pt->ptAlignRightItem )
	{ pp->ppAlignment= DOCiaRIGHT; return;	}

    if  ( w == pt->ptAlignCenteredItem )
	{ pp->ppAlignment= DOCiaCENTERED; return;	}

    if  ( w == pt->ptAlignJustifiedItem )
	{ pp->ppAlignment= DOCiaJUSTIFIED; return;	}

    LDEB(1); return;
    }


/************************************************************************/
/*									*/
/*  A line Spacing was chosen with the menu.				*/
/*									*/
/************************************************************************/

static void tedParaLineDistChosen(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;

    int			defaultValue;

    defaultValue= pt->ptPropertiesChosen.ppLineSpacingTwips;
    if  ( defaultValue == 0 )
	{ defaultValue= pt->ptPropertiesSet.ppLineSpacingTwips;	}
    if  ( defaultValue == 0 )
	{ defaultValue= 240;	}

    tedFormatHeightChosen( w, &(pt->ptLineDistChooser), defaultValue );

    return;
    }

static void tedFormatMakeAlignRow(	Widget *		pRow,
					Widget *		pMenu,
					Widget *		pPulldown,
					Widget *		pLabel,
					Widget			parent,
					const char *		alignText )
    {
    Arg		al[20];
    int		ac= 0;

    Widget	row;
    Widget	menuForm;
    Widget	pulldown;
    Widget	menu;
    Widget	label;

    row= appMakeButtonRow( parent, 2 );

    /**************/
    appMakeRowLabel( &label, row, alignText );

    /**************/
    ac= 0;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;

    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		1 ); ac++;

    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		2 ); ac++;

    menuForm= XmCreateForm( row, WIDGET_NAME, al, ac );

    appMakePulldownList( &pulldown, &menu, menuForm );

    XtVaSetValues( pulldown,
			XmNresizeWidth,		True,
			NULL );

    XtVaSetValues( menu,
			XmNleftOffset,		0,
			XmNrightOffset,		3,
			NULL );

    XtManageChild( menu );
    XtManageChild( menuForm );
    XtManageChild( row );

    *pRow= row;
    *pMenu= menu;
    *pPulldown= pulldown;
    *pLabel= label;

    return;
    }

/************************************************************************/
/*									*/
/*  One of the 'Paragraph Border' toggles has been activated.		*/
/*									*/
/************************************************************************/

static void tedParagraphToggleChanged(	Widget		w,
					XtPointer	voidpt,
					XtPointer	voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);
    XmToggleButtonCallbackStruct *	tbcs;

    tbcs= (XmToggleButtonCallbackStruct *)voidtbcs;

    if  ( w == pt->ptTopBorderToggle )
	{
	tedFormatToggleBorder( &(pp->ppTopBorder), tbcs->set );

	return;
	}

    if  ( w == pt->ptBottomBorderToggle )
	{
	tedFormatToggleBorder( &(pp->ppBottomBorder), tbcs->set );

	return;
	}

    if  ( w == pt->ptOnNewPageToggle )
	{
	pp->ppStartsOnNewPage= ( tbcs->set != 0 );

	return;
	}

    if  ( w == pt->ptOnOnePageToggle )
	{
	pp->ppKeepOnPage= ( tbcs->set != 0 );

	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make the paragraph page.						*/
/*									*/
/************************************************************************/

void tedFormatMakeParagraphPage( ParagraphTool *		pt,
				Widget				pageParent,
				const ParagraphPageResources *	ppr,
				ToolSubject *			ts,
				const FormatPageResources *	fpr )
    {
    Widget		pageWidget;

    Widget		firstLabel;
    Widget		leftLabel;
    Widget		rightLabel;
    Widget		alignLabel;

    Widget		row;

    const int		textColumns= 10;

    /**/
    docInitParagraphProperties( &(pt->ptPropertiesSet) );
    docInitParagraphProperties( &(pt->ptPropertiesChosen) );

    /**/
    pageWidget= tedFormatMakePage( ts, pageParent );

    /**/
    appMakeLabelAndTextRow( &row, &firstLabel, &(pt->ptFirstIndentText),
		    pageWidget, ppr->pprParaFirstIndent, textColumns, 1 );

    XtAddCallback( pt->ptFirstIndentText, XmNactivateCallback,
				    tedParaFirstIndentChanged, (void *)pt );
    /**/
    appMakeLabelAndTextRow( &row, &leftLabel, &(pt->ptLeftIndentText),
		    pageWidget, ppr->pprParaLeftIndent, textColumns, 1 );

    XtAddCallback( pt->ptLeftIndentText, XmNactivateCallback,
				    tedParaLeftIndentChanged, (void *)pt );
    /**/
    appMakeLabelAndTextRow( &row, &rightLabel, &(pt->ptRightIndentText),
		    pageWidget, ppr->pprParaRightIndent, textColumns, 1 );

    XtAddCallback( pt->ptRightIndentText, XmNactivateCallback,
				    tedParaRightIndentChanged, (void *)pt );
    /**/
    tedFormatMakeAlignRow( &row, &(pt->ptAlignMenu), &(pt->ptAlignPulldown),
		    &alignLabel, pageWidget, ppr->pprParaAlignment );

    /**/
    tedFormatMakeHeightRow( &row, (void *)pt, pageWidget,
		    &(pt->ptLineDistChooser), tedParaLineDistanceChanged );

    /**/
    appMakeToggleAndTextRow( &row, &(pt->ptSpaceAboveToggle),
		    &(pt->ptSpaceAboveText), pageWidget,
		    ppr->pprParaSpaceAbove,
		    tedFormatSpaceAboveToggled, (void *)pt,
		    textColumns, 1 );

    XtAddCallback( pt->ptSpaceAboveText, XmNactivateCallback,
				    tedParaSpaceAboveChanged, (void *)pt );
    /**/
    appMakeToggleAndTextRow( &row, &(pt->ptSpaceBelowToggle),
		    &(pt->ptSpaceBelowText), pageWidget,
		    ppr->pprParaSpaceBelow,
		    tedFormatSpaceBelowToggled, (void *)pt,
		    textColumns, 1 );

    XtAddCallback( pt->ptSpaceBelowText, XmNactivateCallback,
				    tedParaSpaceBelowChanged, (void *)pt );
    /**/
    tedFormatMakeToggleRow( &row, pageWidget,
		    &(pt->ptTopBorderToggle), &(pt->ptBottomBorderToggle),
		    ppr->pprTopBorder, ppr->pprBottomBorder,
		    tedParagraphToggleChanged,
		    tedParagraphToggleChanged, (void *)pt );
    /**/
    tedFormatMakeToggleRow( &row, pageWidget,
		    &(pt->ptOnNewPageToggle), &(pt->ptOnOnePageToggle),
		    ppr->pprOnNewPage, ppr->pprOnOnePage,
		    tedParagraphToggleChanged,
		    tedParagraphToggleChanged, (void *)pt );

    XtSetSensitive( pt->ptOnOnePageToggle, False );

    /**/
    tedFormatMakeButtonRow( &row, pageWidget,
			&(ts->tsPrevButton), &(ts->tsNextButton),
			fpr->fprPrevButtonText, fpr->fprNextButtonText,
			tedFormatPrevPara, tedFormatNextPara, pt );

    tedFormatMakeButtonRow( &row, pageWidget,
			&(ts->tsSelectButton), &(ts->tsDeleteButton),
			fpr->fprSelectButtonText, fpr->fprDeleteButtonText,
			tedFormatSelectPara, tedFormatDeletePara, pt );

    tedFormatMakeButtonRow( &row, pageWidget,
			&(ts->tsInsertButton), &(ts->tsAppendButton),
			fpr->fprInsertButtonText, fpr->fprAppendButtonText,
			tedFormatInsertPara, tedFormatAppendPara, pt );

    tedFormatMakeButtonRow( &row, pageWidget,
			&(ts->tsRevertButton), &(ts->tsApplyButton),
			fpr->fprRevert, fpr->fprApplyToSubject,
			tedFormatParaRevertPushed, tedFormatChangePara, pt );

    XtManageChild( pageWidget );
    XtManageChild( ts->tsPage );

    return;
    }

/************************************************************************/
/*  Fill the alignment menu on the paragraph page.			*/
/************************************************************************/

static void tedFormatFillAlignMenu(	ParagraphTool *			pt,
					void *				voidpt,
					const ParagraphPageResources *	ppr )
    {
    Dimension		width;
    Widget		pulldown= pt->ptAlignPulldown;

    XtVaGetValues( pt->ptAlignMenu,
			XmNwidth,		&width,
			NULL );

    appEmptyPulldownList( pulldown );

    pt->ptAlignLeftItem= appPulldownMakeOption( pulldown,
			ppr->pprParaAlignLeft, width,
			tedParaAlignmentChosen, voidpt );

    pt->ptAlignRightItem= appPulldownMakeOption( pulldown,
			ppr->pprParaAlignRight, width,
			tedParaAlignmentChosen, voidpt );

    pt->ptAlignCenteredItem= appPulldownMakeOption( pulldown,
			ppr->pprParaAlignCentered, width,
			tedParaAlignmentChosen, voidpt );

    pt->ptAlignJustifiedItem= appPulldownMakeOption( pulldown,
			ppr->pprParaAlignJustified, width,
			tedParaAlignmentChosen, voidpt );

    /*
    XtSetSensitive( pt->ptAlignJustifiedItem, False );
    */

    XtVaSetValues( pt->ptAlignMenu,
			    XmNmenuHistory,	pt->ptAlignLeftItem,
			    NULL );

    appPulldownSetWidth( pt->ptAlignMenu, width );
    }

/************************************************************************/
/*									*/
/*  Finish the paragraph page.						*/
/*									*/
/************************************************************************/

void tedFormatFillParagraphChoosers(	ParagraphTool *			pt,
					const ParagraphPageResources *	ppr )
    {
    tedFormatFillHeightChooser( &(pt->ptLineDistChooser),
			    tedParaLineDistChosen, pt,
			    ppr->pprParaLineDistFree,
			    ppr->pprParaLineDistAtLeast,
			    ppr->pprParaLineDistExactly );

    tedFormatFillAlignMenu( pt, (void *)pt, ppr );
    }

void tedFormatFinishParagraphPage(	ParagraphTool *			pt,
					const ParagraphPageResources *	ppr )
    {
    Dimension		width;

    XtVaGetValues( pt->ptLineDistChooser.hcMenu,
			    XmNwidth,		&width,
			    NULL );
    appPulldownSetWidth( pt->ptLineDistChooser.hcMenu, width );

    XtVaGetValues( pt->ptAlignMenu,
			    XmNwidth,		&width,
			    NULL );
    appPulldownSetWidth( pt->ptAlignMenu, width );
    }
