/************************************************************************/
/*  Send Dialog.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Text.h>
#   include	<Xm/DialogS.h>
#   include	<Xm/MainW.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/Frame.h>
#   include	<Xm/DrawingA.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/RowColumn.h>

#   include	<appFrame.h>
#   include	<sioSmtp.h>

#   include	"appUtil.h"

#   define	DRH_CM	4.5

/************************************************************************/
/*  Represents a mail dialog.						*/
/************************************************************************/
#   define	FILEL	400

typedef struct AppMailDialog
    {
    Widget			amdTopWidget;
    Widget			amdDialog;

    Widget			amdContentPulldown;
    Widget			amdContentMenu;

    Widget			amdSendButton;

    char *			amdSubjectText;
    char *			amdToText;
    char *			amdFromText;
    char *			amdCcText;
    char *			amdBccText;

    Widget			amdSubjectWidget;
    Widget			amdToWidget;
    Widget			amdFromWidget;
    Widget			amdCcWidget;
    Widget			amdBccWidget;

    int				amdContentChosen;

    Widget			amdOption;
    EditApplication *		amdApplication;
    int				amdResponse;

    char *			amdContentText;
    char *			amdNoneText;
    char *			amdCancelText;
    char *			amdSendText;
    char *			amdMsgOkText;

    char *			amdSubjectMissing;
    char *			amdToMissing;
    char *			amdFromMissing;

    char *			amdDefaultContent;

    char *			amdMailFrom;
    char *			amdMailHost;
    } AppMailDialog;

static AppMailDialog *	APP_MailDialog;

# define xx(x)	x,x

static XtResource APP_MailDialogresourceTable[]=
    {
	{ xx("mailDialogSubject"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdSubjectText),
		    XtRString, "Subject" },
	{ xx("mailDialogTo"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdToText),
		    XtRString, "To" },
	{ xx("mailDialogFrom"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdFromText),
		    XtRString, "From" },
	{ xx("mailDialogCc"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdCcText),
		    XtRString, "Cc" },
	{ xx("mailDialogBcc"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdBccText),
		    XtRString, "Bcc" },

	{ xx("mailDialogContent"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdContentText),
		    XtRString, "Content Type" },
	{ xx("mailDialogNone"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdNoneText),
		    XtRString, "None" },

	{ xx("mailDialogCancel"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdCancelText),
		    XtRString, "Cancel" },
	{ xx("mailDialogSend"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdSendText),
		    XtRString, "Send" },
	{ xx("mailDialogMsgOk"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdMsgOkText),
		    XtRString, "Ok" },

	{ xx("mailDialogNoSubject"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdSubjectMissing),
		    XtRString, "Please enter a Subject" },
	{ xx("mailDialogNoTo"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdToMissing),
		    XtRString, "Please enter a Recipient" },
	{ xx("mailDialogNoFrom"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdFromMissing),
		    XtRString, "Please enter a Sender" },

	{ xx("mailContent"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdDefaultContent),
		    XtRString, "" },

	{ xx("mailFrom"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdMailFrom),
		    XtRString, "" },
	{ xx("mailHost"), XtRString, sizeof(char *),
		    offsetof(AppMailDialog,amdMailHost),
		    XtRString, "localhost" },
    };

/************************************************************************/
/*  Error call back from smtp software.					*/
/************************************************************************/

static char * APP_MailErrorMessages[SIO_SMTPeCOUNT];

static XtResource APP_MailErrorMessageresourceTable[]=
    {
	{ xx("mailErrorNoError"), XtRString, sizeof(char *),
		    SIO_SMTPeNOERROR* sizeof(char *),
		    XtRString, "No error" },
	{ xx("mailErrorNoMemory"), XtRString, sizeof(char *),
		    SIO_SMTPeNOMEM* sizeof(char *),
		    XtRString, "Insufficient memory" },
	{ xx("mailErrorNoFrom"), XtRString, sizeof(char *),
		    SIO_SMTPeFROM* sizeof(char *),
		    XtRString, "No sender given" },
	{ xx("mailErrorNoTo"), XtRString, sizeof(char *),
		    SIO_SMTPeRCPT* sizeof(char *),
		    XtRString, "No recipients given" },
	{ xx("mailErrorSmtp"), XtRString, sizeof(char *),
		    SIO_SMTPeSMTP* sizeof(char *),
		    XtRString, "A mail transfer error was received" },
	{ xx("mailErrorWrite"), XtRString, sizeof(char *),
		    SIO_SMTPeWRITE* sizeof(char *),
		    XtRString, "Could not write data to mail server" },
	{ xx("mailErrorRead"), XtRString, sizeof(char *),
		    SIO_SMTPeREAD* sizeof(char *),
		    XtRString, "Could not read data from server" },
	{ xx("mailErrorUname"), XtRString, sizeof(char *),
		    SIO_SMTPeUNAME* sizeof(char *), XtRString,
		    "Could not determine the name of the local machine" },
	{ xx("mailErrorHostaddr"), XtRString, sizeof(char *),
		    SIO_SMTPeHOST* sizeof(char *), XtRString,
		    "Could not resolve the address of the destination" },
	{ xx("mailErrorService"), XtRString, sizeof(char *),
		    SIO_SMTPeSERV* sizeof(char *), XtRString,
		    "Unknown service" },
	{ xx("mailErrorSocket"), XtRString, sizeof(char *),
		    SIO_SMTPeSOCK* sizeof(char *), XtRString,
		    "Could not create a socket to the server" },
	{ xx("mailErrorConnect"), XtRString, sizeof(char *),
		    SIO_SMTPeCONN* sizeof(char *), XtRString,
		    "Could not connect to the mail server" },
    };

static int appMailComplain(	void *		voidamd,
				int		message,
				const char *	subject )
    {
    AppMailDialog *	amd= (AppMailDialog *)voidamd;

    if  ( subject && subject[0] )
	{
	appQuestionRunSubjectErrorDialog( amd->amdApplication,
				    amd->amdTopWidget, amd->amdOption,
				    APP_MailErrorMessages[message], subject );
	}
    else{
	appQuestionRunErrorDialog( amd->amdApplication,
				    amd->amdTopWidget, amd->amdOption,
				    APP_MailErrorMessages[message] );
	}

    return 0;
    }

/************************************************************************/
/*  Show the correct content type in the menu.				*/
/************************************************************************/

static void appMailDialogShowContent(	AppMailDialog *	amd )
    {
    WidgetList		children;
    Cardinal		childCount= 0;

    XtVaGetValues( amd->amdContentPulldown,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    if  ( amd->amdContentChosen >= 0			&&
	  amd->amdContentChosen < (int)childCount	)
	{
	XtVaSetValues( amd->amdContentMenu,
			XmNmenuHistory,	children[amd->amdContentChosen],
			NULL );
	}
    else{
	XtVaSetValues( amd->amdContentMenu,
			    XmNmenuHistory,	(Widget)0,
			    NULL );
	}

    return;
    }

/************************************************************************/
/*  A content was chosen.						*/
/************************************************************************/
static void appContentChosen(	Widget		w,
				XtPointer	voidamd,
				XtPointer	voidpbcs	 )
    {
    short		contentChosen= -1;
    AppMailDialog *	amd= (AppMailDialog *)voidamd;

    XtVaGetValues( w,
			XmNpositionIndex,	&contentChosen,
			NULL );

    amd->amdContentChosen= contentChosen;

    return;
    }

/************************************************************************/
/*									*/
/*  'To' changed.							*/
/*									*/
/************************************************************************/

static void appMailCheckTo(	AppMailDialog *		amd )
    {
    char *	to;
    char *	s;

    s= to= XmTextGetString( amd->amdToWidget );

    while( *s == ' ' )
	{ s++;	}

    XtSetSensitive( amd->amdSendButton, *s != '\0' );

    if  ( *s != '\0' )
	{
	XtVaSetValues( amd->amdDialog,
			XmNdefaultButton,	amd->amdSendButton,
			NULL );
	}

    XtFree( to );

    return;
    }

static void appMailToChanged(	Widget		w,
				XtPointer	voidamd,
				XtPointer	call_data )
    {
    AppMailDialog *	amd= (AppMailDialog *)voidamd;

    appMailCheckTo( amd );

    return;
    }

/************************************************************************/
/*									*/
/*  The buttons have been pushed.					*/
/*									*/
/************************************************************************/

static void appMailDialogCancelPushed(	Widget		w,
					XtPointer	voidamd,
					XtPointer	voidpbcs	 )
    {
    AppMailDialog *	amd= (AppMailDialog *)voidamd;

    amd->amdResponse= AQDrespCANCEL;

    return;
    }

static void appMailDialogSendPushed(	Widget		w,
					XtPointer	voidamd,
					XtPointer	voidpbcs	 )
    {
    AppMailDialog *	amd= (AppMailDialog *)voidamd;

    amd->amdResponse= AQDrespOK;

    return;
    }

/************************************************************************/
/*  Fill the list of contents.						*/
/************************************************************************/
static void appMailDialogFillContentMenu(	AppMailDialog *		amd,
						EditApplication *	ea )
    {
    Dimension		width;
    int			i;
    Widget		defaultChild= (Widget)0;
    Widget		fresh;
    int			defaultContent= -1;

    MailContent *	mc= ea->eaMailContents;
    XtResource *	xtr;

    xtr= (XtResource *)malloc( ea->eaMailContentCount* sizeof(XtResource) );
    if  ( xtr )
	{
	for ( i= 0; i < ea->eaMailContentCount; i++ )
	    {
	    xtr[i].resource_name= mc[i].mcResourceName;
	    xtr[i].resource_class= mc[i].mcResourceName;
	    xtr[i].resource_type= XtRString;
	    xtr[i].resource_size= sizeof(char *);
	    xtr[i].resource_offset= i* sizeof(MailContent)+
					    offsetof(MailContent,mcNameText);
	    xtr[i].default_type= XtRString;
	    xtr[i].default_addr= mc[i].mcNameText;

	    if  ( ! strcmp( mc[i].mcResourceName, amd->amdDefaultContent ) )
		{ defaultContent= i;	}
	    }

	XtGetApplicationResources( ea->eaTopWidget,
				    mc, xtr, ea->eaMailContentCount, NULL, 0 );

	free( xtr );
	}

    XtVaGetValues( amd->amdContentMenu,
			XmNwidth,		&width,
			NULL );

    appEmptyPulldownList( amd->amdContentPulldown );

    if  ( defaultContent >= 0 )
	{ ea->eaDefaultMailContent= defaultContent;	}

    for ( i= 0; i < ea->eaMailContentCount; mc++, i++ )
	{
	fresh= appPulldownMakeOption( amd->amdContentPulldown,
			mc->mcNameText, width, appContentChosen, (void *)amd );

	if  ( i == ea->eaDefaultMailContent )
	    { defaultChild= fresh;	}
	if  ( i == 0 )
	    { defaultChild= fresh;	}
	}

    if  ( defaultChild )
	{
	XtVaSetValues( amd->amdContentMenu,
			    XmNmenuHistory,		defaultChild,
			    NULL );
	}
    
    if  ( ea->eaMailContentCount == 0 )
	{
	fresh= appPulldownMakeOption( amd->amdContentPulldown,
		    amd->amdNoneText, width, appContentChosen, (void *)amd );

	XtVaSetValues( amd->amdContentMenu,
			    XmNmenuHistory,		fresh,
			    NULL );

	XtSetSensitive( amd->amdContentMenu, 0 );
	}

    if  ( ea->eaDefaultMailContent >= 0 )
	{ amd->amdContentChosen= ea->eaDefaultMailContent;	}
    else{ amd->amdContentChosen= 0;				}

    appPulldownSetWidth( amd->amdContentMenu, width );
    }

/************************************************************************/
/*  A find tool must be destroyed.					*/
/************************************************************************/
static void appCloseMailDialog(		Widget		w,
					XtPointer	voidamd,
					XtPointer	voidlcs	 )
    {
    AppMailDialog *	amd= (AppMailDialog *)voidamd;

    amd->amdResponse= AQDrespCANCEL;

    return;
    }

/************************************************************************/
/*  Make the frame for selecting a content.				*/
/************************************************************************/

static Widget appMailDialogMakeContentFrame(	Widget		parent,
						AppMailDialog *	amd )
    {
    Widget	frame;
    Widget	bboard;
    Widget	paned;

    appMakeVerticalFrame( &frame, &bboard, &paned,
						parent, amd->amdContentText );

    /**********************/

    appMakePulldownList( &amd->amdContentPulldown,
						&amd->amdContentMenu, paned );

    /**********************/

    XtManageChild( amd->amdContentMenu );
    XtManageChild( paned );
    XtManageChild( bboard );
    XtManageChild( frame );

    return frame;
    }

/************************************************************************/
/*									*/
/*  Make the form with the text widgets.				*/
/*									*/
/************************************************************************/

static Widget appMailDialogMakeTextForm(	Widget		parent,
						AppMailDialog *	amd )
    {
    Widget		columns;
    Widget		labelColumn;
    Widget		textColumn;

    Widget		label;

    int			fromEditable= 1;

    if  ( amd->amdMailFrom && amd->amdMailFrom[0] )
	{ fromEditable= 0;	}

    appMakeLabelAndTextColumns( &labelColumn, &textColumn, &columns, parent );

    appMakeColumnLabel( &label, labelColumn, amd->amdSubjectText );
    appMakeColumnLabel( &label, labelColumn, amd->amdToText );
    appMakeColumnLabel( &label, labelColumn, amd->amdFromText );
    appMakeColumnLabel( &label, labelColumn, amd->amdCcText );
    appMakeColumnLabel( &label, labelColumn, amd->amdBccText );

    appMakeColumnText( &(amd->amdSubjectWidget), textColumn, 60, True );
    appMakeColumnText( &(amd->amdToWidget), textColumn, 60, True );
    appMakeColumnText( &(amd->amdFromWidget), textColumn, 60, fromEditable );
    appMakeColumnText( &(amd->amdCcWidget), textColumn, 60, True );
    appMakeColumnText( &(amd->amdBccWidget), textColumn, 60, True );

    XtAddCallback( amd->amdToWidget, XmNvalueChangedCallback,
					    appMailToChanged, (void *)amd );

    XtManageChild( labelColumn );
    XtManageChild( textColumn );
    XtManageChild( columns );

    return columns;
    }

/************************************************************************/
/*									*/
/*  Make the strip with the two buttons.				*/
/*									*/
/************************************************************************/

static Widget appMailDialogMakeButtonRow(	Widget		parent,
						AppMailDialog *	amd )
    {
    Widget	row;
    Widget	cancelButton;

    row= appMakeButtonRow( parent, 2 );

    /**********************/

    amd->amdSendButton= appMakeRowButton( row, amd->amdSendText,
			    appMailDialogSendPushed, (void *)amd, 0, True );

    /**********************/

    cancelButton= appMakeRowButton( row, amd->amdCancelText,
			    appMailDialogCancelPushed, (void *)amd, 1, False );

    XtVaSetValues( amd->amdDialog,
			XmNcancelButton,	cancelButton,
			NULL );

    /**********************/

    XtManageChild( amd->amdSendButton );
    XtManageChild( cancelButton );

    XtManageChild( row );

    return row;
    }

/************************************************************************/
/*									*/
/*  Make a mail dialog.							*/
/*									*/
/************************************************************************/

static AppMailDialog * appMakeMailDialog( EditApplication *	ea,
					EditDocument *		ed,
					Widget			mailOption,
					const char *		pixmapName )
    {
    AppMailDialog *	amd;
    
    Widget		paned;
    Widget		textForm;
    Widget		contentFrame;
    Widget		buttonForm;

    Dimension		width;

    const int		withSeparator= 0;
    Pixmap		iconPixmap= (Pixmap)0;

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	{ SDEB(pixmapName); return (AppMailDialog *)0;	}

    amd= (AppMailDialog *)malloc( sizeof(AppMailDialog) );
    if  ( ! amd )
	{ XDEB(amd); return (AppMailDialog *)0;	}

    XtGetApplicationResources( ea->eaTopWidget, amd,
				    APP_MailDialogresourceTable,
				    XtNumber(APP_MailDialogresourceTable),
				    NULL, 0 );

    if  ( ! APP_MailErrorMessages[0] )
	{
	XtGetApplicationResources( ea->eaTopWidget, APP_MailErrorMessages,
				    APP_MailErrorMessageresourceTable,
				    XtNumber(APP_MailErrorMessageresourceTable),
				    NULL, 0 );
	}

    amd->amdApplication= ea;
    amd->amdOption= mailOption;

    appMakeVerticalDialog( &(amd->amdTopWidget), &(amd->amdDialog),
			    &paned, ea, appCloseMailDialog, (void *)amd,
			    iconPixmap, withSeparator, ea->eaMailDialogName );

    appSetShellTitle( amd->amdTopWidget, mailOption, ea->eaApplicationName );


    textForm= appMailDialogMakeTextForm( paned, amd );
    contentFrame= appMailDialogMakeContentFrame( paned, amd );
    buttonForm= appMailDialogMakeButtonRow( paned, amd );

    XtManageChild( paned );

    appSetRelativeCallback( ed->edTopWidget, amd->amdDialog );

    appMailDialogFillContentMenu( amd, ea );

    XtManageChild( amd->amdDialog );

    appDialogRelative( ed->edTopWidget, amd->amdDialog );

    appSetFocusCallback( amd->amdDialog );

    XtVaGetValues( amd->amdContentMenu,
			    XmNwidth,		&width,
			    NULL );

    appPulldownSetWidth( amd->amdContentMenu, width );

    return amd;
    }

/************************************************************************/
/*									*/
/*  Show the 'Send...' dialog.						*/
/*									*/
/*  1)	Make or just show it.						*/
/*  2)	Set the default content.					*/
/*									*/
/************************************************************************/

int appRunMailDialog(			EditApplication *	ea,
					EditDocument *		ed,
					Widget			mailOption,
					const char *		pixmapName,
					const unsigned char *	documentSubject,
					void *			voiddoc )
    {
    int				rval= 0;
    int				complete= 0;
    int				resp= 0;

    AppMailDialog *		amd= APP_MailDialog;

    char *			mailSubject;
    char *			to;
    char *			from;
    char *			cc;
    char *			bcc;

    char *			s;

    MailContent *		mc;
    SimpleOutputStream *	sos;

    /*  1  */
    if  ( ! amd )
	{
	amd= APP_MailDialog= appMakeMailDialog( ea, ed, mailOption,
								pixmapName );
	if  ( ! amd )
	    { XDEB(amd); return -1;	}

	}
    else{
	appSetShellTitle( amd->amdTopWidget, mailOption,
						    ea->eaApplicationName );

	appSetRelativeCallback( ed->edTopWidget, amd->amdDialog );
	appDialogRelative( ed->edTopWidget, amd->amdDialog );

	appSetFocusCallback( amd->amdDialog );

	XtManageChild( amd->amdDialog );
	}

    amd->amdOption= mailOption;

    /*  2  */
    if  ( ea->eaDefaultMailContent >= 0				&&
	  ea->eaDefaultMailContent < ea->eaMailContentCount	)
	{ amd->amdContentChosen= ea->eaDefaultMailContent; }
    else{
	if  ( ea->eaMailContentCount > 0 )
	    { amd->amdContentChosen= 0;	}
	}

    if  ( amd->amdMailFrom && amd->amdMailFrom[0] )
	{ XmTextSetString( amd->amdFromWidget, amd->amdMailFrom );	}
    else{
	from =sioSmtpGuessMailAddress();

	if  ( from )
	    { XmTextSetString( amd->amdFromWidget, from ); }
	}

    appMailDialogShowContent( amd );
    appMailCheckTo( amd );

    if  ( documentSubject )
	{ XmTextSetString( amd->amdSubjectWidget, (char *)documentSubject ); }

    while( ! complete && ! rval )
	{
	amd->amdResponse= AQDrespNONE;

	while( amd->amdResponse == AQDrespNONE )
	    { XtAppProcessEvent( ea->eaContext, XtIMAll ); }

	switch( amd->amdResponse )
	    {
	    case AQDrespOK:
		break;
	    default:
		LDEB(amd->amdResponse);
		/*FALLTHROUGH*/
	    case AQDrespCANCEL:
		XtUnmanageChild( amd->amdDialog );
		return -1;
	    }

	if  ( amd->amdContentChosen < 0				||
	      amd->amdContentChosen >= ea->eaMailContentCount	)
	    { LLDEB(amd->amdContentChosen,ea->eaMailContentCount); return -1; }

	mc= ea->eaMailContents+ amd->amdContentChosen;

	mailSubject= XmTextGetString( amd->amdSubjectWidget );
	to= XmTextGetString( amd->amdToWidget );
	from= XmTextGetString( amd->amdFromWidget );
	cc= XmTextGetString( amd->amdCcWidget );
	bcc= XmTextGetString( amd->amdBccWidget );

	s= mailSubject;
	while( isspace( *s ) )
	    { s++;	}
	if  ( ! *s )
	    {
	    resp= appQuestionRunOkCancelDialog( ea, amd->amdTopWidget,
				    mailOption, amd->amdSubjectMissing,
				    amd->amdMsgOkText, amd->amdCancelText );

	    if  ( resp != AQDrespOK )
		{ rval= -1; goto down;	}

	    goto wrong;
	    }

	s= to;
	while( isspace( *s ) )
	    { s++;	}
	if  ( ! *s )
	    {
	    resp= appQuestionRunOkCancelDialog( ea, amd->amdTopWidget,
				    mailOption, amd->amdToMissing,
				    amd->amdMsgOkText, amd->amdCancelText );

	    if  ( resp != AQDrespOK )
		{ rval= -1; goto down;	}

	    goto wrong;
	    }

	s= from;
	while( isspace( *s ) )
	    { s++;	}
	if  ( ! *s )
	    {
	    resp= appQuestionRunOkCancelDialog( ea, amd->amdTopWidget,
				    mailOption, amd->amdFromMissing,
				    amd->amdMsgOkText, amd->amdCancelText );

	    if  ( resp != AQDrespOK )
		{ rval= -1; goto down;	}

	    goto wrong;
	    }

	sos= sioOutSmtpOpen( amd->amdMailHost,
			    from, to, cc, bcc, mailSubject,
			    mc->mcType, mc->mcSubtype,
			    (void *)amd, appMailComplain );
	if  ( sos )
	    {
	    if  ( (*mc->mcWriteMail)( sos, voiddoc ) )
		{ LDEB(1); rval= -1;	}
	    if  ( sioOutClose( sos ) )
		{ LDEB(1); rval= -1;	}
	    }
	else{ /*XDEB(sos);*/ rval= -1;	}

      down:
	XtUnmanageChild( amd->amdDialog );

      wrong:

	XtFree( mailSubject );
	XtFree( to );
	XtFree( from );
	XtFree( cc );
	XtFree( bcc );
	}

    amd->amdOption= (Widget)0;

    return rval;
    }
