/************************************************************************/
/*  Shortcuts for the most commun menu building actions.		*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<Xm/Xm.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/PushB.h>
#   include	<Xm/CascadeB.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/Separator.h>
#   include	<Xm/Separator.h>

#   include	"appFrame.h"
#   include	<debugon.h>

static Widget appSetMenuItem(	Widget			menu,
				AppMenuItem *		ami,
				void *			target		)
    {
    Widget		rval;

    XmString		labelString;
    XmString		acceleratorString= (XmString)0;

    Arg			al[20];
    int			ac= 0;

    labelString= XmStringCreateLocalized( ami->amiItemText );

    XtSetArg( al[ac], XmNlabelString, labelString ); ac++;

    if  ( ami->amiKey )
	{ XtSetArg( al[ac], XmNaccelerator, ami->amiKey ); ac++; }

    if  ( ami->amiKeyText )
	{
	acceleratorString=
		    XmStringCreateLocalized( ami->amiKeyText );

	XtSetArg( al[ac], XmNacceleratorText, acceleratorString ); ac++;
	}

    rval= XmCreatePushButton( menu, WIDGET_NAME, al, ac );

    XmStringFree( labelString );

    if  ( acceleratorString )
	{ XmStringFree( acceleratorString );	}
    
    if  ( ami->amiCallback )
	{ XtAddCallback( rval, XmNactivateCallback, ami->amiCallback, target );}

    XtManageChild( rval );

    return rval;
    }	    

static Widget appSetMenuSeparator(	Widget			menu,
					AppMenuItem *		ami,
					void *			target )
    {
    Widget		rval;

    Arg			al[20];
    int			ac= 0;

    rval= XmCreateSeparator( menu, WIDGET_NAME, al, ac );

    XtManageChild( rval );

    return rval;
    }	    

static Widget appSetToggleMenuItem(	Widget			menu,
					AppMenuItem *		ami,
					void *			target	)
    {
    Widget		rval;

    XmString		labelString;

    Arg			al[20];
    int			ac= 0;

    labelString= XmStringCreateLocalized( ami->amiItemText );

    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;
    XtSetArg( al[ac], XmNvisibleWhenOff,	True ); ac++;

    if  ( ami->amiItemType == ITEMtyTOGGLE_ON )
	{
#	if XmVersion >= 2000
	XtSetArg( al[ac], XmNset,		XmSET ); ac++;
#	else
	XtSetArg( al[ac], XmNset,		True ); ac++;
#	endif
	}

    rval= XmCreateToggleButton( menu, WIDGET_NAME, al, ac );

    XmStringFree( labelString );

    XtAddCallback( rval, XmNvalueChangedCallback, ami->amiCallback, target );

    XtManageChild( rval );

    return rval;
    }	    

Widget appMakeMenu(	Widget *		pButton,
			EditApplication *	ea,
			Widget			parent,
			char *			itemText,
			int			isHelp,
			AppMenuItem *		ami,
			int			itemCount,
			void *			target		)

    {
    XtResource *	xtr;
    Widget		menu;
    Widget		button;

    int			n;
    int			i;

    XmString		labelString;

    Arg			al[20];
    int			ac= 0;

    xtr= (XtResource *)malloc( 3* itemCount* sizeof(XtResource) );
    if  ( ! xtr )
	{ XDEB(xtr); return (Widget)0;	}

    n= 0;
    for ( i= 0; i < itemCount; i++ )
	{
	if  ( ami[i].amiItemType == ITEMtySEPARATOR )
	    { continue;	}

	xtr[3*n+0].resource_name= ami[i].amiTextResName;
	xtr[3*n+0].resource_class= ami[i].amiTextResName;
	xtr[3*n+0].resource_type= XtRString;
	xtr[3*n+0].resource_size= sizeof(char *);
	xtr[3*n+0].resource_offset= i* sizeof(AppMenuItem)+
					offsetof(AppMenuItem,amiItemText);
	xtr[3*n+0].default_type= XtRString;
	xtr[3*n+0].default_addr= ami[i].amiItemText;

	xtr[3*n+1].resource_name= ami[i].amiKeyResName;
	xtr[3*n+1].resource_class= ami[i].amiKeyResName;
	xtr[3*n+1].resource_type= XtRString;
	xtr[3*n+1].resource_size= sizeof(char *);
	xtr[3*n+1].resource_offset= i* sizeof(AppMenuItem)+
					offsetof(AppMenuItem,amiKey);
	xtr[3*n+1].default_type= XtRString;
	xtr[3*n+1].default_addr= ami[i].amiKey;

	xtr[3*n+2].resource_name= ami[i].amiKeyTextResName;
	xtr[3*n+2].resource_class= ami[i].amiKeyTextResName;
	xtr[3*n+2].resource_type= XtRString;
	xtr[3*n+2].resource_size= sizeof(char *);
	xtr[3*n+2].resource_offset= i* sizeof(AppMenuItem)+
					offsetof(AppMenuItem,amiKeyText);
	xtr[3*n+2].default_type= XtRString;
	xtr[3*n+2].default_addr= ami[i].amiKeyText;

	n++;
	}

    XtGetApplicationResources( ea->eaTopWidget,
					ami, xtr, 3* n, NULL, 0 );

    free( xtr );

    labelString= XmStringCreateLocalized( itemText );

    ac= 0;
    menu= XmCreatePulldownMenu( parent, WIDGET_NAME, al, ac );
    if  ( ! menu )
	{ XDEB(menu); return menu;	}

    ac= 0;
    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;
    XtSetArg( al[ac], XmNsubMenuId,		menu ); ac++;

    button= XmCreateCascadeButton( parent, WIDGET_NAME, al, ac );
    XtManageChild( button );

    if  ( isHelp )
	{
	XtVaSetValues( parent,
			    XmNmenuHelpWidget,	button,
			    NULL );
	}

    XmStringFree( labelString );

    for ( i= 0; i < itemCount; i++, ami++ )
	{
	switch( ami->amiItemType )
	    {
	    case ITEMtyOPTION:
		ami->amiOptionWidget=
				appSetMenuItem( menu, ami, target );
		break;

	    case ITEMtyTOGGLE_OFF:
	    case ITEMtyTOGGLE_ON:
		ami->amiOptionWidget=
				appSetToggleMenuItem( menu, ami, target );
		break;

	    case ITEMtySEPARATOR:
		ami->amiOptionWidget=
				appSetMenuSeparator( menu, ami, target );
		break;
	    }
	}

    *pButton= button; return menu;
    }
