//  UArrow.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UArrow.h"
#include <iostream.h>

UArrow::UArrow  (UFrame* parent_, UArrowStyle style, int arrowSize_) 
	: UComponent(parent_->top, parent_->top->display) 
{
	XGCValues	gcv;
	short 		arrowSize;

	parent = parent_;
	top = parent->top;
	arrowSize = (arrowSize_>2) ? arrowSize_ : 2;
	rectangle.width = arrowSize;
	rectangle.height = arrowSize;
	
	rectangle.x = 0;
	rectangle.y = 0;
	arrowStyle = style;
	window = XCreateSimpleWindow (top->display,
		parent->window, rectangle.x, rectangle.y,
		rectangle.width, rectangle.height,
		0, parent->getBackground().getPixel(), 
		parent->getBackground().getPixel());

	if (rectangle.width<=parent->getFrameSize()*2)
		rectangle.width =  parent->getFrameSize()*2;
	if (rectangle.height<=parent->getFrameSize()*2)
		rectangle.height =  parent->getFrameSize()*2;

	gcv.background = parent->getBackground().getPixel();
	gcv.foreground = parent->getForeground().getPixel();
	fgGC = XCreateGC (top->display, window, 
		GCForeground | GCBackground, &gcv);
	
	setBackground (parent->getBackground());

	placement.margin = 0;

	XMapRaised (top->display, window);
	select (ExposureMask | ButtonPressMask |ButtonReleaseMask| 
		Button1MotionMask | LeaveWindowMask | EnterWindowMask);

	bestSize.width = rectangle.width;
	bestSize.height = rectangle.height;

	// You have to do it if you dont inherit frame
	UTOP->addComponent (this);
	parent->addChild (this);
}

UArrow::~UArrow()
{
	XFreeGC (top->display, fgGC);
	XDestroyWindow (top->display, window);
	UTOP->deleteComponent (this);
	parent->deleteChild (this);
}

void
UArrow::eventDown (UEvent* event)
{
	XRectangle 	rect;

	switch (event->type)
	{
		case UEvent::TIMER:
			break;
		case UEvent::X:
		switch (event->xevent.type)
		{
		case Expose:
			rect.x = event->xevent.xexpose.x;
			rect.y = event->xevent.xexpose.y;
			rect.width = event->xevent.xexpose.width;
			rect.height = event->xevent.xexpose.height;
			redraw (rect.x, rect.y, rect.width, rect.height);
			break;

		case GraphicsExpose:
			rect.x = event->xevent.xgraphicsexpose.x;
			rect.y = event->xevent.xgraphicsexpose.y;
			rect.width = event->xevent.xgraphicsexpose.width;
			rect.height = event->xevent.xgraphicsexpose.height;
			redraw (rect.x, rect.y, rect.width, rect.height);
			break;
		default:
			parent->eventUp (event);
		}
	default:
		break;
	}
}

int
UArrow::isA (UComponent::UType type_)
{
	if (type_ == UComponent::ARROW) return 1;
	return UComponent::isA (type_);
	return 0;
}

void
UArrow::resize (int width, int height)
{
	if (rectangle.width == width 
		&& rectangle.height ==height) return;

	XClearArea (top->display, window, 0, 0, 
		rectangle.width, rectangle.height, False);

	rectangle.width = (width>2)? width : 2;
	rectangle.height = (height>2)? height : 2;
	
	XResizeWindow (top->display, window, 
		rectangle.width, rectangle.height);

	redraw (0, 0, width, height);
	bestSize.width = rectangle.width;
	bestSize.height = rectangle.height;
}

void
UArrow::move (int x, int y)
{
	if (rectangle.x == x && rectangle.y ==y) return;
	rectangle.x = x;
	rectangle.y = y;
	XMoveWindow (top->display, window, rectangle.x, rectangle.y);
}

void
UArrow::redraw (int x, int y, int width, int height)
{
	XPoint		points[3];
	long		centerX;
	long		centerY;
	long		d1, d2;

	if (!isShown(this)) return;
	if (rectangle.width<=1 || rectangle.height<=1) return;

	d1 = (rectangle.width < rectangle.height) ?
		rectangle.width << 2: rectangle.height << 2;

	d2 = d1 >> 1;

	centerX =  (rectangle.width) << 2;
	centerY =  (rectangle.height) << 2;
	
	switch (arrowStyle)
	{
	case BLANK:
		return;
	case LEFT:
		points[0].x = centerX+d2-d1; points[0].y = centerY;
		points[1].x = centerX+d2; points[1].y = centerY-d1;
		points[2].x = centerX+d2; points[2].y = centerY+d1;
		break;
	case RIGHT:
		points[0].x = centerX-d2; points[0].y = centerY+d1;
		points[1].x = centerX-d2; points[1].y = centerY-d1;
		points[2].x = centerX-d2+d1; points[2].y = centerY;
		break;
	case UP:
		points[0].x = centerX-d1; points[0].y = centerY+d2;
		points[1].x = centerX; points[1].y = centerY+d2-d1;
		points[2].x = centerX+d1; points[2].y = centerY+d2;
		break;
	case DOWN:
		// -1 : theoretical constant :)
		points[1].x = centerX-d1; points[1].y = centerY-d2;
		points[2].x = centerX; points[2].y = centerY+d1-d2;
		points[0].x = centerX+d1; points[0].y = centerY-d2;

		break;
	}
	points[0].x = points[0].x >> 3; points[0].y = points[0].y>>3;
	points[1].x = points[1].x >> 3; points[1].y = points[1].y>>3;
	points[2].x = points[2].x >> 3; points[2].y = points[2].y>>3;
	XFillPolygon (top->display, window, fgGC, points, 3, Convex, 
		CoordModeOrigin);
}

void
UArrow::eventUp (UEvent* event)
{
}

void 
UArrow::setBackground (const UColor& color)
{
	background = color;
	XSetWindowBackground (background.getDisplay(), window,
		background.getPixel());

	XClearArea (top->display, window, 0, 0, rectangle.width,
		rectangle.height, True);
}

void 
UArrow::setBackground (const char* color)
{
	background = color;
	setBackground (background);
}

void 
UArrow::setForeground (const UColor& color)
{
	foreground = color;
	XSetForeground (top->display, fgGC, foreground.getPixel());
}

void 
UArrow::setForeground (const char* color)
{
	foreground = color;
	setForeground (foreground);
}

