//  UScrolledList.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UScrolledList.h"
#include "UTextList.h"
#include "UScroll.h"

UScrolledList::UScrolledList (UFrame* parent_, int frameSize_) :
	UFrame (parent_, frameSize_)
{
	UColor	textBack (top->display);
	bestSize.width=40;
	bestSize.height=120;

	textBack.assign (0xffff, 0xffff, 0xffff);

	component[LIST] = new UTextList (this);
	component[VSCROLL] = new UScroll (this, UScroll::VERTICAL);

	component[LIST]->setBackground (textBack); 
	component[LIST]->place (frameSize, frameSize, 20+frameSize, frameSize);
	component[VSCROLL]->place (-20-frameSize, frameSize, frameSize, frameSize);
}

UScrolledList::~UScrolledList ()
{
	// autodelete
}

void
UScrolledList::eventUp (UEvent* event)
{
	switch (event->type)
	{
	case UEvent::SCROLL_RANGE_VERTICAL:
		if (event->client==component[LIST])
		{  
			((UScroll*)component[VSCROLL])->scroll (
				event->value, event->step,
				event->page, event->max);
		}
		break;
	case UEvent::CARDINAL:
		if (event->client==component[VSCROLL])
		{
			((UTextList*)component[LIST])->scrollVertical (
				event->cardinal);
		}
		break;
	default:
		event->client=this;
		parent->eventUp (event);
	}
	return;
}

void
UScrolledList::replace (const AStringList& str)
{
	((UTextList*)component[LIST])->replace (str);
}

void
UScrolledList::add (const char* str, int pos_)
{
	((UTextList*)component[LIST])->add (str, pos_);
}

void
UScrolledList::deleteAll ()
{
	((UTextList*)component[LIST])->deleteAll ();
}

void
UScrolledList::unselect ()
{
	((UTextList*)component[LIST])->unselect ();
}

