//  UShell.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UShell.h"
#include <strings.h>
#include <iostream.h>

#define INFINITE 32767

UShell::UShell (UTop* top_, const char* name_, int frameSize_) 
	: UFrame (top_, frameSize_)
{
	transient = 0;
	setupShell (top_, name_, frameSize_);
}

UShell::UShell (UTop* top_, UComponent* transient_, int frameSize_)
	: UFrame (top_, frameSize_)
{
	XSetWindowAttributes	winattr;

	setupShell (top_, 0, frameSize_);

	transient = transient_;
	if (transient)
	{
	
		// Popup menu
		if (!transient->isA (SHELL) || transient->isA(POPUP))
		{
			winattr.override_redirect = True;
			winattr.save_under = True;
			XChangeWindowAttributes (top->display, window, 
				CWOverrideRedirect | CWSaveUnder, &winattr);
		}

		XSetTransientForHint(top->display, window, 
			transient->window);
	}
}

void
UShell::setupShell (UTop* top_, const char* name_, int frameSize_)
{
	XGCValues	gcv;
	Atom		wmDeleteWindow;
	XWMHints	wmHints;
	XClassHint	classHints;
	char*		nameC;

	top = top_;
	transient = 0;
	rectangle = UTOP->rectangle;
	minimumWidth = 10;
	minimumHeight = 10;

	window = XCreateSimpleWindow (UTOP->display,
			UTOP->root,
			rectangle.x, rectangle.y, 
			rectangle.width, rectangle.height,
			UTOP->border, 
			// border + background
			UTOP->foreground, UTOP->background);
	name = (name_==0) ? "UGui" : name_;
	title = name;
	iconTitle = name;
	shown = 0;
	UTOP->addComponent (this);
	background.assign (0xafaf, 0xb4b4, 0x9f9f);
	foreground.assign(0,0,0) ;

	gcv.foreground = BlackPixel (top->display, top->screen);
	gcv.background = BlackPixel (top->display, top->screen);
	lightGC = XCreateGC (top->display, window, 
		GCForeground | GCBackground, &gcv);
	darkGC = XCreateGC (top->display, window, 
		GCForeground | GCBackground, &gcv);
	
	select (ExposureMask | SubstructureNotifyMask 
		| KeyPressMask | KeyReleaseMask | KeymapStateMask);

	setBackground (background);
	setForeground (foreground);
	select (FocusChangeMask);
	focusWindow=None;
	frameStyle = OUT;
	rectangle.x = INFINITE;
	rectangle.y = INFINITE;

	nameC = new char [strlen ((const char*) name) + 1];
	strcpy (nameC, (const char*) name);
	classHints.res_name =  nameC;
	classHints.res_class = nameC;

	wmHints.initial_state = NormalState;
	wmHints.input = True;
	wmHints.flags = StateHint | InputHint;

	XSetWMProperties (UTOP->display, window, 
		0, 0,
		0, 0, // argv, argc,
		0, &wmHints, &classHints);

	wmDeleteWindow = XInternAtom (UTOP->display, "WM_DELETE_WINDOW", True);
	XSetWMProtocols (UTOP->display, window, &wmDeleteWindow, 1);

	XStoreName (top->display, window, nameC);
	delete nameC;


}

UShell::~UShell ()
{
	if (shown) hide ();
}


void
UShell::setTitle (const char* title_)
{
	const char*	windowName;
	const char*	iconName;
	char*		windowNameC;
	char*		iconNameC;
	XTextProperty	propertyIconName;
	XTextProperty	propertyWindowName;

	if (title_!=0)
	{
		title = title_;
		iconTitle = title_;
	}
	windowName = (const char*) title;
	iconName = (const char*) iconTitle;

	windowNameC = new char[strlen (windowName) + 1];
	strcpy (windowNameC, windowName);
	XStoreName (top->display, window, windowNameC);

	iconNameC = new char[strlen (iconName) + 1];
	strcpy (iconNameC, iconName);
	
	if (XStringListToTextProperty (&windowNameC, 1, 
			&propertyWindowName)!=0 &&
		XStringListToTextProperty (&iconNameC, 1, 
			&propertyIconName)!=0)
	{
		XSetWMProperties (UTOP->display, window, 
			&propertyWindowName, &propertyIconName,
			0, 0, // argv, argc,
			0, 0, 0);
		XFree (propertyWindowName.value);
		XFree (propertyIconName.value);
	}

	delete windowNameC;
	delete iconNameC;

}

void
UShell::show ()
{
	XSizeHints	sizeHints;

	UTOP->addShell (this);
	shown = 1;

	sizeHints.width = rectangle.width;
	sizeHints.height = rectangle.height;
	sizeHints.min_width = minimumWidth;
	sizeHints.min_height = minimumHeight;
	sizeHints.flags = PSize | PMinSize;
	
	if (rectangle.x != INFINITE && rectangle.y != INFINITE)
	{
		sizeHints.x = rectangle.x;
		sizeHints.y = rectangle.y;
		sizeHints.flags |= PPosition;
	}

	XSetWMProperties (UTOP->display, window, 
		0, 0,
		0, 0, // argv, argc,
		&sizeHints, 0, 0);

	select (ExposureMask | StructureNotifyMask | SubstructureNotifyMask);

	XResizeWindow (top->display, window, 
		rectangle.width, rectangle.height);

	XMapRaised (UTOP->display, window);
}

void
UShell::hide ()
{
	XUnmapWindow (UTOP->display, window);
	UTOP->deleteShell (this);
	shown = 0;
}

int
UShell::isShown(UComponent* cmp)
{
	return shown;
}

void
UShell::eventDown (UEvent* event)
{
	UComponent*	comp;
	switch (event->type)
	{
	case UEvent::TIMER:
		break;
	case UEvent::X:
		switch (event->xevent.type)
		{
			// It is alway we who get the event...
		case KeyPress:
		case KeyRelease:
			comp = UTOP->findComponent (focusWindow);
			if (comp!=0)
			{
				comp->eventDown (event);
			}
			return;
		case ConfigureNotify:
			if (event->xevent.xconfigure.window!= window)
			{
				return;
			}
			rectangle.x = event->xevent.xconfigure.x;
			rectangle.y = event->xevent.xconfigure.y;

			// Xceed thinks that even if size is same we need
			// to redraw everything. Should it not send an
			// expose event? Bug1 in Xceed.
#if 0
			if (event->xevent.xconfigure.width == rectangle.width &&
				event->xevent.xconfigure.height == rectangle.height)
			{
				return;
			}
#endif
			resize (event->xevent.xconfigure.width,
				event->xevent.xconfigure.height);
			return;
		case ResizeRequest:
			return;
		case ClientMessage:
			if (event->xevent.xclient.message_type 
				== UTOP->wmProtocols
			    && event->xevent.xclient.data.l[0] 
				== UTOP->wmDeleteWindow
			    && event->xevent.xclient.format == 32)
			{
				quit ();
				return;
			}
			return;
		case DestroyNotify:
			return;

			// If you send a XSetFocus then instead of 
			// Lose focusout and focusin we receive another
			// focusin : Xceed bug #2 
		case FocusIn:
			hasFocus=1;
			comp = UTOP->findComponent (focusWindow);
			// We want to make this guy believe he has it.
			if (comp!=0) comp->eventDown (event);
			return;

		case FocusOut:
			hasFocus=0;
			comp = UTOP->findComponent (focusWindow);
			if (comp!=0) comp->eventDown (event);
			return;
		default:
			UFrame::eventDown(event);
		}
	default: break;
	}
}

void
UShell::eventUp (UEvent* event)
{
	UEvent		evs;
	UComponent*	comp;
	switch (event->type)
	{
	case UEvent::KEY_FOCUS:
		if (focusWindow!=event->window)
		{
			evs.type=UEvent::X;
			evs.xevent.type=FocusOut;
			evs.xevent.xany.window = window;
			comp = UTOP->findComponent (focusWindow);
			if (comp!=0) 
			{
				comp->eventDown (&evs);
			}
		}

		focusWindow = event->window;
		if (!shown) return;

		if (!hasFocus)
		{
			XSetInputFocus (top->display, window,
				RevertToPointerRoot, CurrentTime);
			return;
		}
		evs.type=UEvent::X;
		evs.xevent.type=FocusIn;
		evs.xevent.xany.window = window;
		comp = UTOP->findComponent (focusWindow);
		if (comp!=0) 
		{
			comp->eventDown (&evs);
		}
		break;
	default:
		break;
	}
}


int
UShell::isA (UComponent::UType type_)
{
	if (type_ == UComponent::SHELL) return 1;
	return UFrame::isA (type_);
}


int
UShell::isChild (Window w)
{
	if (window==w) return 1;
	return (UFrame::isChild(w));
}

void
UShell::quit ()
{
	delete this;
}

int
UShell::filterKeyEvent (XEvent* event)
{
	return 0;
}
