//  UTextMenu.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UTextMenu.h"

UTextMenu::UTextMenu (UFrame* parent_, 
	const char* name_, const char* text_,
	UMenu::UMenuLeft left_,
	UMenu::UMenuArrow arrow_,
	UTextLine::UAlign align_) :

	UTextLabel (parent_, text_, align_),
	menu (this, left_, arrow_)
{
	componentName = name_;
	select (ButtonPressMask | ButtonReleaseMask);
	leftMargin = 16;
	rightMargin = 16;
	setInsets ((menu.getLeft() == UMenu::NO_LEFT) ? 0 : leftMargin, 
		(menu.getArrow() == UMenu::NO_ARROW) ? 0 : rightMargin);
}

UTextMenu::~UTextMenu ()
{
}

int
UTextMenu::isA (UComponent::UType type_)
{
	if (type_==UComponent::TEXT_MENU) return 1;
	return (UTextLabel::isA (type_));
}

void
UTextMenu::redraw (int x, int y, int width, int height)
{
	if (!isShown(this)) return;
	UTextLabel::redraw (x, y, width, height);
	if (lineCount==0) return;
	drawArrow (menu.getArrow(),line[0]->drawType);
	drawLeft (menu.getLeft(), menu.isChecked(),line[0]->drawType);
}

void
UTextMenu::drawArrow (UMenu::UMenuArrow arrow_, UTextLine::UDrawType dt)
{
	long		rectSize;
	long		half;
	long		qrtr;
	long		centerX;
	long		centerY;
	XPoint		points[3];

	qrtr = (rightMargin > rectangle.height)? rectangle.height : rightMargin;
	if (qrtr > 10) qrtr=10;
	half = qrtr << 1; 
	rectSize = half << 1;
	centerY = (rectangle.height/2) << 2;
	centerX = (rectangle.width-rightMargin/2+1) << 2;

	switch (arrow_)
	{
	case UMenu::ARROW_BLANK:
		if (dt == UTextLine::REVERSE)
		{
			XFillRectangle (top->display, window, rvfGC,
				rectangle.width-alignEast, 0, 
				alignEast, rectangle.height);
		}
		else
		{
			XClearArea (top->display, window, 
				rectangle.width-alignEast, 0, 
				alignEast, rectangle.height, False);
		}
		return;
	case UMenu::RIGHT:
		points[0].x = centerX-qrtr; points[0].y = centerY+half;
		points[1].x = centerX-qrtr; points[1].y = centerY-half;
		points[2].x = centerX-qrtr+half; points[2].y = centerY;
		break;

	case UMenu::DOWN:
		points[1].x = centerX-half; points[1].y = centerY-qrtr;
		points[2].x = centerX; points[2].y = centerY+half-qrtr;
		points[0].x = centerX+half; points[0].y = centerY-qrtr;
		break;
	default:
		return;
	}
	points[0].x = points[0].x >> 2; points[0].y = points[0].y>>2;
	points[1].x = points[1].x >> 2; points[1].y = points[1].y>>2;
	points[2].x = points[2].x >> 2; points[2].y = points[2].y>>2;
	switch (dt)
	{
	case UTextLine::NORMAL:
		XFillPolygon (top->display, window, fgGC, points, 3, Convex, 
			CoordModeOrigin);
		break;
	case UTextLine::NORMAL_FILL:
		XClearArea (top->display, window,
			rectangle.width-alignEast, 0, 
			alignEast, rectangle.height, False);
		XFillPolygon (top->display, window, fgGC, points, 3, Convex, 
			CoordModeOrigin);
		break;
	case UTextLine::REVERSE:
		XFillRectangle (top->display, window, rvfGC,
			rectangle.width-alignEast, 0, 
			alignEast, rectangle.height);
		XFillPolygon (top->display, window, rvGC, points, 3, Convex, 
			CoordModeOrigin);
		break;
	default:
		break;
	}
}

void
UTextMenu::drawLeft (UMenu::UMenuLeft left_, int checked_, UTextLine::UDrawType dt)
{
	long		rectSize;
	long		half;
	long		centerX;
	long		centerY;
	XSegment	segments[4];

	if (checked_==0)
	{
		if (dt == UTextLine::REVERSE)
		{
			if (alignWest>0)
			XFillRectangle (top->display, window, rvfGC,
				0, 0, alignWest, rectangle.height);
		}
		else
		{
			if (alignWest>0)
			XClearArea (top->display, window, 0, 0, 
				alignWest, rectangle.height, False);
		}
		return;
	}

	if (left_ != UMenu::CHECK) return;

	half = (leftMargin > rectangle.height)? rectangle.height : leftMargin;
	half <<= 1;
	rectSize = half << 3;
	centerY = (rectangle.height/2) << 3;
	centerX = (leftMargin/2+1) << 3;

	segments[0].x1 = centerX-half+8; segments[0].y1 = centerY-16;
	segments[0].x2 = centerX-half+8; segments[0].y2 = centerY+half-16;
	segments[1].x1 = centerX-half; segments[1].y1 = centerY-16;
	segments[1].x2 = centerX-half; segments[1].y2 = centerY+half;

	segments[2].x1 = centerX-half; segments[2].y1 = centerY+half;
	segments[2].x2 = centerX+half; segments[2].y2 = centerY-half;

	segments[0].x1=segments[0].x1 >> 3; segments[0].y1 = segments[0].y1>>3;
	segments[0].x2=segments[0].x2 >> 3; segments[0].y2 = segments[0].y2>>3;
	segments[1].x1=segments[1].x1 >> 3; segments[1].y1 = segments[1].y1>>3;
	segments[1].x2=segments[1].x2 >> 3; segments[1].y2 = segments[1].y2>>3;

	segments[2].x1=segments[2].x1 >> 3; segments[2].y1 = segments[2].y1>>3;
	segments[2].x2=segments[2].x2 >> 3; segments[2].y2 = segments[2].y2>>3;

	switch (dt)
	{
	case UTextLine::NORMAL:
		XDrawSegments (top->display, window, fgGC, segments, 3);
		break;
	case UTextLine::NORMAL_FILL:
		XClearArea (top->display, window,
			0, 0, alignWest, rectangle.height, False);
		XDrawSegments (top->display, window, fgGC, segments, 3);
		break;
	case UTextLine::REVERSE:
		XFillRectangle (top->display, window, rvfGC,
			0, 0, alignWest, rectangle.height);
		XDrawSegments (top->display, window, rvGC, segments, 3); 
		break;
	default:
		break;
	}
}

void
UTextMenu::eventUp (UEvent* event)
{
	if (event->client != &menu)
	{
		UTextLabel::eventUp (event);
		return;
	}
	switch (event->type)
	{
	case UEvent::HIGHLIGHT:
		highlight();
		break;
	case UEvent::UNHIGHLIGHT:
		unhighlight();
		break;
	case UEvent::CHECK:
		check();
		break;
	case UEvent::UNCHECK:
		uncheck();
		break;
	default:
		break;
	}
}

//
// If you set background,fg in this mode you can set the highlight bg,fg
//
void
UTextMenu::highlight()
{
	drawArrow (menu.getArrow(),UTextLine::REVERSE);
	drawLeft (menu.getLeft(), menu.isChecked(), UTextLine::REVERSE);
	selectLine (0);
}

void
UTextMenu::unhighlight()
{
	drawArrow (menu.getArrow(),UTextLine::NORMAL_FILL);
	drawLeft (menu.getLeft(), menu.isChecked(), UTextLine::NORMAL_FILL);
	unselectLine (0);
}

void
UTextMenu::check()
{
	if (lineCount==0) return;
	drawLeft (UMenu::CHECK, 1, line[0]->drawType);
}

void
UTextMenu::uncheck()
{
	if (lineCount==0) return;
	drawLeft (UMenu::CHECK, 0, line[0]->drawType);
}

const char*
UTextMenu::getName()
{
	return ((const char*) componentName);
}

void
UTextMenu::setName (const char* name)
{
	componentName = name;
}
