//  UFontFreeType.h version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __ufont_free_type__
#define __ufont_free_type__

#include "UFont.h"
#include "UFreeType.h"
#include "UCommon.h"
#include "UPixmapCache.h"

//
// This suposed to cache the freetype font instances.
// This is undependent of Display
// This handles one instance of the FreeType Font
//
#ifndef FREETYPE
typedef int TT_Instance;
typedef int TT_Glyph;
typedef int TT_Raster_Map;
typedef int TT_Glyph_Metrics;
typedef int TT_Instance_Metrics;
#define UTT_LOAD_FLAGS 0
#else
#define UTT_LOAD_FLAGS TTLOAD_SCALE_GLYPH|TTLOAD_HINT_GLYPH
#endif

class UFreeTypeGlyph
{
public:
	enum UStatus		{OK, FT_OK=1, FT_BIT_OK=2, FT_PIXMAP_OK=4, 
				ERROR=8};
				UFreeTypeGlyph (TT_Face* face, 
					TT_Instance instance, int index,
					int ascentIn, int descentIn,
					int flags=UTT_LOAD_FLAGS);
				~UFreeTypeGlyph ();
	int			getXPixmap (Display *displayIn, 
					Pixmap* pixmapOut);
	
	UStatus			status;
	int			uAscent;
	int			uDescent;
	Pixmap			xPixmap;
	Display*		xDisplay;
	TT_Glyph		glyph;
	TT_Raster_Map		ttBitmap;
	TT_Glyph_Metrics	metrics;
};

class UFontFreeTypeCache : public UFontCache
{
public:				// name and font will be mine
				UFontFreeTypeCache::UFontFreeTypeCache (
					UFreeTypeFace* freeTypeFaceIn,
					int pixelIn,
					int resolutionIn);
				~UFontFreeTypeCache ();
	//XFontStruct*		font;
	virtual int		getDirection();
	virtual int		getWidth (const XChar2b& char2B);
	virtual int		getAscent ();
	virtual int		getDescent ();
	virtual void 		drawStringBase (Display* dsp, 
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache *pmc);

	virtual void 		drawImageString (Display* dsp, 
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache *pmc);
	virtual void 		drawString (Display* dsp,
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache *pmc);
	virtual int		getWidth();

	int			loadGlyph (const UCS2 ucs2);
	int			inited;
private:
	UFreeTypeFace*		freeTypeFace;
	TT_Face*		face;
	TT_Instance		instance;
	TT_Instance_Metrics	metrics;
	int			resolution;
	int			uPointSize;
	UCS2*			indirect[256];
	UFreeTypeGlyph**	glyphs;
	int			glyphArraySize;
	int			glyphSize;
};

//
// Currently We silently ignore Slant, Weight, Spacing
//
class UFontFreeType : public UFont
{
public:
				// We need to reorganize things here to
				// make freeTypeIn const. Currently
				// UFontFreeType is used in the copy  as well..
				UFontFreeType (UFontFreeType& freeTypeIn); 
				UFontFreeType (UFreeType* freeTypeIn, 
					Display *displayIn, int screenIn);

				// For fonts that use printer.
				UFontFreeType (UFreeType* freeTypeIn, 
					const int resolutionIn);

	virtual			~UFontFreeType ();

	virtual void		setPixel (const int pixelIn);
	virtual void		setWeight (const UWeight weightIn);
	virtual	void		setSlant (const USlant slantIn);

	virtual void		setWeight (const char* weightIn);
	virtual	void		setSlant (const char* slantIn);

	virtual void		setAvgWidth (const char* avgWidthIn);
	virtual	void		setAddStyle (const char* addStyleIn);

	inline const int	isNew() const {return fontChanged;}
	virtual UFontCache* 	getFont (const UCS2* text=0, 
				const int from=0, int* to=0);
	virtual int		isA (UFontType ftype);
	const UFontMapStruct* 	getFontMapStruct (const UCS2 input);
private:
	char*			getCacheName (const char *name,
					const int pixelIn, 
					const int resolutionIn,
					const int weightIn,
					const int slantIn); 
	void			clear ();
	char*			cacheName;
	UFontFreeTypeCache*	font;
	int			fontChanged;		
	int			resolution;
	Display*		display;
	int			screen;
};

#endif /* __ufont_free_type__ */
