/*$Id: bm_posy.cc,v 15.14 1999/10/20 08:53:59 al Exp $ -*- C++ -*-
 * behavioral modeling - posynomial (non-integer powers)
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_POSY::EVAL_BM_POSY(int c);
//		EVAL_BM_POSY::EVAL_BM_POSY(const EVAL_BM_POSY& p);
//	void	EVAL_BM_POSY::parse(CS& cmd);
// 	void	EVAL_BM_POSY::print(int)const;
//	void	EVAL_BM_POSY::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
const double _default_max(BIGBIG);
const double _default_min(-BIGBIG);
const bool   _default_abs(false);
/*--------------------------------------------------------------------------*/
EVAL_BM_POSY::EVAL_BM_POSY(int c)
  :EVAL_BM_ACTION_BASE(c),
   _max(_default_max),
   _min(_default_min),
   _abs(_default_abs)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_POSY::EVAL_BM_POSY(const EVAL_BM_POSY& p)
  :EVAL_BM_ACTION_BASE(p),
   _max(p._max),
   _min(p._min),
   _abs(p._abs),
   _table(p._table)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_POSY::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    for (;;){
      double key  =NOT_VALID;
      double value=NOT_VALID;
      cmd >> value >> key;
      if (cmd.stuck()){
	break;
      }
      PAIR<double,double> p(key,value);
      _table.push_back(p);
    }
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    cmd.get("MIn", &_min);
    cmd.get("MAx", &_max);
    cmd.get("Abs", &_abs);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_POSY::print(OMSTREAM where)const
{
  untested();
  where << "  " << name() << '(';
  for (std::vector<PAIR<double,double> >::const_iterator
	 p = _table.begin();  p != _table.end();  ++p){
    where << "  " << p->Value() << ',' << p->Key();
  }
  where << ')';
  print_base(where);
  if (_min != _default_min) {where << "  min=" << _min;}
  if (_max != _default_max) {where << "  max=" << _max;}
  if (_abs != _default_abs) {where << "  abs=" << _abs;}
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_POSY::tr_eval(COMPONENT* d)const
{
  double x = ioffset(d->y0.x);
  double f0 = 0.;
  double f1 = 0.;

  if (x > 0){
    for (std::vector<PAIR<double,double> >::const_iterator
	   p = _table.begin();  p != _table.end();  ++p){
      double coeff = p->Value() * pow(x, p->Key()-1);
      f1 += coeff * p->Key();
      f0 += coeff * x;
    }
  }

  if (_abs && f0 < 0){
    untested();
    f0 = -f0;
    f1 = -f1;
  }

  {if (f0 > _max){
    untested();
    f0 = _max;
    f1 = 0;
  }else if (f0 < _min){
    untested();
    f0 = _min;
    f1 = 0;
  }}

  d->y0 = FPOLY1(x, f0, f1);
  tr_final_adjust(&(d->y0));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
