/*$Id: e_elemnt.h,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * branch structure type definitions
 * device types (enumeration type?)
 */
#ifndef E_ELEMNT_H
#define E_ELEMNT_H
#include "l_denoise.h"
#include "e_compon.h"
/*--------------------------------------------------------------------------*/
class ELEMENT : public COMPONENT {
  friend class DEV_CCCS;
  friend class DEV_CCVS;
protected:
  explicit ELEMENT()
	:COMPONENT(), _loaditer(0), loss(0.), method_u(meUNKNOWN) {}
  explicit ELEMENT(const ELEMENT& p)
	:COMPONENT(p), _loaditer(0), loss(p.loss), method_u(p.method_u) {}
  void	   store_values()		{y2=y1; y1=y0;}
  //void   reject_values()		{untested(); y0 = y1;}
  
protected:
  virtual const char* dev_type()const = 0;

protected:				// e_elem2.cc
  bool			skip_dev_type(CS&);
  COMPONENT_COMMON*	parse_func_type(CS&);
  virtual void		parse_more_nodes(CS&, int);
private: // override virtual
  void	   parse(CS&);
  void	   print(OMSTREAM,int)const;
  bool	   tr_needs_eval()	{return !constant();}
  void	   tr_queue_eval()	{if(tr_needs_eval()){q_eval();}}
protected:
  virtual int numnodes()const	{return 2;}
  
private:				// inline, below
  double   dampdiff(double&, const double&, bool);
protected:
  void	   tr_load_loss();
  void	   tr_unload_loss(); // not used, not implemented
  void	   ac_load_loss();

  void	   tr_load_source();
  void	   tr_unload_source();
  void	   ac_load_source();

  void	   tr_load_passive();
  void	   tr_unload_passive();
  void	   ac_load_passive();

  void	   tr_load_active();
  void	   tr_unload_active();
  void	   ac_load_active();
protected:				// e_elem3.cc
  double   tr_amps()const;
  double   tr_outvolts()const;
  COMPLEX  ac_outvolts()const;
  double   probe_tr_num(const std::string&)const;
  XPROBE   probe_ac_ext(const std::string&)const;

  virtual  double  tr_involts()const = 0;
  virtual  COMPLEX ac_involts()const = 0;
private:
  int      _loaditer;	/* load iteration number		*/
protected:
  CPOLY1   m1;		/* matrix parameters, 1 fill ago	*/
  CPOLY1   m0;		/* matrix parameters, new		*/
  double   loss;	/* fixed shunt conductance (should be COMMON)	*/
  COMPLEX  acg;		/* ac admittance matrix values   	*/
  method_t method_u;	/* method to use for this part per user */
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
inline double ELEMENT::dampdiff(double& v0, const double& v1, bool damp)
{
  //double diff = v0 - v1;
  double diff = dn_diff(v0, v1);
  if (STATUS::iter[iSTEP] > 1 && damp){
    diff *= SIM::damp;
    v0 = v1 + diff;
  }
  return (SIM::inc_mode) ? diff : v0;
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_load_loss()
{
  if (!SIM::inc_mode  &&  loss != 0.){
    aa.load_symmetric(n[OUT1].m, n[OUT2].m, loss);
  }
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::ac_load_loss(){
  acx.load_symmetric(n[OUT1].m, n[OUT2].m, loss);
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_load_source()
{
#ifndef NDEBUG
  assert(_loaditer != STATUS::iter[iTOTAL]);
  _loaditer = STATUS::iter[iTOTAL];
#endif

  double dc0 = dampdiff(m0.c0, m1.c0, true);
  if (dc0 != 0.){
    if (n[OUT2].m != 0){
      n[OUT2].i() += dc0;
    }
    if (n[OUT1].m != 0){
      n[OUT1].i() -= dc0;
    }
  }
  m1 = m0;
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_unload_source()
{
  m0.c0 = m0.c1 = 0.;
  {if (SIM::inc_mode){
    SIM::inc_mode = tsBAD;
  }else{
    untested();
  }}
  tr_load_source();
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::ac_load_source()
{
  if (n[OUT2].m != 0){
    n[OUT2].iac() += acg;
  }
  {if (n[OUT1].m != 0){
    n[OUT1].iac() -= acg;
  }else{
    untested();
  }}
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_load_passive()
{
  double df1 = dampdiff(m0.c1, m1.c1, true);
  if (df1 != 0.){
    aa.load_symmetric(n[OUT1].m, n[OUT2].m, df1);
  }
  tr_load_source();
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_unload_passive()
{
  m0.c0 = m0.c1 = 0.;
  if (SIM::inc_mode){
    SIM::inc_mode = tsBAD;
  }
  tr_load_passive();
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::ac_load_passive()
{
  acx.load_symmetric(n[OUT1].m, n[OUT2].m, acg);
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_load_active()
{
  double df1 = dampdiff(m0.c1, m1.c1, true);
  if (df1 != 0.){
    aa.load_asymmetric(n[OUT1].m, n[OUT2].m, n[IN1].m, n[IN2].m, df1);
  }
  tr_load_source();
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::tr_unload_active()
{
  m0.c0 = m0.c1 = 0.;
  {if (SIM::inc_mode){
    SIM::inc_mode = tsBAD;
  }else{
    untested();
  }}
  tr_load_active();
}
/*--------------------------------------------------------------------------*/
inline void ELEMENT::ac_load_active()
{
  acx.load_asymmetric(n[OUT1].m, n[OUT2].m, n[IN1].m, n[IN2].m, acg);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
