// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CaseStatementAlternative.cc,v 1.2 1999/03/09 20:53:14 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_CaseStatementAlternative.hh"
#include "IIR_SequentialStatement.hh"
#include "IIR_SequentialStatementList.hh"


IIRScram_CaseStatementAlternative::~IIRScram_CaseStatementAlternative() {}


void
IIRScram_CaseStatementAlternative::_publish_cc_decl_for_loop_iterator() {
  sequence_of_statements._publish_cc_decl_for_loop_iterator();
}


void 
IIRScram_CaseStatementAlternative::
_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  sequence_of_statements._build_wait_list(list);
}


void 
IIRScram_CaseStatementAlternative::
_get_list_of_input_signals(set<IIR_Declaration>* list) {
  sequence_of_statements._get_list_of_input_signals(list);
}


IIR_Boolean 
IIRScram_CaseStatementAlternative::
_type_check_return_statements( set<IIR_TypeDefinition> *context_set, 
			       IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval = FALSE;

  retval = IIR_SequentialStatement::
    _type_check_return_statements(context_set,
				  &sequence_of_statements,
				  subprogram_decl );
  return retval;
}


void 
IIRScram_CaseStatementAlternative::
_get_signal_source_info(set<IIR_Declaration>*siginfo) {
  sequence_of_statements._get_signal_source_info(siginfo);
}


void
IIRScram_CaseStatementAlternative::_clone(IIR* cl) {
  IIR_CaseStatementAlternative *clone = (IIR_CaseStatementAlternative*)cl;
  IIR::_clone(clone);

  IIR_SequentialStatement *seqclone, *stmt = sequence_of_statements.first();
  while (stmt != NULL) {
    seqclone = (IIR_SequentialStatement*)stmt->_clone();
    clone->sequence_of_statements.append(seqclone);
    stmt = sequence_of_statements.successor(stmt);
  }
}


IIR*
IIRScram_CaseStatementAlternative::_clone() {
  _report_undefined_scram_fn("IIR *_clone()");
  return NULL;
}
