#ifndef ACCESSTYPE_HH
#define ACCESSTYPE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------
#include "VHDLType.hh"
#include "Block.hh"

class VHDLKernelBase;
class AccessType : public VHDLType {
public:
  // Required for alias initialization
  AccessType(bool, const AccessType&);
  AccessType() : VHDLType(false) {};

  virtual VHDLType&  all();

  void addValueToListForDeletion();

  virtual void setPointer(VHDLType*);
  virtual VHDLType* getPointer() const;
  virtual void resetPointer();

  virtual Type get_kind() const;
  virtual void print(ostream& = cout) const;

  virtual ObjectBase* getObject() const;
  virtual ObjectBase::ObjectType getKind() const;

  virtual VHDLType* clone() const;
  virtual VHDLType& operator = (const VHDLType& val);

  bool operator==(const VHDLType&) const;

  virtual void deallocate();
  static Block accessedObjectList;
};

//extern void assignVariable(VHDLType& dest, const VHDLType& src, 
//			   const ArrayInfo* dinfo, const ArrayInfo* sinfo); 
extern int savantdeallocate(VHDLKernelBase*, AccessType& );
extern EnumerationType savantEqual(const AccessType&, const AccessType&);
extern EnumerationType savantNotEqual(const AccessType&, const AccessType&);
#endif
