#ifndef SString_CC
#define SString_CC
//---------------------------------------------------------------------------
// Copyright (c) 1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: SString.cc,v 1.5 1999/03/09 22:52:09 dmartin Exp $
//---------------------------------------------------------------------------


template <int l, ArrayDirn_t d, int r>
inline 
ostream& operator<<(ostream& os, const _savant_string<l, d, r> &b) {
  int temp = b.length();
  for (register int i=0; i< temp; i++) {
    os << b.val[i];
  }
  return os;
}


template <int l, ArrayDirn_t d, int r>
inline  
_savant_string< l, d,  r>::_savant_string(const char* s) : StringBase(l, d, r) {
    if (s != NULL) {
#ifdef DEVELOPER_ASSERTIONS
      if (strlen(s) != (unsigned int)length()) {
	cerr << "Attempting to initialize a _savant_string" 
	     << bounds << " with a " << strlen(s) << " length string.\n";
	abort();
      }
#endif
      val = new char[length()];
      for (register int i = 0; i < length(); i++) {
	val[i] = s[i];
      }
    }
    else {
      val = NULL;
    }
}


template <int l, ArrayDirn_t d, int r>
inline
_savant_string<l, d, r>::_savant_string(const _savant_string<l,d,r>& s) : StringBase(l, d, r) {
    register int mylen = length();
    if (mylen > 1 ||
	mylen == 1 && s.bounds.left() != 0) {
      val = new char[mylen];
      memcpy(val, s.val, mylen);
    }
    else {
      val = NULL;
    }
  }


template <int l, ArrayDirn_t d, int r>
inline
_savant_string<l, d, r>& _savant_string<l, d, r>::operator=(const char* s) {
    if (val != NULL) {
      delete [] val;
    }
    if (s != NULL) {
      val = new char[length()];
      memcpy(val, s, length());
    }
    else {
      val = NULL;
    }
    return *this;
  }


template <int l, ArrayDirn_t d, int r>
inline
 _savant_string<l, d, r>&  _savant_string<l, d, r>::operator=(_savant_string<l, d, r>& s) {
    if (val != NULL) {
      delete [] val;
    }
    if (s.val != NULL) {
      val = new char[length()];
      memcpy(val, s.val, length());
    }
    else {
      val = NULL;
    }
    return *this;
  }


template <int l, ArrayDirn_t d, int r>
inline
bool _savant_string<l, d, r>::operator==(char* s) const {
    register unsigned int mylen = length();
    if(mylen != strlen(s)) {
      return false;
    }
    if (memcmp(val, s, mylen) == 0) {
      return true;
    }
    return false;
  }


template <int l, ArrayDirn_t d, int r>
inline
bool _savant_string<l, d, r>::operator==(_savant_string& s) const{
    if (s.length() == length()) {
      if (memcmp(val, s.val, length()) == 0) {
	return true;
      }
    }
    return false;
  }


template <int l, ArrayDirn_t d, int r>
inline
bool _savant_string<l, d, r>::operator!=(const VHDLData& d) const {
    bool retval = false;

    _savant_string str = *(_savant_string*)&d;
    if (length() == str.length()) {
      for (register int i = 0; i < length(); i++) {
	if (val[i] != str.val[i]) {
	  retval = true;
	  break;
	}
      }
    }
    return retval;
  }


template <int l, ArrayDirn_t d, int r>
inline
void _savant_string<l, d, r>::print(ostream& os ) const { 
  for (register int i = 0; i < length(); i++) {
      os << val[i];
  }
}

#endif
