//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VHDLKERNEL_HH
#define VHDLKERNEL_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1997 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: VHDLKernel.hh,v 1.118 1999/10/28 04:32:33 mal Exp $
//
//---------------------------------------------------------------------------
#include <strstream.h>
#include <assert.h>

#include "VTime.hh"
#include "SimulationObj.hh"
#include "VHDLKernelBase.hh"
#include "vhdl.hh"
#include "Events.hh"
#include "MarkedQueue.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "Variable.hh"
#include "AccessVariable.hh"
#include "Wait.hh"
#include "Vector.hh"
#include "VHDLType.hh"
#include "ScalarType.hh"
#include "RecordType.hh"
#include "VectorBase.hh"
#include "ArrayType.hh"
#include "SavantlineType.hh"
#include "CallStack.hh"
#include "Block.hh"
#include "SortedList.hh"
#include "VHDLKernel_state.hh"

class _savant_entity_elab;

class VHDLKernel : public SimulationObj, public VHDLKernelBase {
public:
  VHDLKernel();
  virtual ~VHDLKernel();

  virtual void initialize();
  void finalize();
  void executeProcess();           // main VHDL simulation loop
  void cancelSingleMessage(BasicEvent*);
  void sendNegEvent(BasicEvent*);

#ifdef SEQUENTIAL
  void sendEventUnconditionally(BasicEvent*);
#endif

#ifndef SEQUENTIAL
  void outputGcollect(VTime, Container<BasicEvent>*&);
  void outputGcollect(VTime) {
    // This method is written to stop CC from yelling that the other
    // outputGcollect method hides the virtual method in BasicTimeWarp.
  }
#else
  void outputGcollect(VTime gtime);
#endif

  void rollback(VTime);
  virtual void executeVHDL() = 0;  // VHDL process simulation code
  inline VTime getTimeNow() const {
    return getLVT();
  }
  inline int myId() const {
    return id;
  }

  // Implicitly assumes that a variable called "stack" is defined in the
  // user-defined state of type CallStack.
  inline CallStack* getCallStack() const {
    return &(((VHDLKernel_state *) state->current)->stack);
  }

  inline BasicState* getState() const {
    return state->current;
  }

  bool resumeWait(int, const EnumerationType& = SAVANT_BOOLEAN_TRUE);
  void executeWait(int, const PhysicalType& = SAVANT_INFINITY_TIME);
  void setProcedureWait(const Wait* myWait) {
    ((VHDLKernel_state *) state->current)->procWait = (Wait *) myWait;
  }
  int getWaitLabel() const {
    return ((VHDLKernel_state *) state->current)->waitLabel;
  }

  void assignSignal(VHDLType& dest, int sigsrc, const VHDLType& src,
		    const PhysicalType& delay,
		    const PhysicalType& rejTime = SAVANT_ZERO_TIME, 
		    const ArrayInfo& dinfo = defaultInfo,
		    const ArrayInfo& sinfo = defaultInfo);

  void assignSignal(SignalBase&, int, const VHDLData&, const VTime&, 
		    const VTime& = ZERO, const ArrayInfo& = defaultInfo, 
		    const ArrayInfo& = defaultInfo);
  // These are shells which accept the relevant data type (3rd arg),
  // convert it to a VHDLData-derived type, and call the real assignSignal
  void assignSignal(SignalBase&, int, const char, const VTime&, 
		    const VTime& = ZERO, const ArrayInfo& = defaultInfo, 
		    const ArrayInfo& = defaultInfo);

  virtual void assignNullTransaction(VHDLType& dest, int sigsrc,
				     const PhysicalType& delay,
				     const PhysicalType& rejTime = SAVANT_ZERO_TIME, 
				     const ArrayInfo& dinfo = defaultInfo,
				     const ArrayInfo& sinfo = defaultInfo);

  virtual void assignNullTransaction(SignalBase&, int, const VTime&, 
		    const VTime& = ZERO, const ArrayInfo& = nullInfo, 
		    const ArrayInfo& = nullInfo);

  // lib STANDARD and TEXTIO functions and procedures
  //    bool savantendfile(int);
  EnumerationType savantendfile_boolean(VHDLKernelBase*, int);
  EnumerationType savantendfile_boolean(VHDLKernelBase*, FileType&);
  EnumerationType savantendfile(VHDLKernelBase*, int);
  EnumerationType savantendfile(VHDLKernelBase*, FileType&);
  VTime& _savant_now() { return state->current->lVT; }

  int savantreadline(VHDLKernelBase*, int, AccessVariable<char*>&);

  int savantwriteline(VHDLKernelBase*, int, AccessVariable<char*>&);
  int savantwriteline(VHDLKernelBase*, int, SavantlineType &);
  int savantreadline(VHDLKernelBase*, int, SavantlineType &);
  int savantwriteline(VHDLKernelBase*, FileType&, SavantlineType &);
  int savantreadline(VHDLKernelBase*, const FileType&, SavantlineType &);
  int savantreadline(VHDLKernelBase*, int, SavantlineType&, IntegerType&);
  EnumerationType locateQuietAttribute(const SignalBase *, 
					  const VTime = ZERO);
  EnumerationType locateQuietAttribute(const VHDLType* sig, const VTime = ZERO);
  EnumerationType locateQuietAttribute(const ScalarType* sig, const VTime = ZERO);
  EnumerationType locateQuietAttribute(const RecordType* sig, const VTime = ZERO);
  EnumerationType locateQuietAttribute(const VectorBase* sig, const VTime = ZERO);

  EnumerationType locateEventAttribute(const VHDLType* sig);
  EnumerationType locateEventAttribute(SignalBase *);
  EnumerationType locateEventAttribute(const ScalarType* sig);
  EnumerationType locateEventAttribute(const RecordType* sig);
  EnumerationType locateEventAttribute(const VectorBase* sig);

  EnumerationType locateActiveAttribute(const VHDLType* sig);
  EnumerationType locateActiveAttribute(const SignalBase *);
  EnumerationType locateActiveAttribute(const ScalarType* sig);
  EnumerationType locateActiveAttribute(const RecordType* sig);
  EnumerationType locateActiveAttribute(const VectorBase* sig);

  EnumerationType locateStableAttribute(const SignalBase *, 
					  const VTime = ZERO);
  EnumerationType locateStableAttribute(const VHDLType* sig, 
					   const VTime = ZERO);
  EnumerationType locateStableAttribute(const ScalarType* sig, 
					   const VTime = ZERO);
  EnumerationType locateStableAttribute(const RecordType* sig, 
					   const VTime = ZERO);
  EnumerationType locateStableAttribute(const VectorBase* sig, 
					   const VTime = ZERO);

  EnumerationType* locateTransactionAttribute(const VHDLType* sig);
  EnumerationType* locateTransactionAttribute(const SignalBase *);
  EnumerationType* locateTransactionAttribute(const ScalarType* sig);
  EnumerationType* locateTransactionAttribute(const RecordType* sig);
  EnumerationType* locateTransactionAttribute(const VectorBase* sig);

  PhysicalType locateLastActiveAttribute(const VHDLType* sig);
  PhysicalType locateLastActiveAttribute(const SignalBase *);
  PhysicalType locateLastActiveAttribute(const ScalarType* sig);
  PhysicalType locateLastActiveAttribute(const RecordType* sig);
  PhysicalType locateLastActiveAttribute(const VectorBase* sig);

  PhysicalType locateLastEventAttribute(const VHDLType* sig);
  PhysicalType locateLastEventAttribute(const SignalBase *);
  PhysicalType locateLastEventAttribute(const ScalarType* sig);
  PhysicalType locateLastEventAttribute(const RecordType* sig);
  PhysicalType locateLastEventAttribute(const VectorBase* sig);

  VHDLType* locateLastValueAttribute(const VHDLType* sig);
  VHDLType* locateLastValueAttribute(const SignalBase *);
  VHDLType* locateLastValueAttribute(const ScalarType* sig);
  VHDLType* locateLastValueAttribute(const RecordType* sig);
  VHDLType* locateLastValueAttribute(const VectorBase* sig);

  int openFile(const char *, const _savant_file_open_kind &, ios::open_mode = ios::out);
  void closeFile(const _savant_file_open_kind &, int);

#ifndef SEQUENTIAL
  void initState();
#endif


  _savant_entity_elab* proc;
  
protected:
  bool postponed;
  
private:
  // array of signal ID's that had events on them this sim cycle.  Used
  // for wait resumption.
  EventSigs eventSigs;

  // queue for performing VHDL marking on output
  MarkedQueue markedQ;

  Block scalarSignalsUpdateArray;
  Block compositeResolvedSignalsUpdateArray;

  //In a simulation cycle, we could get 
  //different events that correspond to several 
  //transactions posted for this cycle
  //eventsInCurrentCycle collects all these
  //events from the simulation kernel(TimeWarp/Sequential/...)
  Block eventsInCurrentCycle;

  //A transaction that has been posted to a process
  //could be cancelled during a marking process
  //The events to be cancelled are received are
  //informed by CANCELTRANSACTION event
  //eventsToCancel is tha array that holds the
  //CANCELTRANSACTION events
  Block eventsToCancel;

  void updateSignal(int, int, VHDLData*, const ArrayInfo*, const ArrayInfo*);
  void updateSignal(SignalBase*, bool = false);
  void updateSignal(VHDLType*);
  void updateDriver(SigEvent*);
  void disconnectDriver(SigEvent*);

  void updateWait(WaitEvent*);
  void updateImplicit(SignalBase*, VHDLData*);

  void updateImplicitAttributes(SignalBase*, const VHDLData*, bool);
  void updateImplicitAttributes(VHDLType*, const VHDLType*);
  void updateDefaultAttributes(SignalBase*, const VHDLData*, bool);

  // The second argument is a dummy argument.
  void updateAttribute(Attribute *attribute, const VHDLData &lastValue = UNIVERSAL_FALSE);

  char* getline(istream&, int&);
  bool eatwhite(AccessVariable<char*>&);
  void executeSignalUpdationPhase();
  void updateGuard(VHDLType*);
  virtual VHDLType *getGuard() { return NULL; };
  virtual VHDLType *getGuardExpression() { return NULL;}
};

#ifdef SEQUENTIAL
// Compare function needed when we define a sorted list for outpuQ
extern int compareFunction(const BasicEvent *, const BasicEvent *);
#endif

#endif
