/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "../ballistics.h"
#include "../gfx.h"

void wgxDrawSimpleShot(struct Projectilepos_bal *prjpos, void* info)
{
    int tx=prjpos->x;
    int ty=prjpos->y;
    int otx=prjpos->ox;
    int oty=prjpos->oy;

    
    int sx=gfxTerrainToScreenXCoord(tx);
    int sy=gfxTerrainToScreenYCoord(ty);

    gfxDrawArea(otx-gfxScaleScreenToTerrainXDimen(2),
				oty-gfxScaleScreenToTerrainYDimen(2), 
				gfxScaleScreenToTerrainXDimen(5), 
				gfxScaleScreenToTerrainYDimen(5));
    
    if(tx==-1 && ty==-1) return;

    ggiPutPixel(gfx_vis, 
				sx,
				sy,
				gfx_white);
    ggiPutPixel(gfx_vis, 
				sx+1,
				sy,
				gfx_white);
    ggiPutPixel(gfx_vis, 
				sx-1,
				sy,
				gfx_white);
    ggiPutPixel(gfx_vis, 
				sx,
				sy+1,
				gfx_white);
    ggiPutPixel(gfx_vis, 
				sx,
				sy-1,
				gfx_white);

    /* we might need to redraw walls */
    gfxDrawWalls(otx-gfxScaleScreenToTerrainXDimen(2),
				oty-gfxScaleScreenToTerrainYDimen(2), 
				gfxScaleScreenToTerrainXDimen(5), 
				gfxScaleScreenToTerrainYDimen(5));
}

void wgxDrawSimpleExplosion(void* info)
{
    int i;
    ggi_color c;
    int tx=((struct SimpleExplosion_wep*)info)->x;
    int ty=((struct SimpleExplosion_wep*)info)->y;
    int tr=((struct SimpleExplosion_wep*)info)->r;
    int sx=gfxTerrainToScreenXCoord(tx); /* (tx*gfx_xmax)/ter_sizex; */
    int sy=gfxTerrainToScreenYCoord(ty); /* gfx_ymax-(ty*gfx_ymax)/ter_sizey; */
    int sa=(tr*gfx_xsize)/ter_sizex;
	int sb=(tr*gfx_ysize)/ter_sizey;
	
	if(sa >= sb) 
	{
		for(i=sa; i>0; i--)
		{
			c.r=((sa-i)*(255.0/sa))*255.0;
			c.g=0x24<<8;
			c.b=0x24<<8;
			c.a=0xFF<<8;
			ggiSetGCForeground(gfx_vis, ggiMapColor(gfx_vis, &c));
			gfxDrawThickEllipse(sx, sy, i, (i*sb)/sa);
		}
	}
	else
	{
		for(i=sb; i>0; i--)
		{
			c.r=((sb-i)*(255.0/sb))*255.0;
			c.g=0x24<<8;
			c.b=0x24<<8;
			c.a=0xFF<<8;
			ggiSetGCForeground(gfx_vis, ggiMapColor(gfx_vis, &c));
			gfxDrawThickEllipse(sx, sy, (i*sa)/sb, sb);
		}
	}

    if(tr+((struct SimpleExplosion_wep*)info)->dx >= ((struct SimpleExplosion_wep*)info)->max_radius)
    {
		gfxDrawArea(tx - tr - 2*((struct SimpleExplosion_wep*)info)->dx, 
					ty - tr - 2*((struct SimpleExplosion_wep*)info)->dx, 
					tr*2 + 4*((struct SimpleExplosion_wep*)info)->dx, 
					tr*2 + 4*((struct SimpleExplosion_wep*)info)->dx);
    }
}
