#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "bomb01.img",
      "bomb02.img",
      "bomb03.img",
      "bomb04.img",
      "bomb11.img",
      "bomb12.img",
      "bomb13.img",
      "bomb14.img",
      "bomb21.img",
      "bomb22.img",
      "bomb23.img",
      "bomb24.img",
      "bomb31.img",
      "bomb32.img",
      "bomb33.img",
      "bomb34.img",
      "bomb41.img",
      "bomb42.img",
      "bomb43.img",
      "bomb44.img"
};

PRIVATE Pixmap pixmap[5];
PRIVATE Pixmap pixmap_mask[5];
PRIVATE GC gc[5];
PRIVATE int anim[5] = {4,3,2,1,0};

void BombSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[512];
      XGCValues gcv;
      
      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 5 ; c_no++) {
            int x,y,cx,cy;
            
            	    
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE*2,CSIZE*2,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
	    
	    for(cy = 0 ; cy < 2 ; cy++)
	      for(cx = 0 ; cx < 2 ; cx++) {
		    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no*4+cy*2+cx]);
		    LoadChar(tpath,img , sizeof(img));
		    
		    for(y = 0 ; y < CSIZE ; y++)
		      for(x = 0 ; x < CSIZE ; x++) {
			    if(img[y*CSIZE+x] != 100) {
				  mask[y*8+x/8+cx*4+cy*256] |= (1<< (x%8));
				  XSetForeground(d,gc[c_no],
						 pixel[img[y*CSIZE+x]]);
				  XDrawPoint(d,pixmap[c_no]
					     ,gc[c_no],x+cx*32,y+cy*32);
			    }
		      }
		    
	      }
	    pixmap_mask[c_no] 
	      = XCreateBitmapFromData(d,w,mask,CSIZE*2,CSIZE*2);
	    XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void BombFree()
{
      int i;
      
      for(i = 0 ; i < 5 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
	    
      }

}

void BombInit(enemy_no)
     int enemy_no;
{
      enemy[enemy_no].enemy_no = BOMB;
      enemy[enemy_no].tmp1 = 5;
      enemy[enemy_no].tmp2 = 0;
      enemy[enemy_no].vx = 0;
      enemy[enemy_no].vy = 0;
}

void BombCInit(enemy_no)
     int enemy_no;
{
      enemy_chijou[enemy_no].enemy_no = BOMB;
      enemy_chijou[enemy_no].tmp1 = 5;
      enemy_chijou[enemy_no].tmp2 = 0;
      enemy_chijou[enemy_no].vx = 0;
      enemy_chijou[enemy_no].vy = STPF*65536;
}


int Bomb(enemy_no)
     int enemy_no;
{
      enemy[enemy_no].tmp1--;
      SetSprite(enemy[enemy_no].x.sht[UNION]-CSIZE/2,
		enemy[enemy_no].y.sht[UNION]-CSIZE/2,
		pixmap[anim[enemy[enemy_no].tmp1]],
		gc[anim[enemy[enemy_no].tmp1]],
		CSIZE*2,CSIZE*2);
      
      if(enemy[enemy_no].tmp1 == 0)
	enemy[enemy_no].enemy_no = 0;
      
      return 0;
}
      
void CBomb(enemy_no)
     int enemy_no;
{
      
      enemy_chijou[enemy_no].tmp1--;
      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;

      SetSprite(enemy_chijou[enemy_no].x.sht[UNION]-CSIZE/2,
		enemy_chijou[enemy_no].y.sht[UNION]-CSIZE/2,
		pixmap[anim[enemy_chijou[enemy_no].tmp1]],
		gc[anim[enemy_chijou[enemy_no].tmp1]],
		CSIZE*2,CSIZE*2);
      
      if(enemy_chijou[enemy_no].tmp1 == 0)
	if(enemy_chijou[enemy_no].tmp3 == 1)
	  enemy_chijou[enemy_no].enemy_no = ATO;
	else 
	  enemy_chijou[enemy_no].enemy_no = 0;
      
}      

void JikiBomb(i)
     int i;
{
      SetSprite(jx.sht[UNION]-CSIZE/2,jy.sht[UNION]-CSIZE/2,
		pixmap[anim[i]],gc[anim[i]],
		CSIZE*2,CSIZE*2);
}


	    

      
