/*
                     Extended String Functions




 */

#ifndef STRING_H
#define STRING_H	/* NOT to be confused with standard _STRING_H */


#include <db.h>
#include <sys/types.h>


/*
 *	Basic string examination functions:
 */
extern int strlinelen(char *s);
extern int strlongestline(char *s);
extern int strlines(char *s);
extern int strpfx(char *str, char *pfx);
extern int strcasepfx(char *str, char *pfx);
extern void substr(char *s, char *token, char *val);

/*
 *	Basic string manipulation functions:
 */
extern char *StringCopyAlloc(char *str);
extern void StringStripSpaces(char *s);
extern int StringPrefix(char *str, char *prefix);
extern char **StringQSort(char **strings, int nitems);
extern char *StringTailSpaces(char *string, int len);
extern char **StringCharExplode(char *str, char c, int *strc);
extern void StringShortenFL(char *string, int limit);
extern void StringFreeArray(char **strv, int strc);

/*
 *	UNIX configuration file format line examination
 *	and manipulation functions:
 */
extern int StringIsYes(char *string);
extern int StringIsComment(char *s, char c);
extern char *StringCfgParseParm(char *string);
extern char *StringCfgParseValue(char *string);

/*
 *	Color specification parsing functions:
 */
extern int StringParseStdColor(
	char *s,
	u_int8_t *r_rtn,
	u_int8_t *g_rtn,
	u_int8_t *b_rtn
);

/*
 *	Misc parsing functions:
 */
extern int StringParseIP(
        char *s,
        u_int8_t *c1,
        u_int8_t *c2,
        u_int8_t *c3,
        u_int8_t *c4
);

/*
 *	XCyberSpace specific functions:
 */
extern int StringGetNetCommand(char *str);
extern char *StringGetNetArgument(char *str);

/*
 *	Time string formatting functions:
 */
extern char *StringCurrentTimeFormat(char *format);
extern char *StringTimeFormat(char *format, time_t seconds);
extern char *StringFormatTimePeriod(time_t seconds);

/*
 *	XShipWars objects string functions:
 */
extern int StringValidateName(char *name);



#endif /* STRING_H */
