#include "swserv.h"

#define THIS_CMD_NAME	"disk"
  
 
/*
 *	Reports program used file sizes and site disk
 *	statistics.
 */
int CmdDisk(int condescriptor, char *arg)
{
        long con_object_num;
        xsw_object_struct *obj_ptr;
	struct stat stat_buf;
        char sndbuf[CS_DATA_MAX_LEN + PATH_MAX + NAME_MAX];


        /* Get connection's object number (assumed valid). */
        con_object_num = connection[condescriptor]->object_num;
	if(DBIsObjectGarbage(con_object_num))
	    return(-1);
	else
	    obj_ptr = xsw_object[con_object_num];


        /* Check if allowed to view disk. */
        if(obj_ptr->permission.uid > ACCESS_UID_DISK)
        {
            sprintf(sndbuf,
                "%s: Access level %i: Permission denied.",
		THIS_CMD_NAME,
                ACCESS_UID_DISK
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


	/*   Do not call disk stats update since it would cause
	 *   process to halt for a short time.
	 *   That would leave this function too opened for abuse.
	 */
/*
SWServGetOSStats();
 */


        if((arg == NULL) ? 1 : (arg[0] == '\0'))
        {
	    /* Print program files and disk stats. */

	    /* Device hosting program. */
            sprintf(sndbuf,
 "Host device space: %ld kb used  %ld kb total  %.0lf%% ratio",
		os_stat.disk_used,
		os_stat.disk_total,
		(double)os_stat.disk_used /
		    (double)os_stat.disk_total * 100
            );
            NetSendLiveMessage(condescriptor, sndbuf);

	    /* Universe input file. */
	    if(!stat(fname.unv_in, &stat_buf))
	    {
                sprintf(sndbuf,
 "Universe in: %s  %ld bytes",
		    fname.unv_in,
		    stat_buf.st_size
                );
                NetSendLiveMessage(condescriptor, sndbuf);
            }

	    /* Universe output file. */
            if(!stat(fname.unv_out, &stat_buf))
            {
                sprintf(sndbuf,
 "Universe out: %s  %ld bytes",
                    fname.unv_out,
                    stat_buf.st_size
                );
                NetSendLiveMessage(condescriptor, sndbuf);
            }

            /* Log. */    
            if(!stat(fname.primary_log, &stat_buf))
            {
                sprintf(sndbuf,
 "Primary log: %s  %ld bytes",
                    fname.primary_log,
                    stat_buf.st_size
                );
                NetSendLiveMessage(condescriptor, sndbuf);
            }

            /* Events export log. */
            if(!stat(fname.events_export, &stat_buf))
            {
                sprintf(sndbuf,
 "Events export log: %s  %ld bytes",
                    fname.events_export,
                    stat_buf.st_size
                );
                NetSendLiveMessage(condescriptor, sndbuf);
            }
        }
	else
	{


	}
 

        return(0);
}

