#include <fnmatch.h>

#include "../include/string.h"
#include "../include/strexp.h"

#include "swserv.h"


void CmdFindStringToUpper(char *string);
int CmdFindMatch(char *pattern, char *string);


void CmdFindStringToUpper(char *string)
{
	if(string == NULL)
	    return;

	while(*string != '\0')
	    *string++ = toupper(*string);

	return;
}


int CmdFindMatch(char *pattern, char *string)
{
	int status;
	char *tmp_pattern, *tmp_string;


	tmp_pattern = StringCopyAlloc(pattern);
	tmp_string = StringCopyAlloc(string);

	CmdFindStringToUpper(tmp_pattern);
	CmdFindStringToUpper(tmp_string);

	if((tmp_pattern != NULL) &&
	   (tmp_string != NULL)
	)
	    status = fnmatch(tmp_pattern, tmp_string, 0);
	else
	    status = -1;

	free(tmp_pattern);
	free(tmp_string);


	return(status);
}


int CmdFind(int condescriptor, char *arg)
{
	char larg[CS_DATA_MAX_LEN];
	char pattern[CS_DATA_MAX_LEN];
	char type_str[CS_DATA_MAX_LEN];

	char **argv;
	int argc;

        double dx, dy;
        double dsx, dsy;  
        char position_str[512];
        
	int status;

	char *type_str_ptr = "";

        char name1[256];
        char name2[256];

        long object_num;   
        long objects_found;
        char sndbuf[CS_DATA_MAX_LEN];

        long con_object_num;
        xsw_object_struct *con_obj_ptr;
        xsw_object_struct **obj_ptr;



	/* Print usage? */
	if((arg == NULL) ? 1 : (*arg == '\0'))
        {
            NetSendLiveMessage(condescriptor,
                "Usage: `find <name_pattern>[=<type>]'"
            );

            return(-1);
        }


	/* Copy arg to local argument. */
        strncpy(larg, arg, CS_DATA_MAX_LEN);
        larg[CS_DATA_MAX_LEN - 1] = '\0';   
        StringStripSpaces(larg);


        /* Get connection object. */
        con_object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(con_object_num))
            return(-1);
        else
            con_obj_ptr = xsw_object[con_object_num];


        /* Check if connection object is allowed to find? */
        if(con_obj_ptr->permission.uid > ACCESS_UID_FIND)
        {
            sprintf(sndbuf,
             "find: Requires access level %i: Permission denied.",
                ACCESS_UID_FIND
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Parse and get pattern and type_str. */
	argv = strchrexp(larg, '=', &argc);

	strncpy(
	    pattern,
	    ((argc >= 1) ? argv[0] : "*"),
	    CS_DATA_MAX_LEN
	);
	pattern[CS_DATA_MAX_LEN - 1] = '\0';
	StringStripSpaces(pattern);

	strncpy(
            type_str,
            ((argc >= 2) ? argv[1] : "*"),
            CS_DATA_MAX_LEN
        );
        type_str[CS_DATA_MAX_LEN - 1] = '\0';
	StringStripSpaces(type_str);


	StringFreeArray(argv, argc);


        /* Go through XSW objects list. */
        for(object_num = 0, objects_found = 0, obj_ptr = xsw_object;
            object_num < total_objects;
            object_num++, obj_ptr++
        )
        {
            if(*obj_ptr == NULL)
                continue;
            if((*obj_ptr)->type <= XSW_OBJ_TYPE_GARBAGE)
		continue;

            /* Allowed to match others? */
            if(((*obj_ptr)->owner != con_object_num) &&
                (con_obj_ptr->permission.uid > ACCESS_UID_FINDO)
            )
                continue;


	    /* Type match? */
	    switch((*obj_ptr)->type)
	    {
	      case XSW_OBJ_TYPE_STATIC:
                type_str_ptr = XSW_TYPE_NAME_STATIC;
		if(CmdFindMatch(type_str, type_str_ptr))
		    status = -1;
		else
		    status = 0;
		break;

              case XSW_OBJ_TYPE_DYNAMIC:
		type_str_ptr = XSW_TYPE_NAME_DYNAMIC;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_CONTROLLED:
		type_str_ptr = XSW_TYPE_NAME_CONTROLLED;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_PLAYER:
		type_str_ptr = XSW_TYPE_NAME_PLAYER;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_WEAPON:
		type_str_ptr = XSW_TYPE_NAME_WEAPON;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_STREAMWEAPON:
		type_str_ptr = XSW_TYPE_NAME_STREAMWEAPON;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_SPHEREWEAPON:
		type_str_ptr = XSW_TYPE_NAME_SPHEREWEAPON;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_HOME:
		type_str_ptr = XSW_TYPE_NAME_HOME;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_AREA:
		type_str_ptr = XSW_TYPE_NAME_AREA;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              case XSW_OBJ_TYPE_ANIMATED:
		type_str_ptr = XSW_TYPE_NAME_ANIMATED;
                if(CmdFindMatch(type_str, type_str_ptr))
                    status = -1;
                else
                    status = 0;
                break;

              default:
		status = 0;
                break;
	    }
	    if(status)
		continue;


	    /* Name match? */
	    if(fnmatch(pattern, (*obj_ptr)->name, 0))
		continue;


	    /* Consider this object found. */
            objects_found++;

            /* Format position string. */
            if(Mu3DInSector(object_num,
                con_obj_ptr->sect_x,
                con_obj_ptr->sect_y,
                con_obj_ptr->sect_z)
            )
            {
                /* Calculate position distance. */
                dx = (*obj_ptr)->x - con_obj_ptr->x;
                dy = (*obj_ptr)->y - con_obj_ptr->y;
            
                sprintf(position_str,
 "Brg: %.2lf' Dist: %.2lf RU  Pos: %.4lf  %.4lf  %.4lf",
                    RADTODEG(MuCoordinateDeltaVector(dx, dy)),
                    Mu3DDistance(dx, dy, 0),
                    (*obj_ptr)->x,
                    (*obj_ptr)->y,
                    (*obj_ptr)->z
                );
            }
            else
            {
                /* Calculate sector distance. */ 
                dsx = (*obj_ptr)->sect_x - con_obj_ptr->sect_x;
                dsy = (*obj_ptr)->sect_y - con_obj_ptr->sect_y;
         
                sprintf(position_str,
 "Brg: %.2lf' Dist: %.2lf S  Sect: %ld %ld %ld",
                    RADTODEG(MuCoordinateDeltaVector(dsx, dsy)),
                    Mu3DDistance(dsx, dsy, 0),
                    (*obj_ptr)->sect_x,
                    (*obj_ptr)->sect_y,
                    (*obj_ptr)->sect_z
                );
            }

	    /* Format names. */
            strncpy(name1, DBGetFormalNameStr(object_num), 256);
            name1[255] = '\0';
            strncpy(name2, DBGetFormalNameStr((*obj_ptr)->owner), 256);
            name2[255] = '\0';

            sprintf(sndbuf,
                "%s  Type: %s  Owner: %s  %s",
                name1,
                type_str_ptr,
                name2,
                position_str
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        }

        /* Print number of objects found. */
        sprintf(sndbuf, "*** %ld Object%s Found ***",
            objects_found,
            ((objects_found == 1) ? "" : "s")
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        return(0);
}
