/*
 * affilt.c
 *
 *  affilt contains code to parse the AFOS messages, then route them to the
 *       appropriate destinations based on matches of product names.
 *
 *	$Id: affilt.c,v 1.9 1996/08/31 05:02:45 ron Exp $
 *
 */
#include "afos.h"
#include <stdio.h>

static unsigned char filter_buffer[AFFILT_BUFSIZE] ;
static int filter_count ;
static int n_count ;
static void (*filter_state)(int c) ;
static void (*header_state)(int c) ;

void searching_state(int c) ;
void searching_state2(int c) ;
void searching_state3(int c) ;
void searching_state4(int c) ;
void searching_state5(int c) ;
void storing_state(int c) ;

void header_hunt(int c) ;
void header_state0(int c) ;
void header_state1(int c) ;
void header_state2(int c) ;
void header_state3(int c) ;

void process_filter_buffer( unsigned char *s, int size ) ;

AF_FILT_STATS filter_stats ;

void
filter_init()
{
	filter_state = searching_state ;
	header_state = header_state0 ;
	n_count = 0 ;

	memset(&filter_stats, 0, sizeof(filter_stats) ) ;
	filter_buffer[0] = 'Z' ;
	filter_buffer[1] = 'C' ;
	filter_buffer[2] = 'Z' ;
	filter_buffer[3] = 'C' ;
	filter_buffer[4] = ' ' ;
}

void
filter_procchar (int c)
{
	int temp = (0xff & c) ;

	filter_stats.char_count++ ;

	if ( c < 0 )
	{
		filter_stats.errchar_count++ ;
		return ;
	}

	if ( temp == 'N' )
	{
		if ( ++n_count >= 4 )
		{
			n_count = 0 ;
			filter_stats.nnnn_count++ ;
			if ( (filter_state == storing_state) && ( filter_count > 14 ) )
			{
				/* Stuff the last N in there */
				filter_state(temp) ;

				/* Process the buffer */
				process_filter_buffer(filter_buffer, filter_count) ;

				/* Back to looking for the next buffer */
				filter_state = searching_state ;
				filter_stats.buffer_count++ ;
				return ;
			}
		}
	}
	else
		n_count = 0 ;

	filter_state( 0xff & c) ;
}

void 
searching_state(int c)
{
	if ( c == 'Z' )
		filter_state = searching_state2 ;

	return ;
}

void 
searching_state2(int c)
{
	if ( c == 'C' )
		filter_state = searching_state3 ;
	else
		filter_state = searching_state ;

	return ;
}


void 
searching_state3(int c)
{
	if ( c == 'Z' )
		filter_state = searching_state4 ;
	else
		filter_state = searching_state ;

	return ;
}

void 
searching_state4(int c)
{
	if ( c == 'C' )
		filter_state = searching_state5 ;
	else
		filter_state = searching_state ;

	return ;
}


void 
searching_state5(int c)
{
	if ( c == ' ' )
	{
		filter_state = storing_state ;
		filter_count = 5 ;
		filter_stats.zczc_count++ ;
	}
	else
		filter_state = searching_state ;

	return ;
}


void 
storing_state(int c) 
{
	filter_buffer[filter_count++] = c ;

	if (filter_count >= AFFILT_BUFSIZE )
	{
		filter_state = searching_state ;
		filter_stats.buffer_overruns++ ;
	}
	header_hunt (c) ;
}

void
header_hunt (int c )
{
	header_state(c);
}

void
header_state0 (int c )
{
	if ( c == 'Z' )
		header_state = header_state1 ;

	return ;
}

void
header_state1 (int c )
{
	if ( c == 'C' )
		header_state = header_state2 ;
	else
		header_state = header_state0 ;

	return ;
}


void
header_state2 (int c )
{
	if ( c == 'Z' )
		header_state = header_state3 ;
	else
		header_state = header_state0 ;

	return ;
}

void
header_state3 (int c )
{
	if ( c == 'C' )
	{
		/* header_hunt has found a ZCZC string while we were in the middle */
		/* of a buffer (still looking for NNNN to end the last message     */
		header_state = header_state0 ;
		filter_state = searching_state5 ;
		filter_stats.incomplete_buffers++ ;
	}
	else
		header_state = header_state0 ;

	return ;
}


filter_stat_dump()
{
	fprintf(stderr,"\r\n\nFilter stats:\r\n"
		   "character count        : %d\r\n"
		   "zczc count             : %d\r\n"
		   "nnnn count             : %d\r\n"
		   "buffer count           : %d\r\n"
		   "incomplete buffer count: %d\r\n"
		   "match count            : %d\r\n"
		   "buffer overrun count   : %d\r\n"
		   "error character  count : %d\r\n",
		   filter_stats.char_count,
		   filter_stats.zczc_count,
		   filter_stats.nnnn_count,
		   filter_stats.buffer_count,
		   filter_stats.incomplete_buffers,
		   filter_stats.match_count,
		   filter_stats.buffer_overruns,
		   filter_stats.errchar_count );
}

filter_display_state()
{
	if ( filter_state == searching_state )
		write(2, "\r\nsearching_state   ", 20 );
	if ( filter_state == searching_state2 )
		write(2, "\r\nsearching_state2  ", 20 );
	if ( filter_state == searching_state3 )
		write(2, "\r\nsearching_state3  ", 20 );
	if ( filter_state == searching_state4 )
		write(2, "\r\nsearching_state4  ", 20 );
	if ( filter_state == searching_state5 )
		write(2, "\r\nsearching_state5  ", 20 );
	if ( filter_state == storing_state )
		write(2, "\r\nstoring_state     ", 20 );
}
