/*
 * afio.c
 *
 *	$Id: afio.c,v 1.12 1998/07/28 23:10:36 ron Exp $
 *
 *	$History$
 *
 */
#include <termios.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include "afos.h"

typedef struct _AFOS_PORT_DATA_ {
	int debug ;
	int rxbytes ;
	int badread ;
	}  AFOS_PORT_DATA ;

AFOS_PORT_DATA afos_data ;
static void afos_process_char ( void *private, int event ) ;

/*
	parse_afosin parses out the 'afos-in' line in the config file
*/
int
parse_afosin( char *line )
{
	static char args[2][80] ;
	AF_CHANNEL *chan ;
	int count ;

	count = sscanf ( line,  "%[^ 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]",
		args[0], args[1] ) ;

	if ( count < 2 )
	{
		fprintf ( stderr, "\r\nAFOSD: Unable to parse the following line:\n%s\n"
			"Insufficient parameters for afos-in designation\n"
			"Usage:\n"
	"afos-in <CHANNEL NAME>\n", line);
		exit (-1);
	}

	strncpy ( afos_in_channel_name, args[1], AFCHAN_NAME_SIZE ) ;

#if 0
	printf( "config line: '%s'\n"
			"designated afos input channel: '%s'\n",
			line, afos_in_channel_name ) ;
#endif
}

/*
	afosin_init initializes a file channel
*/
static int
afosin_init ( )
{
	AF_CHANNEL *p, *q ;

	/* 
		Verify channel is defined, set-up select entry, etc.
	*/

	if (verify_unique_portname(afos_in_channel_name))
	{
		fprintf(stderr,"\r\nERROR in port configuration file\n%s\n"
					   "afos-in designated port '%s' is un-defined\n",
						afos_in_channel_name ) ;
		exit (-1);
	}

	/*
		Find the afos-in channel, remove it from channel list, and place
		it on the afos_in_channel pointer.
	*/
	q = NULL ;
	for ( p = channel_list ; p ; p = p->next )
	{
		if ( strcmp ( p->name, afos_in_channel_name ) == 0 )
			break ;

		q = p ;
	}

	if (!p)
	{
		/* Channel list must have been NULL, or afos-in wasn't there */
		fprintf(stderr,"\r\nAFOSD: Internal error:\n"
					   "Unable to find port designated as afos-in '%s'\n",
						afos_in_channel_name ) ;
		exit (-1);
	}

	if (!q)
	{
		/* Channel designated as afos-in was at the head of the list */
		channel_list = p->next ;
	}
	else
	{
		/* Channel designated as afos-in was within or at end of list */
		q->next = p->next ;
	}

	afos_in_channel = p ;
	p->next = NULL ;

	/*
		the channel's init is passed the pointer to this channel
		structure, and a pointer to the callback function to handle
		incoming data.
	*/
	afos_in_channel->init( afos_in_channel, afos_process_char ) ;

}


static void
afos_process_char( void *private, int data )
{
	int ret ;
	int rfd ;
	AFOS_PORT_DATA *s = &afos_data ;

	s = private ;
	rfd = afos_in_channel->fd ;

	/*
		Now changetchar calls us.  'data' contains the results of the
		read
	OR NOT!!

	ret = afos_in_channel->changetchar ( afos_in_channel );
	*/
	ret = data ;

	if (ret < 0 )
	{
		if (! isatty(rfd) )
		{
			/* What happens here if the channel is a network channel ? */
			fprintf(stderr, "\r\ngetchar returned %d.  errno=%d\r\n",
				ret, errno );
			perror("AFOS in channel error");
			filter_stat_dump();
			afhist_display();
			endwin();
			exit(-1);
		}
		s->badread++ ;
		return ;
	}
	s->rxbytes++ ;

	if (s->debug & AFOS_PORT_TRACE_BYTE )
		printf("%02x ", ret ) ;

	logwin_putchar (ret);
	filter_procchar (ret) ;
	return ;
}
/*
	afio_init() is called by the initialization routine
*/
int
afio_init( char *portname, int speed )
{
	struct termios tparms;
	int parm;
	int ret ;

	/*
		Call afosin_init to find the afos-in channel, manipulate the channel
		data structures, call the appropriate function to open and initialize
		the channel
	*/
	afosin_init();

/*
	the select_list_add call will be made by the channel's initialization
	routine now.  There will be a callback function pointer to 
	afos_process_char() passed the channel's initialization routine.

	afloop_select_list_add( afos_in_channel->fd, 
							afos_process_char, 
							&afos_data ) ;
*/

}
