// ---------------------------------------------------------------------------
// - Reserved.cpp                                                            -
// - aleph engine - reserved name class implementation                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Nameset.hpp"
#include "Reserved.hpp"

namespace aleph {

  // create a default reserved name
  
  Reserved::Reserved (void) {
    d_lnum   = 0;
    p_object = nilp;
  }

  // create a reserved with a name and a line number
  
  Reserved::Reserved (const String& name, const long lnum) {
    d_name   = name;
    p_object = nilp;
    d_lnum   = lnum;
  }

  // destroy this reserved keyword

  Reserved::~Reserved (void) {
    Object::dref (p_object);
  }

  // return the class name

  String Reserved::repr (void) const {
    return "Reserved";
  }

  // return a literal representation

  String Reserved::toLiteral (void) const {
    return d_name;
  }

  // return a string representation

  String Reserved::toString (void) const {
    return d_name;
  }
  
  // evaluate this object in the current nameset

  Object* Reserved::eval (Interp* interp, Nameset* nset) {
    // look for the cached object
    if (p_object != nilp) return p_object;
    // normal evaluation
    p_object = Object::iref (nset->eval (interp, nset, d_name));
    return p_object;
  }
}
