// ---------------------------------------------------------------------------
// - cdir.hxx                                                                -
// - standard system library - c directory function definition               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

/// This package contains c-directory related procedures. These functions
/// uses an opaque handle. All calls have been designed to be thread safe.
/// @author amaury darsch

#ifndef ALEPH_CDIR_HXX
#define ALEPH_CDIR_HXX

namespace aleph {

  /// return the root directory name
  const char* c_rootdir (void);

  /// open a directory by name
  void* c_opendir (const char* name);

  /// get the next file name in the dirctory handle
  /// @param handle the directory handle
  char* c_readdir (void* handle);

  /// rewind a directory entry to its begining
  /// @param handle the directory handle
  void c_rewinddir (void* handle);

  /// close a directory handle
  /// @param handle the directory handle
  void c_closedir (void* handle);

  /// return the current directory name
  char* c_getcwd (void);

  /// create a directory. If the directory exists, the function succeds.
  /// @param name the directory name
  /// @return on success or false in case of error
  bool c_mkdir (const char* name);

  /// remove an empty directory
  bool c_rmdir (const char* name);
}

#endif
