// ForthCompiler.h
//
// Copyright (c) 1998--1999 Krishna Myneni, Creative Consulting for
//   Research and Education
//
// This software is provided under the terms of the GNU General Public License.
//
// Last Revised: 6-10-1999

#ifndef __FORTHCOMPILER_H__
#define __FORTHCOMPILER_H__

#include <vector>
#include <stack>

#define byte unsigned char
#define NUMBER_OF_INTRINSIC_WORDS 152
#define TRUE -1
#define FALSE 0
#define MAX_ERR_MESSAGES 14

// Error codes; The corresponding error messages are given in
//   the const char* array C_ErrorMessages, in ForthCompiler.cpp

#define E_C_NOERROR         0
#define E_C_ENDOFSTREAM     1
#define E_C_ENDOFDEF        2
#define E_C_ENDOFSTRING     3
#define E_C_ELSENOIF        4
#define E_C_THENNOIF        5
#define E_C_NOBEGIN	    6
#define E_C_NOTINDEF        7
#define E_C_OPENFILE        8
#define E_C_INCOMPLETEIF    9
#define E_C_INCOMPLETEBEGIN 10
#define E_C_UNKNOWNWORD     11
#define E_C_NODO            12
#define E_C_INCOMPLETELOOP  13


struct DictionaryEntry
{
    char* WordName;
    byte WordCode;
    void* MemPtr;
};


char* ExtractName (char*, char*);
int IsForthWord (char*, DictionaryEntry*);
int IsFloat (char*, float*);
int IsInt (char*, int*);
int ForthCompiler (vector<byte>*, istream&, ostream&, int*);
void OutputForthByteCode (vector<byte>*, ostream&);


#endif
