#include "global.h"

/*
 * Item
 */
static VALUE
item_select(self)
    VALUE self;
{
    gtk_item_select(GTK_ITEM(get_widget(self)));
    return self;
}

static VALUE
item_deselect(self)
    VALUE self;
{
    gtk_item_deselect(GTK_ITEM(get_widget(self)));
    return self;
}

static VALUE
item_toggle(self)
    VALUE self;
{
    gtk_item_toggle(GTK_ITEM(get_widget(self)));
    return self;
}

void Init_gtk_item()
{
    gItem = rb_define_class_under(mGtk, "Item", gBin);

    rb_define_const(gItem, "SIGNAL_SELECT", rb_str_new2("select"));
    rb_define_const(gItem, "SIGNAL_DESELECT", rb_str_new2("deselect"));
    rb_define_const(gItem, "SIGNAL_TOGGLE", rb_str_new2("toggle"));

    rb_define_method(gItem, "select", item_select, 0);
    rb_define_method(gItem, "deselect", item_deselect, 0);
    rb_define_method(gItem, "toggle", item_toggle, 0);
}

/*
 * ListItem
 */
static VALUE
litem_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_list_item_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_list_item_new();
    }

    set_widget(self, widget);
    return Qnil;
}

void Init_gtk_list_item()
{
    gListItem = rb_define_class_under(mGtk, "ListItem", gItem);

    /*
      rb_define_const(gListItem, "SIGNAL_", rb_str_new2(""));
    */

    rb_define_method(gListItem, "initialize", litem_initialize, -1);
}

/*
 * MenuItem
 */
static VALUE
mitem_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_menu_item_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_menu_item_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
mitem_set_submenu(self, child)
    VALUE self, child;
{
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(get_widget(self)),
			      get_widget(child));
    return self;
}

static VALUE
mitem_set_placement(self, place)
    VALUE self, place;
{
    gtk_menu_item_set_placement(GTK_MENU_ITEM(get_widget(self)), 
				(GtkSubmenuPlacement)NUM2INT(place));
    return self;
}
/* 1.2.x
static VALUE
mitem_accelerator_size(self)
    VALUE self;
{
    gtk_menu_item_accelerator_size(GTK_MENU_ITEM(get_widget(self)));
    return self;
}

static VALUE
mitem_accelerator_text(self)
    VALUE self;
{
    char buf[1024];		* enough? *

    gtk_menu_item_accelerator_text(GTK_MENU_ITEM(get_widget(self)), buf);
    return rb_str_new2(buf);
}
*/
static VALUE
mitem_configure(self, show_toggle, show_submenu)
    VALUE self, show_toggle, show_submenu;
{
    gtk_menu_item_configure(GTK_MENU_ITEM(get_widget(self)), 
			    NUM2INT(show_toggle),
			    NUM2INT(show_submenu));
    return self;
}

static VALUE
mitem_select(self)
    VALUE self;
{
    gtk_menu_item_select(GTK_MENU_ITEM(get_widget(self)));
    return self;
}

static VALUE
mitem_deselect(self)
    VALUE self;
{
    gtk_menu_item_deselect(GTK_MENU_ITEM(get_widget(self)));
    return self;
}

static VALUE
mitem_activate(self)
    VALUE self;
{
    gtk_menu_item_activate(GTK_MENU_ITEM(get_widget(self)));
    return self;
}

static VALUE
mitem_right_justify(self)
    VALUE self;
{
    gtk_menu_item_right_justify(GTK_MENU_ITEM(get_widget(self)));
    return self;
}

void Init_gtk_menu_item()
{
    gMenuItem = rb_define_class_under(mGtk, "MenuItem", gItem);

    rb_define_const(gMenuItem, "SIGNAL_ACTIVATE", rb_str_new2("activate"));

    rb_define_method(gMenuItem, "initialize", mitem_initialize, -1);
    rb_define_method(gMenuItem, "set_submenu", mitem_set_submenu, 1);
    rb_define_method(gMenuItem, "set_placement", mitem_set_placement, 1);
    /* 1.2.x
       rb_define_method(gMenuItem, "accelerator_size", mitem_accelerator_size, 0);
       rb_define_method(gMenuItem, "accelerator_text", mitem_accelerator_text, 0);
  */
    rb_define_method(gMenuItem, "configure", mitem_configure, 2);
    rb_define_method(gMenuItem, "select", mitem_select, 0);
    rb_define_method(gMenuItem, "deselect", mitem_deselect, 0);
    rb_define_method(gMenuItem, "activate", mitem_activate, 0);
    rb_define_method(gMenuItem, "right_justify", mitem_right_justify, 0);
}

/*
 * CheckMenuItem
 */
static VALUE
cmitem_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_check_menu_item_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_check_menu_item_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
cmitem_set_state(self, state)
    VALUE self, state;
{
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(get_widget(self)), 
				  NUM2INT(state));
    return self;
}

static VALUE
cmitem_set_active(self, state)
    VALUE self, state;
{
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(get_widget(self)), 
				  RTEST(state));
    return self;
}

static VALUE
cmitem_is_active(self)
    VALUE self;
{
    return GTK_CHECK_MENU_ITEM(get_widget(self))->active==0?Qfalse:Qtrue;
}

static VALUE
cmitem_set_show_toggle(self, always)
    VALUE self, always;
{
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(get_widget(self)), 
					(gboolean)RTEST(always));
    return self;
}

static VALUE
cmitem_toggled(self)
    VALUE self;
{
    gtk_check_menu_item_toggled(GTK_CHECK_MENU_ITEM(get_widget(self)));
    return self;
}

void Init_gtk_check_menu_item()
{
    gCMenuItem = rb_define_class_under(mGtk, "CheckMenuItem", gMenuItem);

    rb_define_const(gCMenuItem, "SIGNAL_TOGGLED", rb_str_new2("toggled"));

    rb_define_method(gCMenuItem, "initialize", cmitem_initialize, -1);
    rb_define_method(gCMenuItem, "set_state", cmitem_set_state, 1);
    rb_define_method(gCMenuItem, "set_active", cmitem_set_active, 1);
    rb_define_method(gCMenuItem, "active=", cmitem_set_active, 1);
    rb_define_method(gCMenuItem, "active?", cmitem_is_active, 0);
    rb_define_method(gCMenuItem, "set_show_toggle", cmitem_set_show_toggle, 1);
    rb_define_method(gCMenuItem, "toggled", cmitem_toggled, 0);
}

/*
 * RadioMenuItem
 */
static VALUE
rmitem_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE arg1, arg2;
    GtkWidget *widget;
    GSList *list = NULL;
    char *label = NULL;
    
    if (rb_scan_args(argc, argv, "02", &arg1, &arg2) == 1 &&
	TYPE(arg1) == T_STRING) {
	label = RSTRING(arg1)->ptr;
    }
    else {
	if (!NIL_P(arg2)) {
	    label = STR2CSTR(arg2);
	}
	if (rb_obj_is_kind_of(arg1, gRMenuItem)) {
	    GtkWidget *b = get_widget(arg1);
	    list = GTK_RADIO_MENU_ITEM(b)->group;
	}
	else {
	    list = ary2gslist(arg1);
	}
    }
    if (label) {
	widget = gtk_radio_menu_item_new_with_label(list, label);
    }
    else {
	widget = gtk_radio_menu_item_new(list);
    }
    set_widget(self, widget);
    return Qnil;
}

static VALUE
rmitem_group(self)
    VALUE self;
{
    return gslist2ary(gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(get_widget(self))));
}

void Init_gtk_radio_menu_item()
{
    gRMenuItem = rb_define_class_under(mGtk, "RadioMenuItem", gCMenuItem);

    rb_define_method(gRMenuItem, "initialize", rmitem_initialize, -1);
    rb_define_method(gRMenuItem, "group", rmitem_group, 0);
}

/*
 * TearoffMenuItem
 */
static VALUE
tmitem_initialize(self)
    VALUE self;
{
    GtkWidget *widget;

    widget = gtk_tearoff_menu_item_new();
    set_widget(self, widget);
    return Qnil;
}

void Init_gtk_tearoff_menu_item()
{
    gTMenuItem = rb_define_class_under(mGtk, "TearoffMenuItem", gMenuItem);

    rb_define_method(gTMenuItem, "initialize", tmitem_initialize, 0);
}

/*
 * TreeItem
 */
static VALUE
titem_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_tree_item_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_tree_item_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
titem_set_subtree(self, subtree)
    VALUE self, subtree;
{
    gtk_tree_item_set_subtree(GTK_TREE_ITEM(get_widget(self)),
			      get_widget(subtree));
    return self;
}

static VALUE
titem_select(self)
    VALUE self;
{
    gtk_tree_item_select(GTK_TREE_ITEM(get_widget(self)));
    return self;
}

static VALUE
titem_deselect(self)
    VALUE self;
{
    gtk_tree_item_deselect(GTK_TREE_ITEM(get_widget(self)));
    return self;
}

static VALUE
titem_expand(self)
    VALUE self;
{
    gtk_tree_item_expand(GTK_TREE_ITEM(get_widget(self)));
    return self;
}

static VALUE
titem_collapse(self)
    VALUE self;
{
    gtk_tree_item_collapse(GTK_TREE_ITEM(get_widget(self)));
    return self;
}

void Init_gtk_tree_item()
{
    gTreeItem = rb_define_class_under(mGtk, "TreeItem", gItem);

    rb_define_const(gTreeItem, "SIGNAL_EXPAND", rb_str_new2("expand"));
    rb_define_const(gTreeItem, "SIGNAL_COLLAPSE", rb_str_new2("collapse"));

    rb_define_method(gTreeItem, "initialize", titem_initialize, -1);
    rb_define_method(gTreeItem, "set_subtree", titem_set_subtree, 1);
    rb_define_method(gTreeItem, "select", titem_select, 0);
    rb_define_method(gTreeItem, "deselect", titem_deselect, 0);
    rb_define_method(gTreeItem, "expand", titem_expand, 0);
    rb_define_method(gTreeItem, "collapse", titem_collapse, 0);
}
