""" NewBuiltins - Provides and installs addons for Python from the C
                  extension package mxTools.

    (c) Copyright Marc-Andre Lemburg; All Rights Reserved.
    See the documentation for further information on copyrights,
    or contact the author (mal@lemburg.com).
"""
import sys,types,operator
from mxTools import *
from mxTools import __version__

# Helper
def install_objects(namespace,objects,

		    DictType=types.DictType):

    """ Install all the given objects in namespace.

        Doesn't overwrite anything already defined in module.
    """
    for obj in objects:
	try:
	    name = obj.__name__
	except AttributeError:
	    try:
		name,obj = obj
	    except TypeError:
		name = repr(obj)
	if name[:2] != '__' and not namespace.has_key(name):
	    namespace[name] = obj

### You can control automatic installation with this if-statement.
### Replace the 1 with 0 to disable automatic install.
if 1:

    ### Note that undocumented functions may well disappear in
    ### future releases !!!

    # New APIs and objects that go into __builtins__
    install_objects(__builtins__,
		    (NotGiven,
		     ('True',True),
		     ('False',False),
		     acquire, 
		     attrlist,
		     count, 
		     defined,
		     dict, 
		     exists,
		     extract, 
		     findattr,
		     forall, 
		     frange,		# undocumented
		     get, 
		     ifilter,
		     index, 
		     indices, 
		     invdict,
		     irange, 
		     iremove,
		     issequence,	# undocumented
		     lists, 
		     mapply,
		     method_mapply, 
		     #mget,		# old
		     #mgetattr, 	# old
		     napply,
		     #optimization, 	# moved to sys
		     projection,	# undocumented
		     range_len,
		     reverse, 
		     setdict,
		     sizeof, 
		     sortedby,		# undocumented
		     trange,
		     #trange_len, 	# old
		     tuples,
		     #verbosity,	# moved to sys
		     xmap,
		     )
		    )

    # New APIs for the sys module
    install_objects(sys.__dict__,
		    (optimization, 
		     verbosity,
		     cur_frame,
		     )
		    )
		
