/********************************************************************************
*                                                                               *
*                       M e n u   C a s c a d e   W i d g e t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuCascade.cpp,v 1.4 1999/10/20 03:39:09 jeroen Exp $                 *
********************************************************************************/
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXMenuPane.h"
#include "FXMenuCaption.h"
#include "FXMenuCascade.h"

/*
  Notes:
  - Accelerators.
  - Help text from constructor is third part; second part should be
    accelerator key combination.
  - When menu label changes, hotkey might have to be adjusted.
  - Fix it so menu stays up when after Alt-F, you press Alt-E.
  - MenuItems should be derived from FXLabel.
  - FXMenuCascade should send ID_POST/IDUNPOST to self.
  - Look into SEL_FOCUS_SELF some more...
*/


#define LEADSPACE   22
#define TRAILSPACE  16

/*******************************************************************************/

// Map
FXDEFMAP(FXMenuCascade) FXMenuCascadeMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMenuCascade::onPaint),
  FXMAPFUNC(SEL_ENTER,0,FXMenuCascade::onEnter),
  FXMAPFUNC(SEL_LEAVE,0,FXMenuCascade::onLeave),
  FXMAPFUNC(SEL_TIMEOUT,FXMenuCascade::ID_MENUTIMER,FXMenuCascade::onTimeout),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXMenuCascade::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXMenuCascade::onLeftBtnRelease),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS,0,FXMenuCascade::onDefault),
  FXMAPFUNC(SEL_MIDDLEBUTTONRELEASE,0,FXMenuCascade::onDefault),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS,0,FXMenuCascade::onDefault),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE,0,FXMenuCascade::onDefault),
  FXMAPFUNC(SEL_KEYPRESS,0,FXMenuCascade::onKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXMenuCascade::onKeyRelease),
  FXMAPFUNC(SEL_KEYPRESS,FXWindow::ID_HOTKEY,FXMenuCascade::onHotKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,FXWindow::ID_HOTKEY,FXMenuCascade::onHotKeyRelease),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_POST,FXMenuCascade::onCmdPost),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_UNPOST,FXMenuCascade::onCmdUnpost),
  };


// Object implementation
FXIMPLEMENT(FXMenuCascade,FXMenuCaption,FXMenuCascadeMap,ARRAYNUMBER(FXMenuCascadeMap))


// Make cascade menu button
FXMenuCascade::FXMenuCascade(FXComposite* p,const FXString& text,FXIcon* ic,FXMenuPane* pup,FXuint opts):
  FXMenuCaption(p,text,ic,opts){
  defaultCursor=getApp()->rarrowCursor;
  flags|=FLAG_ENABLED;
  pane=pup;
  timer=NULL;
  }


// Create window
void FXMenuCascade::create(){
  FXMenuCaption::create();
  if(pane) pane->create();
  }


// Detach X window
void FXMenuCascade::detach(){
  if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
  FXMenuCaption::detach();
  if(pane) pane->detach();
  }


// Destroy window
void FXMenuCascade::destroy(){
  if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
  FXMenuCaption::destroy();
  }


// If window can have focus
FXbool FXMenuCascade::canFocus() const { 
  return 1; 
  }


// When pressed, perform ungrab, then process normally
long FXMenuCascade::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONPRESS),ptr)) return 1;
    handle(this,MKUINT(ID_POST,SEL_COMMAND),ptr);
    return 1;
    }
  return 0;
  }


// Released left button
long FXMenuCascade::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONRELEASE),ptr)) return 1;
    if(event->moved){
      getParent()->handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),ptr);
      }
    return 1;
    }
  return 0;
  }


// Keyboard press; forward to submenu pane
long FXMenuCascade::onKeyPress(FXObject*,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    FXTRACE((200,"%s::onKeyPress %08x keysym=0x%04x state=%04x\n",getClassName(),this,event->code,event->state));
    if(target && target->handle(this,MKUINT(message,SEL_KEYPRESS),ptr)) return 1;
    if(pane && pane->shown() && pane->handle(pane,sel,ptr)) return 1;
    switch(event->code){
      case KEY_Right: 
        if(pane && !pane->shown()){
          FXint x,y;
          if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
          translateCoordinatesTo(x,y,getRoot(),width,0);
          pane->popup(((FXMenuPane*)getParent())->getGrabOwner(),x,y);
          return 1;
          }
        break;
      case KEY_Left:  
        if(pane && pane->shown()){
          if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
          pane->popdown();
          return 1;
          }
        break;
      case KEY_KP_Enter:
      case KEY_Return:
      case KEY_space:
      case KEY_KP_Space:
        handle(this,MKUINT(ID_POST,SEL_COMMAND),ptr);
        return 1;
      }
    }
  return 0;
  }


// Keyboard release; forward to submenu pane
long FXMenuCascade::onKeyRelease(FXObject*,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    FXTRACE((200,"%s::onKeyRelease %08x keysym=0x%04x state=%04x\n",getClassName(),this,event->code,event->state));
    if(target && target->handle(this,MKUINT(message,SEL_KEYRELEASE),ptr)) return 1;
    if(pane && pane->shown() && pane->handle(pane,sel,ptr)) return 1;
    switch(event->code){
      case KEY_Right: 
      case KEY_Left:  
        return 1;
      case KEY_KP_Enter:
      case KEY_Return:
      case KEY_space:
      case KEY_KP_Space:
        return 1;
      }
    }
  return 0;
  }


// Hot key combination pressed
long FXMenuCascade::onHotKeyPress(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyPress %08x\n",getClassName(),this));
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    handle(this,MKUINT(ID_POST,SEL_COMMAND),ptr);
    }
  return 1;
  }


// Hot key combination released
long FXMenuCascade::onHotKeyRelease(FXObject*,FXSelector,void*){
  FXTRACE((200,"%s::onHotKeyRelease %08x\n",getClassName(),this));
  return 1;
  }


// Post the menu
long FXMenuCascade::onCmdPost(FXObject*,FXSelector,void*){
  if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
  if(pane && !pane->shown()){
    FXint x,y;
    translateCoordinatesTo(x,y,getRoot(),width,0);
    pane->popup(((FXMenuPane*)getParent())->getGrabOwner(),x,y);
    }
  return 1;
  }


// Unpost the menu
long FXMenuCascade::onCmdUnpost(FXObject*,FXSelector,void*){
  if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
  if(pane && pane->shown()){
    pane->popdown();
    }
  return 1;
  }


// Into focus chain
void FXMenuCascade::setFocus(){
  FXMenuCaption::setFocus();
  flags|=FLAG_ACTIVE;
  flags&=~FLAG_UPDATE;
  update();
  }


// Out of focus chain; hide submenu if it was up
void FXMenuCascade::killFocus(){
  FXMenuCaption::killFocus();
  handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),NULL);
  flags&=~FLAG_ACTIVE;
  flags|=FLAG_UPDATE;
  update();
  }


// Enter; set timer for delayed popup
long FXMenuCascade::onEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXMenuCaption::onEnter(sender,sel,ptr);
  if(isEnabled() && canFocus()){
    if(!timer){ timer=getApp()->addTimeout(getApp()->menuPause,this,ID_MENUTIMER); }
    setFocus();
    }
  return 1;
  }


// Leave
long FXMenuCascade::onLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXMenuCaption::onLeave(sender,sel,ptr);
  if(timer){ getApp()->removeTimeout(timer); timer=NULL; }
  return 1;
  }


// Timeout; pop up the submenu
long FXMenuCascade::onTimeout(FXObject*,FXSelector,void* ptr){
  timer=NULL;
  handle(this,MKUINT(ID_POST,SEL_COMMAND),ptr);
  return 1;
  }


// Handle repaint 
long FXMenuCascade::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint yy;
  
  // Grayed out
  if(!isEnabled()){
    dc.setForeground(backColor);
    dc.fillRectangle(0,0,width,height);
    if(icon){
      dc.drawIconShaded(icon,3,(height-icon->getHeight())/2);
      }
    if(!label.empty()){
      yy=font->getFontAscent()+(height-font->getFontHeight())/2;
      dc.setTextFont(font);
      dc.setForeground(hiliteColor);
      dc.drawText(LEADSPACE+1,yy+1,label.text(),label.length());
      dc.setForeground(shadowColor);
      dc.drawText(LEADSPACE,yy,label.text(),label.length());
      if(0<=hotoff){
        dc.drawLine(LEADSPACE+1+font->getTextWidth(label.text(),hotoff),yy+1,LEADSPACE+font->getTextWidth(label.text(),hotoff+1),yy+1);
        }
      }
    }

  // Active
  else if(isActive()){
    dc.setForeground(selbackColor);
    dc.fillRectangle(1,1,width-2,height-2);
    if(icon){
      dc.drawIcon(icon,3,(height-icon->getHeight())/2);
      }
    if(!label.empty()){
      yy=font->getFontAscent()+(height-font->getFontHeight())/2;
      dc.setTextFont(font);
      dc.setForeground(isEnabled() ? seltextColor : shadowColor);
      dc.drawText(LEADSPACE,yy,label.text(),label.length());
      if(options&MENU_DEFAULT){
        dc.drawText(LEADSPACE+1,1+font->getFontAscent(),label.text(),label.length());
        }
      if(0<=hotoff){
        dc.drawLine(LEADSPACE+1+font->getTextWidth(label.text(),hotoff),yy+1,LEADSPACE+font->getTextWidth(label.text(),hotoff+1),yy+1);
        }
      }
    }

  // Normal
  else{
    dc.setForeground(backColor);
    dc.fillRectangle(0,0,width,height);
    if(icon){
      dc.drawIcon(icon,3,(height-icon->getHeight())/2);
      }
    if(!label.empty()){
      yy=font->getFontAscent()+(height-font->getFontHeight())/2;
      dc.setTextFont(font);
      dc.setForeground(textColor);
      dc.drawText(LEADSPACE,yy,label.text(),label.length());
      if(options&MENU_DEFAULT){
        dc.drawText(LEADSPACE+1,yy,label.text(),label.length());
        }
      if(0<=hotoff){
        dc.drawLine(LEADSPACE+1+font->getTextWidth(label.text(),hotoff),yy+1,LEADSPACE+font->getTextWidth(label.text(),hotoff+1),yy+1);
        }
      }
    }
  dc.setForeground(isActive() ? seltextColor : textColor);
  yy=(height-8)/2;
  drawTriangle(dc,width-TRAILSPACE+4,yy,width-TRAILSPACE+4+6,yy+8);
  return 1;
  }


// Draw triangle
void FXMenuCascade::drawTriangle(FXDCWindow& dc,FXint l,FXint t,FXint r,FXint b){
  FXPoint points[3];
  int m=(t+b)/2;
  points[0].x=l;
  points[0].y=t;
  points[1].x=l;
  points[1].y=b;
  points[2].x=r;
  points[2].y=m;
  dc.fillPolygon(points,3);
  }


// Test if logically inside
FXbool FXMenuCascade::contains(FXint parentx,FXint parenty) const {
  FXint x,y;
  if(FXMenuCaption::contains(parentx,parenty)) return 1;
  if(getPopup() && getPopup()->shown()){
    getParent()->translateCoordinatesTo(x,y,getRoot(),parentx,parenty);
    if(getPopup()->contains(x,y)) return 1;
    }
  return 0;
  }


// Save object to stream
void FXMenuCascade::save(FXStream& store) const {
  FXMenuCaption::save(store);
  store << pane;
  }


// Load object from stream
void FXMenuCascade::load(FXStream& store){
  FXMenuCaption::load(store);
  store >> pane;
  }  


// Delete it
FXMenuCascade::~FXMenuCascade(){
  pane=(FXMenuPane*)-1;
  timer=(FXTimer*)-1;
  }

