#! /bin/sh

trap 'rm -rf glibc-2.1.3' 1 2 3 13 15

unpack()
{
    local tarfile srcdir destdir compressprog status
    tarfile=$1
    if [ ! -r $tarfile ]; then
	echo "E: $tarfile does not exist."
	exit 1
    fi
    # $2 is "in"
    srcdir=${3}/
    # $4 is "creating"
    destdir=$5
    case $tarfile in
	*.tar.bz2)
	    compressprog=bzip2
	    ;;
	*.tar.gz)
	    compressprog=gzip
	    ;;
    esac
    echo "I: Unpacking ${tarfile} in ${destdir}."
    tar --use-compress-program=$compressprog -C $srcdir -xf ${srcdir}${tarfile}
    status=$?
    if [ $status -gt 0 ]; then
	echo "E: subprocess (tar) exited with $status exit status."
	exit 1
    fi
}

overlay()
{
    local srcdir tarfile destdir compressprog status
    srcdir=$(pwd)/
    tarfile=$1
    if [ ! -r $tarfile ]; then
	echo "E: $tarfile does not exist."
	exit 1
    fi
    # $2 is "on"
    destdir=$(pwd)/$3
    case $tarfile in
	*.tar.bz2)
	    compressprog=bzip2
	    ;;
	*.tar.gz)
	    compressprog=gzip
	    ;;
    esac
    echo "I: Overlaying ${tarfile} on ${destdir}."
    tar --use-compress-program=$compressprog -C $destdir -xf ${srcdir}${tarfile}
    status=$?
    if [ $status -gt 0 ]; then
	echo "E: subprocess (tar) exited with $status exit status."
	exit 1
    fi
}

patch()
{
    local srcdir origdir newdir patchfile strip compressprog status
    srcdir=$(pwd)/
    origdir=$1
    # $2 is "to"
    if [ "$2" != "inplace" ]; then
	newdir=$3
	# $4 is "with" or "using"
	patchfile=$5
	if [ ! -r $patchfile ]; then
	    echo "E: $patchfile does not exist."
	    exit 1
	fi
	# $6 is "strip"
	strip=$7
	if [ ! -d $newdir ] && [ -d $origdir ]; then
	    echo "I: Moving $origdir to $newdir for patching."
	    mv $origdir $newdir
	fi
    else
	newdir=${origdir}
	patchfile=$4
	strip=$6
    fi
    echo "I: Patching $newdir with $patchfile."
    case $patchfile in
	*.bz2)
	    compressprog=bzip2
	    ;;
	*.gz)
	    compressprog=gzip
	    ;;
    esac
	    ($compressprog -dc ${srcdir}${patchfile} | \
	    command patch -d $newdir --no-backup-if-mismatch -p${strip})
	    status=$?
	    if [ $status -gt 0 ]; then
		echo "E: subprocess (patch) exited with $status exit status."
		exit 1
	    fi
}

unpack glibc-2.1.3.tar.bz2 in . creating glibc-2.1.3
overlay glibc-crypt-2.1.tar.gz on glibc-2.1.3
overlay glibc-linuxthreads-2.1.3.tar.bz2 on glibc-2.1.3
overlay glibc-nss-v1-2.0.3.tar.gz on glibc-2.1.3
#patch glibc-2.1.2 to glibc-2.1.3 with 2.1.3-2000.01.31.diff.bz2 stripping 1