/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_dibaudio.h,v 1.3 1999/11/23 19:01:40 hercules Exp $";
#endif

#ifndef _SDL_lowaudio_h
#define _SDL_lowaudio_h

#include "SDL_sysaudio.h"

/* Hidden "this" pointer for the video functions */
#define _THIS	SDL_AudioDevice *this

#define NUM_BUFFERS 2			/* -- Don't lower this! */

struct SDL_PrivateAudioData {
	HWAVEOUT sound;
	Uint8 *mixbuf;		/* The raw allocated mixing buffer */
	int last_queued;
	SDL_mutex *audio_wait;

	SDL_mutex *var_lock; /* protects SHARED memory */
  	  volatile int SHARED_buffers_queued;
  	  volatile Uint8  SHARED_playing;

	WAVEHDR wavebuf[NUM_BUFFERS];	/* Wave audio fragments */
};

/* Old variable names */
#define sound			(this->hidden->sound)
#define mixbuf			(this->hidden->mixbuf)
#define last_queued		(this->hidden->last_queued)
#define audio_wait 		(this->hidden->audio_wait )
#define var_lock 		(this->hidden->var_lock )
#define SHARED_buffers_queued 	(this->hidden->SHARED_buffers_queued )
#define SHARED_playing		(this->hidden->SHARED_playing)
#define wavebuf			(this->hidden->wavebuf)

#endif /* _SDL_lowaudio_h */
