
#include "input.h"
#include <vdk/forms.h>
class VDKForm;

VDKInput::VDKInput(VDKForm* obj,int fd, GdkInputCondition c):
        VDKObject(obj), tag(0), fd(fd),condition(c)
{
    tag = gdk_input_add(fd, c, VDKInput::HandleIO, this);
    obj->Objects().add(this);
    Parent(obj);
}

VDKInput::~VDKInput()
{
    if(tag)
        gdk_input_remove(tag);
}

void VDKInput::HandleIO(gpointer gp, gint source, GdkInputCondition condition)
{
  VDKInput *ip = static_cast<VDKInput*>(gp);
  ip->condition = condition;
  ip->SignalEmit(INP_SIGNAL);
}
