/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  TEXT_H
#define  TEXT_H

#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
/*
 */
class VDKTextFont
{
 public:
  GdkColor *foreground, *background;
  VDKFont* font;
  VDKTextFont(): foreground((GdkColor*) NULL),
    background((GdkColor*) NULL),
    font((VDKFont*) NULL) {}
  ~VDKTextFont() {}
};


class VDKText: public VDKObject
{
 protected:
 static int KeyEvent(GtkWidget *wid, GdkEventKey* ev,gpointer gp);
 protected:
  GtkWidget *text,*scrollbar;
 public:
  // properties
VDKTextFont TextFont;
VDKReadWriteValueProp<VDKText,bool>  WordWrap;
VDKReadWriteValueProp<VDKText,bool>  Editable;
VDKReadWriteValueProp<VDKText,int>   Pointer;
VDKReadOnlyValueProp<VDKText,unsigned int> Length;
bool Changed;
  VDKText(VDKForm* owner,bool editable = false, bool override = false);
  virtual ~VDKText();
  int LoadFromFile(char* filename);
  int SaveToFile(char* filename);
  virtual void SetBackground(VDKRgb color, 
			     GtkStateType state = GTK_STATE_NORMAL);
  virtual void SetFont(VDKFont* font);
  void TextInsert(char* text, int nchars = -1);
  void Freeze() { gtk_text_freeze(GTK_TEXT(text)); }
  void Thaw() { gtk_text_thaw(GTK_TEXT(text)); }
  void Eol() { TextInsert("\n"); }
  int  BackwardDelete(int nchars)
    { 
      Changed = true;
      return gtk_text_backward_delete(GTK_TEXT(text),nchars); 
    }
  int  ForwardDelete(int nchars)
    { 
      Changed = true;
      return gtk_text_forward_delete(GTK_TEXT(text),nchars); 
    }
  char* GetChars(int start, int end = -1)
    { return gtk_editable_get_chars(GTK_EDITABLE(text),start,end); }
  int GetPointer() { return gtk_text_get_point(GTK_TEXT(text)); }
  void SetPointer(int pos) { gtk_text_set_point(GTK_TEXT(text),pos); }
  bool GetWordWrap() { return WordWrap; }
  void SetWordWrap(bool flag)
    { gtk_text_set_word_wrap(GTK_TEXT(text),flag); }
  bool GetEditable () { return Editable; }
  void SetEditable(bool flag)
    { gtk_text_set_editable(GTK_TEXT(text),flag); }
  void Clear();
  unsigned int GetLength() 
    { return gtk_text_get_length(GTK_TEXT(text)); }
  
  
};
#endif
