/*								-*- C++ -*-
 * $Id: WIN_window.h,v 1.3 1999/03/30 21:53:16 wg Exp $
 *
 * Purpose: base class for all windows
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Window_h
#define Window_h

#ifdef __GNUG__
#pragma interface "WIN_window.h"
#endif

class wxBitmap;
class wxColour;
class wxColourMap;
class wxCommandEvent;
class wxCursor;
class wxFont;
class wxItem;
class wxKeyEvent;
class wxLayoutConstraints;
class wxList;
class wxMenu;
class wxMouseEvent;
class wxPanel;
class wxRectangle;
class wxSizer;
class wxWindow_Xintern;

class wxWindow : public wxEvtHandler {
DECLARE_DYNAMIC_CLASS(wxWindow)
public:
    wxWindow(void);
    ~wxWindow(void);

    // access to Xt private data
#ifdef Have_Xt_Types
    Widget&   FWidget(void); // widget of frame
    Widget&   PWidget(void); // widget of private frame
    Widget&   HWidget(void); // widget of handle
    Widget&   GetParentWidget(wxWindow *parent); // parent widget
#endif    
    // close window
    Bool Close(Bool force = FALSE);
    // child - parent relationships
    wxList*   GetChildren(void) { return &children; }
    wxWindow* GetGrandParent() const;
    wxWindow* GetParent() const { return parent; }
    void      SetParent(wxWindow *p) { parent = p; }
    void      AddChild(wxWindow *child);
    void      DestroyChildren(void);
    void      RemoveChild(wxWindow *child);
    // label, name, title of wxWindow
    virtual char* GetLabel(void);
    virtual char* GetName(void);
    virtual char* GetTitle(void);
    virtual void  SetLabel(char *label);
    virtual void  SetName(char *name);
    virtual void  SetTitle(char *title);
    // translate coordinates to/from screen
    virtual void  ClientToScreen(int *x, int *y);
    virtual void  ScreenToClient(int *x, int *y);
    // set & query size and position of wxWindow
    virtual void  Centre(int direction = wxBOTH);
    virtual void  GetClientPosition(int *x, int *y);
    virtual void  GetClientSize(int *width, int *height);
    virtual void  GetPosition(int *x, int *y);
    virtual void  GetSize(int *width, int *height);
    virtual void  SetClientSize(int x, int y, int width, int height);
    virtual void  SetSize(int x, int y, int width, int height,
			  int flags=wxSIZE_AUTO);
    // allow shorter access
    virtual void  Move(int x, int y)
	{ SetSize(x, y, -1, -1, wxSIZE_USE_EXISTING); }
    virtual void  SetClientSize(int width, int height)
	{ SetClientSize(-1, -1, width, height); }
    virtual void  SetSize(int width, int height)
	{ SetSize(-1, -1, width, height, wxSIZE_USE_EXISTING); }
    // GDI (colours, colourmap, font, cursor)
    virtual void      ChangeColours(void);
    virtual wxColour  *GetBackgroundColour(void) { return &bg; }
    virtual float     GetCharHeight(void);
    virtual float     GetCharWidth(void);
    virtual wxFont    *GetFont(void);
    virtual wxColour  *GetForegroundColour(void) { return &fg; }
    virtual void      GetTextExtent(const char *string, float *x, float *y,
				    float *descent = NULL,
				    float *externalLeading = NULL,
				    wxFont *theFont=NULL, Bool use16bit=FALSE);
    virtual void      SetBackgroundColour(wxColour &col);
    virtual void      SetBusyCursor(wxCursor *cursor);
    virtual void      SetColourMap(wxColourMap *cmap);
    virtual wxCursor  *SetCursor(wxCursor *cursor);
    virtual void      SetFont(wxFont *font);
    virtual void      SetForegroundColour(wxColour &col);
    // Caret
    virtual void  CreateCaret(int WXUNUSED(w), int WXUNUSED(h)) {}
    virtual void  CreateCaret(wxBitmap *WXUNUSED(bitmap)) {}
    virtual void  DestroyCaret(void) {}
    virtual void  ShowCaret(Bool WXUNUSED(show)) {}
    virtual void  SetCaretPos(int WXUNUSED(x), int WXUNUSED(y)) {}
    virtual void  GetCaretPos(int *WXUNUSED(x), int *WXUNUSED(y)) {}
    // scrollbars
    virtual void  SetScrollbars(int h_pixels, int v_pixels,
				int x_len, int y_len,
				int x_page, int y_page,
				int x_pos=0, int y_pos=0,
				Bool setVirtualSize = TRUE);
    // set and get virtual window size
	    int   GetScrollRange(int orient);
    virtual void  GetVirtualSize(int *w, int *h);
	    void  SetScrollRange(int orient, int range);
    virtual void  SetVirtualSize(int hsize, int vsize);
    // set and get virtual window position
	    int   GetScrollPos(int orient);
    virtual void  Scroll(int x_pos, int y_pos);
	    void  SetScrollPos(int orient, int pos);
    virtual void  ViewStart(int *x, int *y);
    // scroll page size
    virtual int   GetScrollPage(int orient);
    virtual void  SetScrollPage(int orient, int range);
#if USE_CONSTRAINTS
    // layout create and destroy
    void InitConstraints(void);
    void DestroyConstraints(void);
    // Julians layout code
    virtual void SetAutoLayout(Bool a) { autoLayout = a; }
    virtual Bool GetAutoLayout(void) { return autoLayout; }
    wxLayoutConstraints *GetConstraints(void) { return constraints; }
    void SetConstraints(wxLayoutConstraints *c);
    void UnsetConstraints(wxLayoutConstraints *c);
    wxList *GetConstraintsInvolvedIn(void) { return constraintsInvolvedIn; }
    void AddConstraintReference(wxWindow *otherWin);
    void RemoveConstraintReference(wxWindow *otherWin);
    void DeleteRelatedConstraints(void);
    Bool Layout(void);
    virtual void SetSizer(wxSizer *sizer);
    virtual wxSizer *GetSizer(void);
    virtual wxWindow *GetSizerParent(void);
    virtual void SetSizerParent(wxWindow *win) { sizerParent = win; }
    virtual void ResetConstraints(void);
    virtual void SetConstraintSizes(Bool recurse = TRUE);
    virtual Bool LayoutPhase1(int *noChanges);
    virtual Bool LayoutPhase2(int *noChanges);
    virtual Bool DoPhase(int);
    virtual void TransformSizerToActual(int *x, int *y);
    virtual void SizerSetSize(int x, int y, int w, int h);
    virtual void SizerMove(int x, int y);
    virtual void SetSizeConstraint(int x, int y, int w, int h);
    virtual void MoveConstraint(int x, int y);
    virtual void GetSizeConstraint(int *w, int *h);
    virtual void GetClientSizeConstraint(int *w, int *h);
    virtual void GetPositionConstraint(int *x, int *y);
#endif
    // miscellaneous
    virtual void  AllowDoubleClick(Bool allow);
    virtual void  CaptureMouse(void);
    virtual void  DragAcceptFiles(Bool accept);
    virtual void  Enable(Bool enable);
    virtual Bool  Enabled(void);
    virtual void  EnablePainting(Bool enable);
    virtual void  Fit(void) {}
    virtual Bool  GetUserEditMode(void);
    virtual long  GetWindowStyleFlag(void);
    virtual void  GrabMouse(wxCursor *cursor);
    virtual Bool  IsMapped(void);
    virtual Bool  IsSelected(void);
    virtual Bool  IsShown(void);
    virtual void  Paint(void);
    virtual Bool  PopupMenu(wxMenu *menu, float x, float y);
    virtual void  Refresh(Bool eraseBack=TRUE, wxRectangle *rect=NULL,
			  int count=0);
    virtual void  ReleaseMouse(void);
    virtual void  SelectItem(Bool select);
    virtual void  SetFocus(void);
    virtual void  SetUserEditMode(Bool edit);
    virtual void  SetWindowStyleFlag(long flag);
    virtual Bool  Show(Bool show);
    virtual void  UngrabMouse(void);
    // event handling
    virtual wxEvtHandler *GetEventHandler(void)
	{ return event_handler; }
    virtual void SetEventHandler(wxEvtHandler *handler)
	{ event_handler = handler; }
    virtual void OnActivate(Bool active);
    virtual void OnChar(wxKeyEvent& event);
    virtual Bool OnCharHook(wxKeyEvent& event);
    virtual void OnCommand(wxWindow& win, wxCommandEvent& event);
    virtual void OnDefaultAction(wxItem *initiatingItem);
    virtual void OnEvent(wxMouseEvent& event);
    virtual void OnPaint(void);
    virtual void OnScroll(wxCommandEvent& event);
    virtual void OnSize(int width, int height);
    // get the associated device context (create one if it doesn't exist yet)
    wxWindowDC* GetDC(void);
    // methods of the associated device context
    void      AutoSetTools(Bool set_auto);
    void      BeginDrawing(void);
    Bool      Blit(float xdest, float ydest, float w, float h,
		   wxDC *src, float xsrc, float ysrc, int rop=wxCOPY);
    Bool      CanGetTextExtent() const { return TRUE; }
    Bool      CanDrawBitmap() const { return TRUE; }
    void      Clear(void);
    void      CrossHair(float x, float y);
    void      DestroyClippingRegion(void);
    float     DeviceToLogicalX(int x) const;
    float     DeviceToLogicalXRel(int x) const;
    float     DeviceToLogicalY(int y) const;
    float     DeviceToLogicalYRel(int y) const;
    void      DrawArc(float x1, float y1, float x2, float y2,
		      float xc, float yc);
    void      DrawBitmap8(unsigned char *data, int w, int h,
			  wxColourMap *cmap, float x, float y);
    void      DrawEllipse(float x, float y, float w, float h);
    void      DrawIcon(wxBitmap *icon, float x, float y, Bool useMask=FALSE);
    void      DrawLine(float x1, float y1, float x2, float y2);
    void      DrawLines(int n, wxPoint pts[], float xoff=0, float yoff=0);
    void      DrawLines(int n, wxIntPoint pts[], int xoff=0, int yoff=0);
    void      DrawLines(wxList *pts, float xoff=0, float yoff=0);
    void      DrawPoint(float x, float y);
    void      DrawPoint(wxPoint &pt) { DrawPoint(pt.x, pt.y); }
    void      DrawPolygon(int n, wxPoint pts[], float xoff=0, float yoff=0,
			  int fill=wxODDEVEN_RULE);
    void      DrawPolygon(wxList *pts, float xoff=0, float yoff=0,
			  int fill=wxODDEVEN_RULE);
    void      DrawRectangle(float x, float y, float w, float h);
    void      DrawRoundedRectangle(float x, float y, float w, float h,
				   float radius=20);
#if USE_SPLINES
    void      DrawSpline(float x1,float y1,float x2,float y2,float x3,float y3);
    void      DrawSpline(int n, wxPoint pts[]);
    void      DrawSpline(wxList *pts);
#endif
    void      DrawText(const char *text, float x, float y, Bool use16Bit=FALSE);
    void      EndDrawing(void);
    void      FloodFill(float x, float y, wxColour *col,
			int style=wxFLOOD_SURFACE);
    wxBrush*  GetBackground(void);
    wxBrush*  GetBrush(void);
    void      GetClippingRegion(float *x, float *y, float *w, float *h);
    int       GetLogicalFunction(void);
    int       GetMapMode(void);
    Bool      GetOptimization(void);
    wxPen*    GetPen(void);
    Bool      GetPixel(float x, float y, wxColour *col);
    void      GetSize(float *w, float *h);
    int       GetTextAlignment(void);
    wxColour& GetTextBackground(void);
    wxColour& GetTextForeground(void);
    wxCursor* GetCursor() const { return cursor; }
    void      IntDrawLine(int x1, int y1, int x2, int y2);
    void      IntDrawLines(int n, wxIntPoint pts[], int xoff=0, int yoff=0);
    int       LogicalToDeviceX(float x);
    int       LogicalToDeviceXRel(float x);
    int       LogicalToDeviceY(float y);
    int       LogicalToDeviceYRel(float y);
    float     MaxX(void);
    float     MaxY(void);
    float     MinX(void);
    float     MinY(void);
    Bool      Ok(void);
    void      ScaleGDIClasses(Bool gdi_scaling=TRUE);
    void      SetAxisOrientation(Bool x_left_right, Bool y_bottom_up);
    void      SetBackground(wxBrush *brush);
    void      SetBackgroundMode(int mode);
    void      SetBrush(wxBrush *brush);
    void      SetClippingRegion(float x, float y, float w, float h);
    void      SetDeviceOrigin(float x, float y);
    void      SetLogicalFunction(int fkt);
    void      SetLogicalOrigin(float x, float y);
    void      SetLogicalScale(float xs, float ys);
    void      SetMapMode(int mode);
    void      SetOptimization(Bool opt);
    void      SetPen(wxPen *pen);
    void      SetTextAlignment(int new_alignment);
    void      SetTextBackground(wxColour *col);
    void      SetTextForeground(wxColour *col);
    void      SetUserScale(float xs, float ys);
    // ask, if a part of the DC is exposed
    int       IsExposed(float x, float y);
    int       IsExposed(float x, float y, float width, float height);
#if WXDEBUG
    // debugging info
    void Dump(ostream& str);
#endif
protected:
    // create and destroy associated device context
    wxWindowDC* CreateDC(void);
    void        DestroyDC(void);
    // set Colormap WM Hint for this window
    void SetColourMapWMHint(void);
    // applies event handlers to window
    void AddEventHandlers(void);
    void RemoveEventHandlers(void);
    #ifdef Have_Xt_Types
    // event handlers to care for incoming events
    static void AddEventHandlers2(Widget w,   wxWindow *win,
				  XEvent *ev, Boolean *continue_dispatch);
    static void ExposeEventHandler(Widget w, wxWindow *win,XtPointer p_ExpInfo);
    static void FocusEventHandler(Widget w, wxWindow *win, Boolean *set_focus);
    static void FrameEventHandler(Widget w,   wxWindow *win,
				  XEvent *ev, Boolean *continue_dispatch);
    static void WindowEventHandler(Widget w,   wxWindow *win,
				   XEvent *ev, Boolean *continue_dispatch);
    static void ScrollEventHandler(Widget w, wxWindow *win,XtPointer p_ScrInfo);
    #endif
    // protected resize function called before OnMove and OnSize
    virtual void PreResize(int x=-1, int y=-1, int width=-1, int height=-1);
    // protected method called during first expose (widget is realized)
    virtual void AfterRealize(void);
protected:
    friend class wxUpdateIterator; // needs access to internal data

    // X representation
    wxWindow_Xintern *X;
    // device context
    wxWindowDC *dc;
    // child <-> parent relationsship
    wxWindow *parent;
    wxList   children;
    // GDI objects
    wxColour    fg, bg;
    wxColourMap cmap;
    wxCursor*   cursor;
    wxFont      font;
    // event handler (usually this)
    wxEvtHandler  *event_handler;
    // layout information
#if USE_CONSTRAINTS
    wxLayoutConstraints* constraints;
    wxList*              constraintsInvolvedIn;
    wxSizer*             windowSizer;
    wxWindow*            sizerParent;
    Bool                 autoLayout;
#endif
    // misc info
    Bool  allow_dclicks;
    Bool  captured;
    Bool  drag_accept;
    Bool  first_painting;
    Bool  painting_enabled;
    Bool  user_edit_mode;
    Bool  selected;
    Bool  mapped;
    Bool  is_shown;
    long  style;
};

// Allows iteration through damaged rectangles in OnPaint
class wxUpdateIterator : public wxObject {
DECLARE_DYNAMIC_CLASS(wxUpdateIterator)
public:
    wxUpdateIterator(wxWindow* win);
    ~wxUpdateIterator(void);

    operator int (void);
    wxUpdateIterator* operator ++(int);

    void GetRect(wxRectangle *rect);
    int  GetX() const { return cx; }
    int  GetY() const { return cy; }
    int  GetW() const { return cw; }
    int  GetH() const { return ch; }
private:
    int c, cx, cy, cw, ch;
    wxWindow *win;
};

#endif // Window_h
