;;;
;;;  cmail-20.el - cmail functions for emacs 20 / xemacs 20
;;; 
;;;  Author:        Toshihiko Ueki <toshi@he.kobelcosys.co.jp>
;;;                 maeda shugo <shugo@po.aianet.ne.jp>
;;;  Maintener:     Toshihiko Ueki <toshi@he.kobelcosys.co.jp>
;;;  Created:       1997/05/29
;;;  Last modified: 1997/08/27
;;;
;;;  Copyright (C) 1995-1997 Yukihiro Matsumoto.

;;; cmail-20.el

(provide 'cmail-20)
(require 'cmail)
(require 'cmail-highlight)
(require 'timezone)

(if (featurep 'xemacs)
    (progn
      (require 'overlay)
      (require 'cmail-x20))
  (require 'cmail-e20))

;;; @ cmail specific definition for emacs-20 / xemacs-20
;;;

(defvar cmail-insert-x-face nil
  "*If non-nil, insert X-Face file.")
(defvar cmail-x-face-file (expand-file-name "~/.x-face")
  "*Path to X-Face file.")

(defvar cmail-font-lock-keywords
  (let* ((cite-chars  "[]>}|].*")
	 (cite-prefix "A-Za-z")
	 (cite-suffix (concat cite-prefix "0-9_.@-"))
	 (content "[ \t]*\\(.+\\(\n[ \t].*\\)*\\)"))
    `((,(concat "^\\([Tt]o:\\)" content)
       (1 'cmail-header-name-face)
       (2 'cmail-header-from-face nil t))
      (,(concat "^\\(^[GBF]?[Cc][Cc]:\\|^[Rr]eply-[Tt]o:\\)" content)
       (1 'cmail-header-name-face)
       (2 'cmail-header-from-face nil t))
      (,(concat "^\\([Ss]ubject:\\)" content)
       (1 'cmail-header-name-face)
       (2 'cmail-header-subject-face nil t))
      (,(concat "^\\([A-Z][^: \n\t]+:\\)" content)
       (1 'cmail-header-name-face)
       (2 'cmail-header-content-face nil t))
      (,(concat "^\\(X-[A-Za-z0-9-]+\\|In-Reply-To\\):" content)
       (1 'cmail-header-name-face)
       (2 'cmail-header-name-face))
      (,(concat "^\\(" (regexp-quote mail-header-separator) "\\)$")
       1 'cmail-header-separator-face)
      (,(concat "^[ \t]*"
		"\\([" cite-prefix "]+[" cite-suffix "]*\\)?"
		cite-chars)
       (0 'cmail-cite-face))))
  "Additional expressions to highlight in mail mode.")

(defun cmail-insert-x-face ()
  "Insert X-Face file."
  (save-excursion 
    (goto-char (point-min))
    (insert "X-Face:")
    (insert-file cmail-x-face-file)))

(add-hook 'cmail-mail-send-hook
      '(lambda ()
	  (if cmail-insert-x-face
	      (cmail-insert-x-face))))
    
(mapcar (function
	 (lambda (hook)
	    (if cmail-highlight-mode
		(add-hook hook
		      '(lambda ()
			  (make-local-variable 'font-lock-defaults)
			  (setq font-lock-defaults '(cmail-font-lock-keywords t))
			  (font-lock-mode 1)))))) 
	'(cmail-mail-hook
	  mime/editor-mode-hook)) 

(cond (window-system
	(defun cmail-mouse-select (event)
	  (interactive "e")
	  (mouse-set-point event)
	  (cmail-read-contents (cmail-get-page-number-from-summary)))))
