#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <syslog.h>
#include <mysql/mysql.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>

#include "authmysql.h"
#include "authmysqlrc.h"

MYSQL auth_mysql_server;

/*
 * Close the mysql database
*/
int auth_mysql_disconnect(auth_mysql_config *mysql_config)
{
    if (mysql_config->sql_db)
    {
        mysql_close(mysql_config->sql_db);
    }
    mysql_config->sql_db = NULL;
    return 0;
}

/*
 * Open the mysql database with the perviously initialised datas
*/
int auth_mysql_connect(auth_mysql_config *mysql_config)
{
    auth_mysql_disconnect(mysql_config);

    if(!(mysql_config->sql_db = mysql_connect(&auth_mysql_server,
	 mysql_config->servername, mysql_config->username,
	 mysql_config->password)))
    {
#if AUTHMYSQL_DEBUG
	syslog (LOG_ERR, "Can't connect to %s@%s with pass %s", 
		mysql_config->username,
		mysql_config->servername,
		mysql_config->password);
#endif
	return -1;
    }
    return 0;
}

static const char *read_env(const char *env)
{
static char *mysqlauth=0;
static size_t mysqlauth_size;
size_t	i;
char	*p;
int	l=strlen(env);

	if (!mysqlauth)
	{
	FILE	*f=fopen(AUTHMYSQLRC, "r");
	struct	stat	buf;

		if (!f)	return (-1);
		if (fstat(fileno(f), &buf) ||
			(mysqlauth=malloc(buf.st_size+2)) == 0)
		{
			fclose(f);
			return (0);
		}
		if (fread(mysqlauth, buf.st_size, 1, f) != 1)
		{
			free(mysqlauth);
			mysqlauth=0;
			fclose(f);
			return (0);
		}
		mysqlauth[mysqlauth_size=buf.st_size]=0;

		for (i=0; i<mysqlauth_size; i++)
			if (mysqlauth[i] == '\n')
				mysqlauth[i]=0;
	}

	for (i=0; i<mysqlauth_size; )
	{
		p=mysqlauth+i;
		if (memcmp(p, env, l) == 0 &&
			isspace((int)(unsigned char)p[l]))
		{
			p += l;
			while (*p && *p != '\n' &&
				isspace((int)(unsigned char)*p))
				++p;
			break;
		}

		while (i < mysqlauth_size)
			if (mysqlauth[i++] == 0)	break;
	}

	if (i < mysqlauth_size)
		return (p);
	return (0);
}

/*
 * Read the configuration file and place it to the
 * config structure
 */
auth_mysql_config *auth_mysql_init(void) {

  auth_mysql_config *mysql_config;

  mysql_config = (auth_mysql_config *) malloc (sizeof(auth_mysql_config));
  
  if ( ((mysql_config->servername = read_env("MYSQL_SERVER")) == NULL) ||
       ((mysql_config->username = read_env("MYSQL_USERNAME")) == NULL) ||
       ((mysql_config->password = read_env("MYSQL_PASSWORD")) == NULL) ||
       ((mysql_config->database = read_env("MYSQL_DATABASE")) == NULL) ||
       ((mysql_config->user_table = read_env("MYSQL_USER_TABLE")) == NULL) ||
       ((mysql_config->defdomain = read_env("DEFAULT_DOMAIN")) == NULL) ) {
#if AUTHMYSQL_DEBUG
	syslog(LOG_ERR,"Error reading configuration during mysql defaults");
#endif
	return NULL;
   }
   
   if( ((mysql_config->use_host = read_env("USE_HOST")) != NULL) &&
       (strncasecmp(mysql_config->use_host,"YES",3) == 0) ) {

	if((mysql_config->host_table = read_env("MYSQL_HOST_TABLE")) == NULL) {
#if AUTHMYSQL_DEBUG
	    syslog(LOG_ERR,"Error reading configuration during host defaults");
#endif
	    return NULL;
	}
   }

   return mysql_config;
}


char *_mysql_getuser(char *u, char *d, auth_mysql_config *mysql) {
    char *p;

    p = (char *)malloc(1024);

    if(strncasecmp(mysql->use_host,"YES",3) != 0) {

	snprintf( p , 1023 , "from %s WHERE %s.id='%s' and %s.mbox_host='%s' and \
%s.start_date<=curdate() and %s.expire_date>=curdate() and %s.active='Y'",
			      mysql->user_table,
			      mysql->user_table,u,
			      mysql->user_table,d,
			      mysql->user_table,
			      mysql->user_table,
			      mysql->user_table);

    } else {

	snprintf( p , 1023 , "%s.host from %s,%s WHERE %s.id = '%s' and \
%s.mbox_host = %s.domain and %s.start_date<=curdate() and \
%s.expire_date>=curdate() and %s.active='Y' \
HAVING concat(%s.host,'.',%s.mbox_host) = '%s' or %s.mbox_host = '%s'",
			 mysql->host_table,
			 mysql->user_table,
			 mysql->host_table,
                         mysql->user_table,
			 u,mysql->user_table,
			 mysql->host_table,mysql->user_table,
			 mysql->user_table,
			 mysql->user_table,mysql->host_table,
			 mysql->user_table,d,
			 mysql->user_table,d);

    }

    return p;
}


auth_mysql_user *auth_mysql_getuser(char *p, auth_mysql_config *mysql_config)
{
   MYSQL_ROW row;
   MYSQL_RES *result;
   char query[2048];
   char *where;
   char *username,*domain;
   auth_mysql_user *user_data;

   if((domain = strstr(p,"@")) != NULL)
   {
      
	   username = strtok(p,"@");
           domain ++;

	   where = _mysql_getuser(username,domain,mysql_config);
	   
   } else if((domain = strstr(p,"%")) != NULL)
   {

	   username = strtok(p,"%");
           domain ++;

	   where = _mysql_getuser(username,domain,mysql_config);

   } else if((domain = strstr(p,"|")) != NULL)
   {

	   username = strtok(p,"|");
           domain ++;

	   where = _mysql_getuser(username,domain,mysql_config);

   } else {

           where = _mysql_getuser(p,mysql_config->defdomain,mysql_config);

   }

   user_data = (auth_mysql_user *) malloc (sizeof(auth_mysql_user));
   if (!user_data)
   {
	perror("malloc");
	authexit (1);
   }
   user_data->username = 0;
   user_data->mailbox = 0;
   user_data->crypt = 0;
   user_data->shell = 0;
   user_data->uid = 0;
   user_data->gid = 0;
   

       sprintf( query, "SELECT DISTINCT %s.id,%s.crypt,%s.home,%s.shell,%s.uid\
,%s.gid,%s.mbox_host %s",
              mysql_config->user_table,mysql_config->user_table,
	      mysql_config->user_table,mysql_config->user_table,
	      mysql_config->user_table,mysql_config->user_table,
	      mysql_config->user_table,where);

       mysql_query (&auth_mysql_server, query);

       if(mysql_errno(&auth_mysql_server) != 0) {
#if AUTHMYSQL_DEBUG
           syslog(LOG_ERR,"Error during MySQL query: %s",mysql_error(&auth_mysql_server));
#endif
           return NULL;
       }
       
       result = mysql_store_result (&auth_mysql_server);       

       if (mysql_num_rows(result)) {
	    row = mysql_fetch_row (result);
	    user_data->username = row[0];
	    user_data->crypt = row[1];
	    user_data->mailbox = row[2];
	    user_data->shell = row[3];
	    user_data->uid = atoi(row[4]);
	    user_data->gid = atoi(row[5]);
	} else {
	    return NULL;
	}

	mysql_free_result(result);

	return user_data;

} 
