
static char rcsid[] = "@(#)$Id: date.c,v 1.4.4.1 1999/08/27 04:06:11 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** return the current date and time in a readable format! **/
/** also returns an ARPA RFC-822 format date...            **/


#include "headers.h"
#include "me.h"

#ifdef BSD_TYPE
#  include <sys/timeb.h>
#endif

#ifndef	_POSIX_SOURCE
extern struct tm *localtime();
extern struct tm *gmtime();
extern time_t	  time();
#endif

#define MONTHS_IN_YEAR	11	/* 0-11 equals 12 months! */
#define FEB		 1	/* 0 = January 		  */
#define DAYS_IN_LEAP_FEB 29	/* leap year only 	  */

#define ampm(n)		(n > 12? n - 12 : n)
#define am_or_pm(n)	(n > 11? (n > 23? "am" : "pm") : "am")
#define leapyear(year)	((year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0)))

char *arpa_dayname[] = { "Sun", "Mon", "Tue", "Wed", "Thu",
		  "Fri", "Sat", "" };

char *arpa_monname[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};

int  days_in_month[] = { 31,    28,    31,    30,    31,     30, 
		  31,     31,    30,   31,    30,     31,  -1};

void days_ahead(days, buffer, size)
     int days;
     char *buffer;
     int size;
{
	/** return in buffer the date (Day, Mon Day, Year) of the date
	    'days' days after today.  
	**/

	struct tm *the_time;		/* Time structure, see CTIME(3C) */
	time_t	   junk;		/* time in seconds....		 */

	junk = time((time_t *) 0);

	junk += days * 24 * 60 *60;
	the_time = localtime(&junk);


	elm_sfprintf(buffer, size,
		    FRM("%s, %d %s %d"),
		    arpa_dayname[the_time->tm_wday],
		    the_time->tm_mday,
		    arpa_monname[the_time->tm_mon],
		    1900+the_time->tm_year);
}

int
month_number(name)
char *name;
{
	/** return the month number given the month name... **/

	int ch;

	if (!isascii(name[0]))
	  return -1;

	switch (name[0]) {
	 case 'a' : 
	           if (!isascii(name[1]))
		     return -1;

	            if ((ch = tolower(name[1])) == 'p')	return(APRIL);
		    else if (ch == 'u') return(AUGUST);
		    else return(-1);	/* error! */
	
	 case 'd' : return(DECEMBER);
	 case 'f' : return(FEBRUARY);
	 case 'j' : 
	           if (!isascii(name[1]))
		     return -1;

                   if ((ch = tolower(name[1])) == 'a') return(JANUARY);
		    else if (ch == 'u') {
	              if ((ch = tolower(name[2])) == 'n') return(JUNE);
		      else if (ch == 'l') return(JULY);
		      else return(-1);		/* error! */
	            }
		    else return(-1);		/* error */
	 case 'm' : 
	           if (!isascii(name[1]))
		     return -1;

                    if ((ch = tolower(name[2])) == 'r') return(MARCH);
		    else if (ch == 'y') return(MAY);
		    else return(-1);		/* error! */
	 case 'n' : return(NOVEMBER);
	 case 'o' : return(OCTOBER);
	 case 's' : return(SEPTEMBER);
	 default  : return(-1);
	}
}

#ifdef SITE_HIDING

char *get_ctime_date()
{
	/** returns a ctime() format date, but a few minutes in the 
	    past...(more cunningness to implement hidden sites) **/

	static char buffer[SLEN];	/* static character buffer       */
	struct tm *the_time;		/* Time structure, see CTIME(3C) */

	time_t	   junk;		/* time in seconds....		 */

	junk = time((time_t *) 0);	

	junk -= 500 * rand();

	the_time = localtime(&junk);

	elm_sfprintf(buffer, sizeof buffer,
		     FRM("%s %s %d %02d:%02d:%02d %d"),
		     arpa_dayname[the_time->tm_wday],
		     arpa_monname[the_time->tm_mon],
		     the_time->tm_mday,
		     the_time->tm_hour,
		     the_time->tm_min,
		     the_time->tm_sec,
		     the_time->tm_year + 1900);
	
	return( (char *) buffer);
}

#endif

char *
elm_date_str(buf, seconds, size)
     char *buf;
     time_t seconds;
     int size;
{
	struct tm *tmbuf;

	tmbuf = gmtime(&seconds);

	elm_sfprintf(buf, size,
		     FRM("%s %d, %d %02d:%02d:%02d %s"),
		     arpa_monname[tmbuf->tm_mon],
		     tmbuf->tm_mday,
		     tmbuf->tm_year+1900,
		     ampm(tmbuf->tm_hour),
		     tmbuf->tm_min,
		     tmbuf->tm_sec,
		     am_or_pm(tmbuf->tm_hour));

	return(buf);
}

void make_menu_date(entry)
     struct header_rec *entry;
{
	struct tm *tmbuf;
	time_t seconds;

	seconds = entry->time_sent + entry->tz_offset;
	tmbuf = gmtime(&seconds);
	elm_sfprintf(entry->time_menu, sizeof entry->time_menu,
		     FRM("%3.3s %-2d"),
		     arpa_monname[tmbuf->tm_mon], tmbuf->tm_mday);
}
