/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "rc.h"

/* external variables */
extern gchar *spruceconf;                       /* spruce config file */
extern GList *filters;
extern gint NumMailboxes;
/* Identity */
extern gchar *SenderAddr;
extern gchar *ReplyTo;
extern gint use_rand_sig;
extern gint auto_attach_sig;
extern gchar *signaturefile;
/* Accounts */
extern gint NumAccounts;
extern accounts_t AccountsList[MAX_ACCOUNTS];
extern Server SmtpServer;
/* Appearance */
extern gchar *mesg_body_font;
extern gchar *unread_mesg_header_font;
extern gchar *read_mesg_header_font;
/* Misc */
extern gint save_outgoing;
extern gint empty_on_exit;
extern gint save_sizes;
extern gint cm_delay;
extern gint hdr_trim_level;
/* PGP */
extern gchar *pgp_identity;
extern gint use_gnupg;
extern gint pgp_sign;
extern gint encrypt_to_self;
extern gint store_passphrase;
extern gchar *pgp_passphrase;

extern GtkWidget *frmMain;


static gchar eoln = '\n';
static gchar comment = '#';


gint rc_save_defaults()
{
   GtkWidget *treelocalBoxes = get_widget(frmMain, "treelocalBoxes");
   GtkWidget *treespoolBoxes = get_widget(frmMain, "treespoolBoxes");
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   FILE *fp;
   gint i;
   gchar *mailbox;
   GList *tmp;
   struct filter *flt;
   
   fp = fopen(spruceconf, "wt");
   if (fp == NULL)
   {
      fprintf(stderr, "Spruce: %s failed to open for writing.\n", spruceconf);
      fprintf(stderr, "Please check with your local Administrator.\n");
      return 0;
   }
   chmod(spruceconf, 0600);

   fprintf(fp, "%c This is the Spruce initialization file.\n", comment);
   fprintf(fp, "%c Lines that start with a '%c' are comments.\n", comment, comment);
   fprintf(fp, "%c Blank lines are ignored.\n\n", comment);

   fprintf(fp, "%c Set the SMTP server information\n", comment);
   fprintf(fp, "smtp-server %s\n", SmtpServer.hostname);
   fprintf(fp, "smtp-port %d\n\n", SmtpServer.port);

   fprintf(fp, "%c Specify whether or not Spruce should save outgoing emails.\n", comment);
   fprintf(fp, "%c 0 = no, 1 = yes\n", comment);
   fprintf(fp, "save-outgoing %d\n\n", save_outgoing);

   fprintf(fp, "%c Set the user's name and address...\n", comment);
   fprintf(fp, "email-addr %s\n\n", SenderAddr);

   fprintf(fp, "%c Set the user's Reply-To address (assuming it differs from their email-addr)\n", comment);
   if (ReplyTo != NULL)
      fprintf(fp, "reply-to-addr %s\n\n", ReplyTo);
   else
      fprintf(fp, "%c reply-to-addr joe@sixpack.org\n\n", comment); 

   fprintf(fp, "%c Specify if you want Spruce to use a random signature.\n", comment);
   fprintf(fp, "%c 0 = off, 1 = on\n", comment);
   fprintf(fp, "use-rand-sig %d\n\n", use_rand_sig);

   fprintf(fp, "%c Auto attach signature\n", comment);
   fprintf(fp, "%c 0 = no, 1 = yes\n", comment);
   fprintf(fp, "auto-attach-sig %d\n\n", auto_attach_sig);

   fprintf(fp, "%c Specify the location of your personal signature file.\n", comment);
   fprintf(fp, "sig-file %s\n\n", signaturefile);

   fprintf(fp, "%c Message font (only affects the GUI client)\n", comment);
   if (mesg_body_font != NULL)
      fprintf(fp, "mesg-body-font %s\n\n", mesg_body_font);
   else
      fprintf(fp, "%c mesg-body-font\n\n", comment);

   fprintf(fp, "%c Unread message header font \n", comment);
   if (unread_mesg_header_font != NULL)
      fprintf(fp, "unread-mesg-header-font %s\n\n", unread_mesg_header_font);
   else
      fprintf(fp, "%c unread-mesg-header-font\n\n", comment);

   fprintf(fp, "%c Read message header font \n", comment);
   if (read_mesg_header_font != NULL)
      fprintf(fp, "read-mesg-header-font %s\n\n", read_mesg_header_font);
   else
      fprintf(fp, "%c read-mesg-header-font\n\n", comment);

   fprintf(fp, "%c List your mailboxes here.\n", comment);
   if (NumMailboxes && treelocalBoxes != NULL)
   {
      GList *items;

      items = GTK_TREE(treelocalBoxes)->children;
      while (items != NULL)
      {
      	gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(items->data))->child), &mailbox);
         fprintf (fp, "mailbox %s\n", mailbox);
         items = items->next;
      }
   }
   else
   {
      fprintf(fp, "mailbox Inbox\n");
      fprintf(fp, "mailbox Drafts\n");
      fprintf(fp, "mailbox Outbox\n");
      fprintf(fp, "mailbox Sent items\n");
      fprintf(fp, "mailbox Deleted items\n");
   }
   fprintf(fp, "\n");

   fprintf(fp, "%c List your spool mbox's here (aka /var/spool/mail).\n", comment);
   if (treespoolBoxes != NULL)
   {
      GList *items;

      items = GTK_TREE(treespoolBoxes)->children;

      if (items != NULL)
      {
         while (items != NULL)
         {
            gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(items->data))->child), &mailbox);
            fprintf (fp, "mbox-spool %s\n", mailbox);
            items = items->next;
         }
      }
      else
      {
         fprintf(fp, "mbox-spool /var/spool/mail/%s\n", getenv("USER"));
      }
   }
   else
   {
      fprintf(fp, "mbox-spool /var/spool/mail/%s\n", getenv("USER"));
   }
   fprintf(fp, "\n");

   fprintf(fp, "%c List your pop3 servers here in the following format:\n", comment);
   fprintf(fp, "%c pop3-server	hostname:port:mailbox:login:passwd:del\n", comment);
   fprintf(fp, "%c\n", comment);
   fprintf(fp, "%c Note: \"mailbox\" must be one of the listed mailboxes above.\n", comment);
   for(i = 0; i < NumAccounts; i++)
   {
      if (AccountsList[i].type == TYPE_POP3)
      	fprintf(fp, "pop3-server %s:%d:%s:%s:%s:%d\n", AccountsList[i].server.hostname,
              AccountsList[i].server.port, AccountsList[i].mailbox,
              AccountsList[i].login, AccountsList[i].passwd,
              AccountsList[i].delemail);
   }
   fprintf(fp, "\n");

   fprintf(fp, "%c List you imap servers here in the following format:\n", comment);
   fprintf(fp, "%c imap-server  hostname:port:login:passwd\n", comment);
   fprintf(fp, "%c\n", comment);
   i = 0;
   for (i = 0; i < NumAccounts; i++)
   {
   	if (AccountsList[i].type == TYPE_IMAP)
   		fprintf(fp, "imap-server %s:%d:%s:%s\n", AccountsList[i].server.hostname,
   			AccountsList[i].server.port, AccountsList[i].login,
   			AccountsList[i].passwd);
   }
   fprintf(fp, "\n");

   fprintf(fp, "%c Put filters here in the following format:\n", comment);
   fprintf(fp, "%c filter filtername^matchtext^in^action^to\n", comment);
   fprintf(fp, "%c\n", comment);
   fprintf(fp, "%c Note: We use such a strange delimiter because otherwise\n", comment);
   fprintf(fp, "%c       we cant use ':' in the match text\n", comment);

   tmp = filters;
   while(tmp != NULL)
   {
      flt = tmp->data;
      fprintf(fp, "filter %s^%s^%s^%d^%s\n", flt->name, flt->match, flt->in, flt->action, flt->to);
      tmp = tmp->next;
   }
   fprintf(fp, "\n");

   fprintf(fp, "%c Periodic mail check.\n", comment);
   fprintf(fp, "%c example: cm-delay XX\n", comment);
   fprintf(fp, "%c Spruce will check mail every XX minutes.\n", comment);
   fprintf(fp, "%c Note: 0 means to never auto-check mail.\n", comment);
   fprintf(fp, "cm-delay %d\n", cm_delay);
   fprintf(fp, "\n");

   fprintf(fp, "%c Amount of header to show\n", comment);
   fprintf(fp, "%c 0 = none, 1 = partial, 2 = full\n", comment);
   fprintf(fp, "hdr-trim-level %d\n", hdr_trim_level);
   fprintf(fp, "\n");

   fprintf(fp, "%c Specify if Spruce should empty the \"Deleted items\" folder on exit\n", comment);
   fprintf(fp, "%c 0 = no, 1 = yes\n", comment);
   fprintf(fp, "empty-on-exit %d\n", empty_on_exit);
   fprintf(fp, "\n");

   fprintf(fp, "%c Are we going to use these sizes?\n", comment);
   fprintf(fp, "save-sizes %d\n", save_sizes);
   fprintf(fp, "%c Spruce's window size and column sizes\n", comment);
   fprintf(fp, "spruce-sizes %d:%d", GTK_WIDGET(frmMain)->allocation.width, 
			  GTK_WIDGET(frmMain)->allocation.height);
   i = 0;
   while(i < GTK_CLIST(clistMail)->columns)
   {
      fprintf(fp, ":%d", GTK_CLIST(clistMail)->column[i].width);
      i++;
   }
   fprintf(fp, "\n\n");


   fprintf(fp, "%c PGP Encryption Information:\n%c\n", comment, comment);
   fprintf(fp, "%c PGP Identity\n", comment);
   fprintf(fp, "pgp-identity %s\n\n", pgp_identity);
   fprintf(fp, "%c Do we want to use gpg or pgp50i? (1 = gnupg, 0 = pgp50i)\n", comment);
   fprintf(fp, "use-gnupg %d\n\n", use_gnupg);
   fprintf(fp, "%c Sign outgoing PGP messages (0 = no, 1 = yes)\n", comment);
   fprintf(fp, "pgp-sign %d\n\n", pgp_sign);
   fprintf(fp, "%c Always encrypt to self? (0 = no, 1 = yes)\n", comment);
   fprintf(fp, "enrypt-to-self %d\n\n", encrypt_to_self);
   fprintf(fp, "%c Do you want to store the pgp passphrase? (0 = no, 1 = yes)\n", comment);
   fprintf(fp, "store-passphrase %d\n\n", store_passphrase);
   if (store_passphrase)
   {
      fprintf(fp, "%c PGP Passphrase:\n", comment);
      fprintf(fp, "pgp-passphrase %s\n\n", pgp_passphrase);
   }
   fprintf(fp, "\n");

   fprintf(fp, "%c End of Spruce initialization file.", comment);

   fclose(fp);
	
   return 1;
}

gint rc_read_defaults()
{
   FILE *fp;
   gchar buffer[256];

   fp = fopen(spruceconf, "rt");
   if (fp == NULL)
   {
      fprintf(stderr, "Spruce: %s failed to open for reading.\n", spruceconf);
      fprintf(stderr, "Please check with your local Administrator.\n");
      return 0;
   }

   while (!feof(fp))
   {
      fgets(buffer, 256, fp);
      trim_leadspc(buffer);
      if (buffer[0] != eoln && buffer[0] != comment)
      {
         if (!strncmp("smtp-server", buffer, strlen("smtp-server")))
         {
            strcut(buffer, 0, strlen("smtp-server"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))   /* if it's NULL, let it be */
               continue;
            if (SmtpServer.hostname != NULL)
               g_free(SmtpServer.hostname);
            SmtpServer.hostname = g_strdup(buffer);
            continue;
         }
         if (!strncmp("smtp-port", buffer, strlen("smtp-port")))
         {
            strcut(buffer, 0, strlen("smtp-port"));
            trim_whtspc(buffer);
            SmtpServer.port = atoi(buffer);
            continue;
         }
         if (!strncmp("save-outgoing", buffer, strlen("save-outgoing")))
         {
            strcut(buffer, 0, strlen("save-outgoing"));
            trim_whtspc(buffer);
            save_outgoing = atoi(buffer);
            continue;
         }
         if (!strncmp("email-addr", buffer, strlen("email-addr")))
         {
            strcut(buffer, 0, strlen("email-addr"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))   /* if it's NULL, let it be */
               continue;
            if (SenderAddr != NULL)
               g_free(SenderAddr);
            SenderAddr = g_strdup(buffer);
            continue;
         }
         if (!strncmp("reply-to-addr", buffer, strlen("reply-to-addr")))
         {
            strcut(buffer, 0, strlen("reply-to-addr"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))   /* if it's NULL, let it be */
               continue;
            if (ReplyTo != NULL)
               g_free(ReplyTo);
            ReplyTo = g_strdup(buffer);
            continue;
         }
         if (!strncmp("use-rand-sig", buffer, strlen("use-rand-sig")))
         {
            strcut(buffer, 0, strlen("use-rand-sig"));
            trim_whtspc(buffer);
            use_rand_sig = atoi(buffer);
            continue;
         }
         if (!strncmp("auto-attach-sig", buffer, strlen("auto-attach-sig")))
         {
            strcut(buffer, 0, strlen("auto-attach-sig"));
            trim_whtspc(buffer);
            auto_attach_sig = atoi(buffer);
            continue;
         }
         if (!strncmp("sig-file", buffer, strlen("sig-file")))
         {
            strcut(buffer, 0, strlen("sig-file"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))   /* if it's NULL, let it be */
               continue;
            if (signaturefile != NULL)
               g_free(signaturefile);
            signaturefile = g_strdup(buffer);
            continue;
         }
         if (!strncmp("cm-delay", buffer, strlen("cm-delay")))
         {
            strcut(buffer, 0, strlen("cm-delay"));
            trim_whtspc(buffer);
            cm_delay = atoi(buffer);
            continue;
         }
         if (!strncmp("hdr-trim-level", buffer, strlen("hdr-trim-level")))
         {
            strcut(buffer, 0, strlen("hdr-trim-level"));
            trim_whtspc(buffer);
            hdr_trim_level = atoi(buffer);
            continue;
         }
         if (!strncmp("empty-on-exit", buffer, strlen("empty-on-exit")))
         {
            strcut(buffer, 0, strlen("empty-on-exit"));
            trim_whtspc(buffer);
            empty_on_exit = atoi(buffer);
            continue;
         }
         if (!strncmp("pgp-identity", buffer, strlen("pgp-identity")))
         {
            strcut(buffer, 0, strlen("pgp-identity"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))  /* if it's NULL, leave it be */
               continue;
            if (pgp_identity != NULL)
               g_free(pgp_identity);
            pgp_identity = g_strdup(buffer);
            continue;
         }
         if (!strncmp("use-gnupg", buffer, strlen("use-gnupg")))
         {
            strcut(buffer, 0, strlen("use-gnupg"));
            trim_whtspc(buffer);
            use_gnupg = atoi(buffer);
            continue;
         }
         if (!strncmp("pgp-sign", buffer, strlen("pgp-sign")))
         {
            strcut(buffer, 0, strlen("pgp-sign"));
            trim_whtspc(buffer);
            pgp_sign = atoi(buffer);
            continue;
         }
         if (!strncmp("encrypt-to-self", buffer, strlen("encrypt-to-self")))
         {
            strcut(buffer, 0, strlen("encrypt-to-self"));
            trim_whtspc(buffer);
            encrypt_to_self = atoi(buffer);
            continue;
         }
         if (!strncmp("store-passphrase", buffer, strlen("store-passphrase")))
         {
            strcut(buffer, 0, strlen("store-passphrase"));
            trim_whtspc(buffer);
            store_passphrase = atoi(buffer);
            continue;
         }
         if (!strncmp("pgp-passphrase", buffer, strlen("pgp-passphrase")))
         {
            strcut(buffer, 0, strlen("pgp-passphrase"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))  /* if it's NULL, leave it be */
               continue;
            if (pgp_passphrase != NULL)
               g_free(pgp_passphrase);
            pgp_passphrase = g_strdup(buffer);
            continue;
         }
         if (!strncmp("mesg-body-font", buffer, strlen("mesg-body-font")))
         {
            strcut(buffer, 0, strlen("mesg-body-font"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))  /* if it's NULL, leave it be */
               continue;
            if (mesg_body_font != NULL)
               g_free(mesg_body_font);
            mesg_body_font = g_strdup(buffer);
            continue;
         }

         if (!strncmp("unread-mesg-header-font", buffer, strlen("unread-mesg-header-font")))
         {
            strcut(buffer, 0, strlen("unread-mesg-header-font"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))  /* if it's NULL, leave it be */
               continue;
            if (unread_mesg_header_font != NULL)
               g_free(unread_mesg_header_font);
            unread_mesg_header_font = g_strdup(buffer);
            continue;
         }
	
         if (!strncmp("read-mesg-header-font", buffer, strlen("read-mesg-header-font")))
         {
            strcut(buffer, 0, strlen("read-mesg-header-font"));
            trim_whtspc(buffer);
            if (!strcmp("", buffer))  /* if it's NULL, leave it be */
               continue;
            if (read_mesg_header_font != NULL)
               g_free(read_mesg_header_font);
            read_mesg_header_font = g_strdup(buffer);
            continue;
         }

         if (!strncmp("save-sizes", buffer, strlen("save-sizes")))
         {
            strcut(buffer, 0, strlen("save-sizes"));
            trim_whtspc(buffer);
            save_sizes = atoi(buffer);
            continue;
         }
      }
   }

   fclose(fp);
   return 1;
}
