/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * print.c
 */

/*
 * Create PRINT postmaster object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <constants.h>
#include <defaults.h>
#include <pm.h>

#include <utilities.h>
#include "modellib.h"
#include "view.h"

int print_go(int force); /* defined in print_procs.c */

static void print_reset(void);

static char *PRINT_OBJ_NAME  = "Print";

static char *PRINT[] = {
  "Print.Owner",
  "Print.Hor_Label",
  "Print.Ver_Label",
  "Print.Title",
  "Print.Color_Flag",
  "Print.File_Flag",
  "Print.Directory",
  "Print.Filename",
  "Print.Printer_Name",
  "Print.Show_Settings",
  "Print.Show_Info",
  "Print.Font",
  "Print.Title_Pt",
  "Print.Label_Pt",
  "Print.Landscape",
  "Print.BBox_Ver_Length",
  "Print.BBox_Hor_Length",
  "Print.BBox_Ver_Offset",
  "Print.BBox_Hor_Offset",
  "Print.Num_Hor_Ticks",
  "Print.Num_Ver_Ticks",
  "Print.Connect",
  "Print.Label_Range",
  "Print.Show_BBox",
  "Print.HorMin",
  "Print.HorMax",
  "Print.VerMin",
  "Print.VerMax",
  "Print.HorType",
  "Print.HorIndex",
  "Print.VerType",
  "Print.VerIndex",
  "Print.Pick_Color",
  "Print.Go",
  "Print.Reset",
};

typedef enum {
  OWNER=0, HOR_LABEL, VER_LABEL, TITLE, COLOR_FLAG, FILE_FLAG,
  DIRECTORY, FILENAME, PRINT_NAME, SHOW_SETTINGS, SHOW_INFO,
  FONT, TITLE_PT, LABEL_PT, LANDSCAPE, BBOX_VER_LENGTH,
  BBOX_HOR_LENGTH, BBOX_VER_OFFSET, BBOX_HOR_OFFSET,
  NUM_HOR_TICKS, NUM_VER_TICKS, CONNECT,
  LABEL_RANGE, SHOW_BBOX, HORMIN, HORMAX, VERMIN, VERMAX, 
  HORTYPE, HORINDEX, VERTYPE, VERINDEX, 
  PICKCOLOR, GO, 
  RESET
  } PRINT_t;

void 
  print_install()
{
  pm(CREATE_OBJ, PRINT_OBJ_NAME,
     CREATE_ELEM, PRINT[OWNER], INT,
     CREATE_ELEM, PRINT[HOR_LABEL], STRNG,
     CREATE_ELEM, PRINT[VER_LABEL], STRNG,
     CREATE_ELEM, PRINT[TITLE], STRNG,
     CREATE_ELEM, PRINT[COLOR_FLAG], INT,
     CREATE_ELEM, PRINT[FILE_FLAG], INT,
     CREATE_ELEM, PRINT[DIRECTORY], STRNG,
     CREATE_ELEM, PRINT[FILENAME], STRNG,
     CREATE_ELEM, PRINT[PRINT_NAME], STRNG,
     CREATE_ELEM, PRINT[SHOW_SETTINGS], INT,
     CREATE_ELEM, PRINT[SHOW_INFO], INT,
     CREATE_ELEM, PRINT[FONT], INT,
     CREATE_ELEM, PRINT[TITLE_PT], INT,
     CREATE_ELEM, PRINT[LABEL_PT], INT,
     CREATE_ELEM, PRINT[LANDSCAPE], INT,
     CREATE_ELEM, PRINT[BBOX_VER_LENGTH], INT,
     CREATE_ELEM, PRINT[BBOX_HOR_LENGTH], INT,
     CREATE_ELEM, PRINT[BBOX_VER_OFFSET], INT,
     CREATE_ELEM, PRINT[BBOX_HOR_OFFSET], INT,
     CREATE_ELEM, PRINT[NUM_HOR_TICKS], INT,
     CREATE_ELEM, PRINT[NUM_VER_TICKS], INT,
     CREATE_ELEM, PRINT[CONNECT], INT,
     CREATE_ELEM, PRINT[LABEL_RANGE], INT,
     CREATE_ELEM, PRINT[SHOW_BBOX], INT,
     CREATE_ELEM, PRINT[HORMIN], DBL,
     CREATE_ELEM, PRINT[HORMAX], DBL,
     CREATE_ELEM, PRINT[VERMIN], DBL,
     CREATE_ELEM, PRINT[VERMAX], DBL,
     CREATE_ELEM, PRINT[HORTYPE], INT,
     CREATE_ELEM, PRINT[HORINDEX], INT,
     CREATE_ELEM, PRINT[VERTYPE], INT,
     CREATE_ELEM, PRINT[VERINDEX], INT,
     CREATE_ELEM, PRINT[PICKCOLOR], INT,
     CREATE_ELEM, PRINT[GO], FNCT,
     CREATE_ELEM, PRINT[RESET], FNCT,
     NULL);

  pm(INIT, "Print.Title",     MAX_LEN_DS_TITLE,
     INIT, "Print.Hor_Label", MAX_LEN_VARB_NAME,
     INIT, "Print.Ver_Label", MAX_LEN_VARB_NAME,
     INIT, "Print.Directory", ( SIZE_OF_DIR_PLUS_FNAME - SIZE_OF_FNAME ),
     INIT, "Print.Filename",  SIZE_OF_FNAME,
     INIT, "Print.Printer_Name", SIZE_OF_FNAME,
     INIT, "Print.Go", 
     PUT, "Print.Go", print_go, 
     INIT, "Print.Reset", 
     PUT, "Print.Reset", print_reset, 
     PUT, "Print.HorType", VARB, 
     PUT, "Print.HorIndex", 0, 
     PUT, "Print.VerType", VARB, 
     PUT, "Print.VerIndex", 1, 
     PUT, PRINT[PICKCOLOR], 0,
     NULL);

}


void 
print_reset()
{
  char  dirname[SIZE_OF_DIR_PLUS_FNAME];
  char* env_value;
  char  hor_label[MAX_LEN_VARB_NAME];
  char  ver_label[MAX_LEN_VARB_NAME];

  double  hor_max;
  double  hor_min;
  double  ver_max;
  double  ver_min;

  if ( (env_value = getenv("LPDEST")) != NULL) {
    /* use environmental variable LPDEST defined */
    strcpy(dirname, env_value); 
    pm(PUT, "Print.Printer_Name", dirname, NULL); 
  }
  else if ( (env_value = getenv("PRINTER")) != NULL) {
    /* use environmental variable PRINTER defined */
    strcpy(dirname, env_value); 
    pm(PUT, "Print.Printer_Name", dirname, NULL); 
  }
  else {							
    /* (see "man lpstat" and dir_util.c) use PRINTER_NAME from defaults.h */
    pm(PUT, "Print.Printer_Name", PRINTER_NAME, NULL); 
  }

  get_cwd(dirname, SIZE_OF_DIR_PLUS_FNAME);	/* get defaults from system */

  pm(GET, "Model.Varb_Names", 0, hor_label, NULL);
  pm(GET, "Model.Varb_Names", 1, ver_label, NULL);

  pm(PUT, "Print.Title", get_ds_name(),

    /*
     PUT, "Print.Owner", -1, 
     */

     PUT, "Print.Hor_Label", hor_label,
     PUT, "Print.Ver_Label", ver_label, 

     PUT, "Print.File_Flag", TRUE, 
     PUT, "Print.Color_Flag", FALSE,
     PUT, "Print.Directory", dirname,

     /* leave Filename empty */
     PUT, "Print.Filename", "test.ps",

     PUT, "Print.Show_Settings", FALSE,
     PUT, "Print.Show_Info", TRUE,
     PUT, "Print.Font", 0,
     PUT, "Print.Title_Pt", TITLE_PT_SIZE,
     PUT, "Print.Label_Pt", LABEL_PT_SIZE,
     PUT, "Print.Landscape", FALSE,
     PUT, "Print.Show_BBox", TRUE,
     PUT, "Print.Num_Hor_Ticks", NUM_X_TICKS,
     PUT, "Print.Num_Ver_Ticks", NUM_Y_TICKS,
     PUT, "Print.BBox_Hor_Length", BBOX_HOR_LEN,
     PUT, "Print.BBox_Ver_Length", BBOX_VER_LEN,
     PUT, "Print.BBox_Hor_Offset", BBOX_HOR_OFF,
     PUT, "Print.BBox_Ver_Offset", BBOX_VER_OFF,
     PUT, "Print.Connect", FALSE,
     PUT, "Print.Label_Range", TRUE,
     PUT, "Print.Pick_Color", FALSE,

     PUT, "Print.HorMax", *((double *) pm(GET, "Model.Varb_Max", 0, NULL)), 
     PUT, "Print.HorMin", *((double *) pm(GET, "Model.Varb_Min", 0, NULL)), 
     PUT, "Print.VerMax", *((double *) pm(GET, "Model.Varb_Max", 1, NULL)), 
     PUT, "Print.VerMin", *((double *) pm(GET, "Model.Varb_Min", 1, NULL)), 
     NULL);

}









