/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef MESHPDEF
#define MESHPDEF

#include "geomclass.h"
#include "mesh.h"

struct Mesh {
	GEOMFIELDS
	int	flag;
	int 	seq;
	int	nu, nv;
	int	umin, umax, vmin, vmax;
	HPoint3	*p;
	Point3 	*n, *u;
	ColorA	*c;
	float	*d;
	Point3	*nd;
};

#define nuverts(m) (m)->nu
#define nvverts(m) (m)->nv
#define nuquads(m) (((m)->flag & MESH_UWRAP) ? (m)->nu : (m)->nu - 1)
#define nvquads(m) (((m)->flag & MESH_VWRAP) ? (m)->nv : (m)->nv - 1)

/*
 * MESHINDEX(u, v, mesh)
 * Returns the index of a point into the mesh->array given its u & v 
 * coordinates.
 */
#define MESHINDEX(u, v, mesh) \
  (((v)%(mesh)->nv)*(mesh)->nu + ((u)%(mesh)->nu))

/* 
 * MESHPOINT(u, v, mesh, plist)
 * Returns plist[MESHINDEX(u, v, mesh)]
 */
#define MESHPOINT(u, v, mesh, plist) \
  ((plist)[MESHINDEX(u, v, mesh)])

#endif /* ! MESHPDEF */
