/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef REFCOMMDEF
#define REFCOMMDEF

/*
 * Public definitions for Reference & Communications package
 */

#define REFERENCEFIELDS	\
    int magic;		\
    int ref_count;	\
    struct Handle *handle;

typedef struct Ref  {
    REFERENCEFIELDS
} Ref ;

#define	REFINCR(type, obj)	(type *)RefIncr((Ref *)(obj))
#define	REFDECR(obj)		RefDecr((Ref *)(obj))

extern void RefInit( Ref *, long magic );	/* Initializes a Reference */
extern int  RefCount( Ref * );		/* Returns current ref count */
extern Ref *RefIncr( Ref * );		/* Increments count, returns object */
extern int  RefDecr( Ref * );		/* Decrements count, returns it  */
extern int  RefMagic( Ref * );		/* Returns magic number */

#endif
