/* routines for making sure matrix is orthogonal in Minkowski metric */
#include "3d.h"

/* row-orthogonalize an isometry of Minkowski space */
void
tuneup(Transform m1, int metric)
{
    int i,j,k;
    float d; 
    HPoint3 pt0;

    HPt3SpaceNormalize((HPoint3 *)m1[0], metric);

    HPt3SpaceGramSchmidt((HPoint3 *)m1[0], (HPoint3 *)m1[1], metric);
    HPt3SpaceNormalize((HPoint3 *)m1[1], metric);

    HPt3SpaceGramSchmidt((HPoint3 *)m1[0], (HPoint3 *)m1[2], metric);
    HPt3SpaceGramSchmidt((HPoint3 *)m1[1], (HPoint3 *)m1[2], metric);
    HPt3SpaceNormalize((HPoint3 *)m1[2], metric);

    HPt3SpaceGramSchmidt((HPoint3 *)m1[0], (HPoint3 *)m1[3], metric);
    HPt3SpaceGramSchmidt((HPoint3 *)m1[1], (HPoint3 *)m1[3], metric);
    HPt3SpaceGramSchmidt((HPoint3 *)m1[2], (HPoint3 *)m1[3], metric);
    HPt3SpaceNormalize((HPoint3 *)m1[3], metric);
	
}

/*  following only works now with hyperbolic mode */
int
needstuneup(Transform m1)
{
    int i,j,k;
    float d;

    for (i=0; i<4; ++i)
	for (j=i; j<4; ++j)
	    {
    	    d =	m1[i][0] * m1[j][0] +
		m1[i][1] * m1[j][1] +
		m1[i][2] * m1[j][2] -
		m1[i][3] * m1[j][3]; 
	    if (i == 3) d *= -1;
	    if (fabs ( d - ( i == j ) ) > .01 ) return (1);
	    }
    return (0);
}
