%%NAME
%%  eview  -  start ghostview to show eps-file 
%%
%%SYNOPSIS
%%  eview([epsFileName])
%%
%%PARAMETER(S)
%%  epsFileName    name of eps-file
%%                 default: string of global parameter 'eFileName' 
%%GLOBAL PARAMETER(S)
%%  eFileName
%written by stefan.mueller stefan.mueller@fgan.de
function eview(epsFileName)
  if nargin>1
    usage('eview([epsFileName])');
  end
  eglobpar;
  if nargin<1
    epsFileName=eFileName;
  end
  
  if exist('matlabpath')~=5
    % octave configuration with unix or linux
    if rem(ePageOrientation,2)
      orientation='-landscape';
    else
      orientation='';
    end
    gsview=sprintf('ghostview %s -magstep -1 %s &',orientation,epsFileName);
    system(gsview);
  else
    % matlab configuration with windows
    gsview=sprintf('c:\\gstools\\gsview\\gsview32.exe %s',epsFileName);
    unix(gsview);
  end
